'use strict';



;define("sodstatus/adapters/-json-api", ["exports", "@ember-data/adapter/json-api"], function (_exports, _jsonApi) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _jsonApi.default;
    }
  });
});
;define("sodstatus/adapters/application", ["exports", "@ember-data/adapter/json-api"], function (_exports, _jsonApi) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  class ApplicationAdapter extends _jsonApi.default {
    constructor(...args) {
      super(...args);

      _defineProperty(this, "namespace", 'api');
    }

    shouldBackgroundReloadAll(store, snapshotsArray) {
      return true;
    }

  }

  _exports.default = ApplicationAdapter;
});
;define("sodstatus/app", ["exports", "ember-resolver", "ember-load-initializers", "sodstatus/config/environment"], function (_exports, _emberResolver, _emberLoadInitializers, _environment) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  class App extends Ember.Application {
    constructor(...args) {
      super(...args);

      _defineProperty(this, "modulePrefix", _environment.default.modulePrefix);

      _defineProperty(this, "podModulePrefix", _environment.default.podModulePrefix);

      _defineProperty(this, "Resolver", _emberResolver.default);
    }

  }

  _exports.default = App;
  (0, _emberLoadInitializers.default)(App, _environment.default.modulePrefix);
});
;define("sodstatus/component-managers/glimmer", ["exports", "@glimmer/component/-private/ember-component-manager"], function (_exports, _emberComponentManager) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _emberComponentManager.default;
    }
  });
});
;define("sodstatus/components/-lf-get-outlet-state", ["exports", "liquid-fire/components/-lf-get-outlet-state"], function (_exports, _lfGetOutletState) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _lfGetOutletState.default;
    }
  });
});
;define("sodstatus/components/array-path-layer", ["exports", "ember-leaflet/components/array-path-layer"], function (_exports, _arrayPathLayer) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _arrayPathLayer.default;
    }
  });
});
;define("sodstatus/components/base-layer", ["exports", "ember-leaflet/components/base-layer"], function (_exports, _baseLayer) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _baseLayer.default;
    }
  });
});
;define("sodstatus/components/circle-layer", ["exports", "ember-leaflet/components/circle-layer"], function (_exports, _circleLayer) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _circleLayer.default;
    }
  });
});
;define("sodstatus/components/circle-marker-layer", ["exports", "ember-leaflet/components/circle-marker-layer"], function (_exports, _circleMarkerLayer) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _circleMarkerLayer.default;
    }
  });
});
;define("sodstatus/components/container-layer", ["exports", "ember-leaflet/components/container-layer"], function (_exports, _containerLayer) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _containerLayer.default;
    }
  });
});
;define("sodstatus/components/div-overlay-layer", ["exports", "ember-leaflet/components/div-overlay-layer"], function (_exports, _divOverlayLayer) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _divOverlayLayer.default;
    }
  });
});
;define("sodstatus/components/geojson-layer", ["exports", "ember-leaflet/components/geojson-layer"], function (_exports, _geojsonLayer) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _geojsonLayer.default;
    }
  });
});
;define("sodstatus/components/illiquid-model", ["exports", "liquid-fire/components/illiquid-model"], function (_exports, _illiquidModel) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _illiquidModel.default;
    }
  });
});
;define("sodstatus/components/image-layer", ["exports", "ember-leaflet/components/image-layer"], function (_exports, _imageLayer) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _imageLayer.default;
    }
  });
});
;define("sodstatus/components/interactive-layer", ["exports", "ember-leaflet/components/interactive-layer"], function (_exports, _interactiveLayer) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _interactiveLayer.default;
    }
  });
});
;define("sodstatus/components/leaflet-map", ["exports", "ember-leaflet/components/leaflet-map"], function (_exports, _leafletMap) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _leafletMap.default;
    }
  });
});
;define("sodstatus/components/liquid-bind", ["exports", "liquid-fire/components/liquid-bind"], function (_exports, _liquidBind) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _liquidBind.default;
    }
  });
});
;define("sodstatus/components/liquid-child", ["exports", "liquid-fire/components/liquid-child"], function (_exports, _liquidChild) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _liquidChild.default;
    }
  });
});
;define("sodstatus/components/liquid-container", ["exports", "liquid-fire/components/liquid-container"], function (_exports, _liquidContainer) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _liquidContainer.default;
    }
  });
});
;define("sodstatus/components/liquid-if", ["exports", "liquid-fire/components/liquid-if"], function (_exports, _liquidIf) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _liquidIf.default;
    }
  });
});
;define("sodstatus/components/liquid-measured", ["exports", "liquid-fire/components/liquid-measured"], function (_exports, _liquidMeasured) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _liquidMeasured.default;
    }
  });
  Object.defineProperty(_exports, "measure", {
    enumerable: true,
    get: function () {
      return _liquidMeasured.measure;
    }
  });
});
;define("sodstatus/components/liquid-outlet", ["exports", "liquid-fire/components/liquid-outlet"], function (_exports, _liquidOutlet) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _liquidOutlet.default;
    }
  });
});
;define("sodstatus/components/liquid-spacer", ["exports", "liquid-fire/components/liquid-spacer"], function (_exports, _liquidSpacer) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _liquidSpacer.default;
    }
  });
});
;define("sodstatus/components/liquid-sync", ["exports", "liquid-fire/components/liquid-sync"], function (_exports, _liquidSync) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _liquidSync.default;
    }
  });
});
;define("sodstatus/components/liquid-unless", ["exports", "liquid-fire/components/liquid-unless"], function (_exports, _liquidUnless) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _liquidUnless.default;
    }
  });
});
;define("sodstatus/components/liquid-versions", ["exports", "liquid-fire/components/liquid-versions"], function (_exports, _liquidVersions) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _liquidVersions.default;
    }
  });
});
;define("sodstatus/components/marker-layer", ["exports", "ember-leaflet/components/marker-layer"], function (_exports, _markerLayer) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _markerLayer.default;
    }
  });
});
;define("sodstatus/components/measurements/letter-grade", ["exports", "@glimmer/component"], function (_exports, _component) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _class, _descriptor, _descriptor2, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  const __COLOCATED_TEMPLATE__ = Ember.HTMLBars.template(
  /*
    
  <span>Letter Grade: "{{@tool.name}}"</span>
  {{#each gradeList as |gradeLetter|}}
    <label for={{gradeLetter}}>
      <Input {{on "click" (fn this.changeLetterGrade gradeLetter)}} @type="checkbox" name="grade" id={{gradeLetter}} @checked={{eq currMeasurement.value gradeLetter}} />
      <span>{{gradeLetter}}</span>
    </label>
  
  {{/each}}
  
  {{yield}}
  
  */
  {
    id: "Ug5RWcmY",
    block: "{\"symbols\":[\"gradeLetter\",\"@tool\",\"&default\"],\"statements\":[[0,\"\\n\"],[7,\"span\",true],[8],[0,\"Letter Grade: \\\"\"],[1,[23,2,[\"name\"]],false],[0,\"\\\"\"],[9],[0,\"\\n\"],[4,\"each\",[[24,[\"gradeList\"]]],null,{\"statements\":[[0,\"  \"],[7,\"label\",true],[11,\"for\",[23,1,[]]],[8],[0,\"\\n    \"],[5,\"input\",[[12,\"name\",\"grade\"],[12,\"id\",[23,1,[]]],[3,\"on\",[\"click\",[28,\"fn\",[[23,0,[\"changeLetterGrade\"]],[23,1,[]]],null]]]],[[\"@type\",\"@checked\"],[\"checkbox\",[28,\"eq\",[[24,[\"currMeasurement\",\"value\"]],[23,1,[]]],null]]]],[0,\"\\n    \"],[7,\"span\",true],[8],[1,[23,1,[]],false],[9],[0,\"\\n  \"],[9],[0,\"\\n\\n\"]],\"parameters\":[1]},null],[0,\"\\n\"],[14,3],[0,\"\\n\"]],\"hasEval\":false}",
    meta: {
      moduleName: "sodstatus/components/measurements/letter-grade.hbs"
    }
  });

  const UNGRADED = 'ungraded';
  let MeasurementsLetterGradeComponent = (_class = (_temp = class MeasurementsLetterGradeComponent extends _component.default {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "store", _descriptor, this);

      _defineProperty(this, "gradeList", ['A', 'B', 'F', UNGRADED]);

      _initializerDefineProperty(this, "measurement", _descriptor2, this);
    }

    didRender() {
      // check measuement object created for this tool
      const tool = this.args.tool;
      const curr = this.args.curr;
      let measurements = curr.get('measurements');
      let m = measurements.find(m => m.get('name') === tool.get('name'));

      if (typeof m === 'undefined') {
        throw new Error("Measurement for tool: " + tool.get('name') + " is undefined.");
      } else {
        this.measurement = m;
      }
    }

    get currMeasurement() {
      const tool = this.args.tool;
      const curr = this.args.curr;
      let measurements = curr.get('measurements');

      if (!measurements) {
        return null;
      }

      let m = measurements.find(m => m.get('name') === tool.get('name'));
      return m;
    }

    changeLetterGrade(val) {
      let meas = this.args.measurement; //let meas = this.get('measurement');

      if (!meas) {
        const tool = this.args.tool;
        const curr = this.args.curr;
        const perusal = this.args.perusal;
        const record = this.store.createRecord('measurement', {
          name: tool.name,
          quakeStation: curr,
          perusal: perusal,
          value: val
        });
        record.save();
        curr.get('measurements').pushObject(record);
      }
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "store", [Ember.inject.service], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, "measurement", [Ember._tracked], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: function () {
      return null;
    }
  }), _applyDecoratedDescriptor(_class.prototype, "changeLetterGrade", [Ember._action], Object.getOwnPropertyDescriptor(_class.prototype, "changeLetterGrade"), _class.prototype)), _class);
  _exports.default = MeasurementsLetterGradeComponent;

  Ember._setComponentTemplate(__COLOCATED_TEMPLATE__, MeasurementsLetterGradeComponent);
});
;define("sodstatus/components/menu-bar", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  const __COLOCATED_TEMPLATE__ = Ember.HTMLBars.template(
  /*
    <div class="menubar">
  <h1><LinkTo @route="index">SOD Status</LinkTo></h1>
  
  <nav>
    <LinkTo @route="recipe">Recipe</LinkTo>
    <LinkTo @route="arms">Arms</LinkTo>
    <LinkTo @route="networks">Networks</LinkTo>
    <LinkTo @route="quakes">Quakes</LinkTo>
    <LinkTo @route="perusals">Perusals</LinkTo>
  </nav>
  
  </div>
  {{yield}}
  
  */
  {
    id: "rXYtAkPi",
    block: "{\"symbols\":[\"&default\"],\"statements\":[[7,\"div\",true],[10,\"class\",\"menubar\"],[8],[0,\"\\n\"],[7,\"h1\",true],[8],[5,\"link-to\",[],[[\"@route\"],[\"index\"]],{\"statements\":[[0,\"SOD Status\"]],\"parameters\":[]}],[9],[0,\"\\n\\n\"],[7,\"nav\",true],[8],[0,\"\\n  \"],[5,\"link-to\",[],[[\"@route\"],[\"recipe\"]],{\"statements\":[[0,\"Recipe\"]],\"parameters\":[]}],[0,\"\\n  \"],[5,\"link-to\",[],[[\"@route\"],[\"arms\"]],{\"statements\":[[0,\"Arms\"]],\"parameters\":[]}],[0,\"\\n  \"],[5,\"link-to\",[],[[\"@route\"],[\"networks\"]],{\"statements\":[[0,\"Networks\"]],\"parameters\":[]}],[0,\"\\n  \"],[5,\"link-to\",[],[[\"@route\"],[\"quakes\"]],{\"statements\":[[0,\"Quakes\"]],\"parameters\":[]}],[0,\"\\n  \"],[5,\"link-to\",[],[[\"@route\"],[\"perusals\"]],{\"statements\":[[0,\"Perusals\"]],\"parameters\":[]}],[0,\"\\n\"],[9],[0,\"\\n\\n\"],[9],[0,\"\\n\"],[14,1],[0,\"\\n\"]],\"hasEval\":false}",
    meta: {
      moduleName: "sodstatus/components/menu-bar.hbs"
    }
  });

  var _default = Ember._setComponentTemplate(__COLOCATED_TEMPLATE__, Ember._templateOnlyComponent());

  _exports.default = _default;
});
;define("sodstatus/components/path-layer", ["exports", "ember-leaflet/components/path-layer"], function (_exports, _pathLayer) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _pathLayer.default;
    }
  });
});
;define("sodstatus/components/perusals/edit-form", ["exports", "@glimmer/component"], function (_exports, _component) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _class, _descriptor, _descriptor2, _descriptor3, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  const __COLOCATED_TEMPLATE__ = Ember.HTMLBars.template(
  /*
    <form {{action "save" on="submit"}}>
  <h2 class="errorMessage">{{errorMessage}}</h2>
    <p>
      <label> Name:
        <Input @value={{mut @perusal.name}}/>
      </label>
    </p>
    <p>
      <label>User Name:
        <Input @value={{mut @perusal.username}}/>
      </label>
    </p>
    <p>Event Sort:
    <div>
      <Input {{on "click" (action (mut @perusal.eventSort) "time")}} type="radio" name="eventSort" checked=true /> <label><span class="checkable">Time</span></label>
      <Input {{on "click" (action (mut @perusal.eventSort) "mag")}}  type="radio" name="eventSort"/> <label><span class="checkable">Mag</span></label>
      <Input {{on "click" (action (mut @perusal.eventSort) "distance")}}  type="radio" name="eventSort"/> <label><span class="checkable">Distance</span></label>
    </div>
    </p>
    <p>Station Sort:
    <div>
      <Input {{on "click" (action (mut @perusal.stationSort) "alpha")}} type="radio" name="stationSort" checked=true /> <label><span class="checkable">Alphabetical</span></label>
      <Input {{on "click" (action (mut @perusal.stationSort) "distance")}}  type="radio" name="stationSort"/> <label><span class="checkable">Distance</span></label>
    </div>
    </p>
    <p>Primary Sort:
      <div>
        <Input {{on "click" (action (mut @perusal.primarySort) "quake")}} type="radio" name="primarySort" checked=true /> <label><span class="checkable">Quake</span></label>
        <Input {{on "click" (action (mut @perusal.primarySort) "station")}}  type="radio" name="primarySort"/> <label><span class="checkable">Station</span></label>
      </div>
    </p>
  
  <div>
    <h5>Measurement Tools</h5>
    <ul>
    {{#each @perusal.tools as |tool|}}
      <li>{{tool.toolType}} {{tool.name}}</li>
    {{/each}}
    </ul>
    <p>Add Measurement Tool:</p>
    <p>
      <label>Tool Id:
        {{input value=toolName }}
      </label>
  <select onchange={{action (mut toolType) value="target.value"}}>
    {{#each-in knownToolTypes as |toolTypeChoice toolConfig|}}
      <option value={{toolConfig.toolType}} selected={{eq toolType toolTypeChoice}}>{{toolConfig.display}}</option>
    {{/each-in}}
  </select>
    <button {{action "addTool" toolType toolName }}>Add Tool</button>
    </p>
  </div>
    <Input type="submit" value="Save" />
    <button {{action "cancel"}} type="button">Cancel</button>
  </form>
  
  {{yield}}
  
  */
  {
    id: "XkjEh5TE",
    block: "{\"symbols\":[\"toolConfig\",\"toolTypeChoice\",\"tool\",\"@perusal\",\"&default\"],\"statements\":[[7,\"form\",false],[3,\"action\",[[23,0,[]],\"save\"],[[\"on\"],[\"submit\"]]],[8],[0,\"\\n\"],[7,\"h2\",true],[10,\"class\",\"errorMessage\"],[8],[1,[22,\"errorMessage\"],false],[9],[0,\"\\n  \"],[7,\"p\",true],[8],[0,\"\\n    \"],[7,\"label\",true],[8],[0,\" Name:\\n      \"],[5,\"input\",[],[[\"@value\"],[[28,\"mut\",[[23,4,[\"name\"]]],null]]]],[0,\"\\n    \"],[9],[0,\"\\n  \"],[9],[0,\"\\n  \"],[7,\"p\",true],[8],[0,\"\\n    \"],[7,\"label\",true],[8],[0,\"User Name:\\n      \"],[5,\"input\",[],[[\"@value\"],[[28,\"mut\",[[23,4,[\"username\"]]],null]]]],[0,\"\\n    \"],[9],[0,\"\\n  \"],[9],[0,\"\\n  \"],[7,\"p\",true],[8],[0,\"Event Sort:\\n  \"],[7,\"div\",true],[8],[0,\"\\n    \"],[5,\"input\",[[12,\"name\",\"eventSort\"],[12,\"checked\",\"true\"],[12,\"type\",\"radio\"],[3,\"on\",[\"click\",[28,\"action\",[[23,0,[]],[28,\"mut\",[[23,4,[\"eventSort\"]]],null],\"time\"],null]]]],[[],[]]],[0,\" \"],[7,\"label\",true],[8],[7,\"span\",true],[10,\"class\",\"checkable\"],[8],[0,\"Time\"],[9],[9],[0,\"\\n    \"],[5,\"input\",[[12,\"name\",\"eventSort\"],[12,\"type\",\"radio\"],[3,\"on\",[\"click\",[28,\"action\",[[23,0,[]],[28,\"mut\",[[23,4,[\"eventSort\"]]],null],\"mag\"],null]]]],[[],[]]],[0,\" \"],[7,\"label\",true],[8],[7,\"span\",true],[10,\"class\",\"checkable\"],[8],[0,\"Mag\"],[9],[9],[0,\"\\n    \"],[5,\"input\",[[12,\"name\",\"eventSort\"],[12,\"type\",\"radio\"],[3,\"on\",[\"click\",[28,\"action\",[[23,0,[]],[28,\"mut\",[[23,4,[\"eventSort\"]]],null],\"distance\"],null]]]],[[],[]]],[0,\" \"],[7,\"label\",true],[8],[7,\"span\",true],[10,\"class\",\"checkable\"],[8],[0,\"Distance\"],[9],[9],[0,\"\\n  \"],[9],[0,\"\\n  \"],[9],[0,\"\\n  \"],[7,\"p\",true],[8],[0,\"Station Sort:\\n  \"],[7,\"div\",true],[8],[0,\"\\n    \"],[5,\"input\",[[12,\"name\",\"stationSort\"],[12,\"checked\",\"true\"],[12,\"type\",\"radio\"],[3,\"on\",[\"click\",[28,\"action\",[[23,0,[]],[28,\"mut\",[[23,4,[\"stationSort\"]]],null],\"alpha\"],null]]]],[[],[]]],[0,\" \"],[7,\"label\",true],[8],[7,\"span\",true],[10,\"class\",\"checkable\"],[8],[0,\"Alphabetical\"],[9],[9],[0,\"\\n    \"],[5,\"input\",[[12,\"name\",\"stationSort\"],[12,\"type\",\"radio\"],[3,\"on\",[\"click\",[28,\"action\",[[23,0,[]],[28,\"mut\",[[23,4,[\"stationSort\"]]],null],\"distance\"],null]]]],[[],[]]],[0,\" \"],[7,\"label\",true],[8],[7,\"span\",true],[10,\"class\",\"checkable\"],[8],[0,\"Distance\"],[9],[9],[0,\"\\n  \"],[9],[0,\"\\n  \"],[9],[0,\"\\n  \"],[7,\"p\",true],[8],[0,\"Primary Sort:\\n    \"],[7,\"div\",true],[8],[0,\"\\n      \"],[5,\"input\",[[12,\"name\",\"primarySort\"],[12,\"checked\",\"true\"],[12,\"type\",\"radio\"],[3,\"on\",[\"click\",[28,\"action\",[[23,0,[]],[28,\"mut\",[[23,4,[\"primarySort\"]]],null],\"quake\"],null]]]],[[],[]]],[0,\" \"],[7,\"label\",true],[8],[7,\"span\",true],[10,\"class\",\"checkable\"],[8],[0,\"Quake\"],[9],[9],[0,\"\\n      \"],[5,\"input\",[[12,\"name\",\"primarySort\"],[12,\"type\",\"radio\"],[3,\"on\",[\"click\",[28,\"action\",[[23,0,[]],[28,\"mut\",[[23,4,[\"primarySort\"]]],null],\"station\"],null]]]],[[],[]]],[0,\" \"],[7,\"label\",true],[8],[7,\"span\",true],[10,\"class\",\"checkable\"],[8],[0,\"Station\"],[9],[9],[0,\"\\n    \"],[9],[0,\"\\n  \"],[9],[0,\"\\n\\n\"],[7,\"div\",true],[8],[0,\"\\n  \"],[7,\"h5\",true],[8],[0,\"Measurement Tools\"],[9],[0,\"\\n  \"],[7,\"ul\",true],[8],[0,\"\\n\"],[4,\"each\",[[23,4,[\"tools\"]]],null,{\"statements\":[[0,\"    \"],[7,\"li\",true],[8],[1,[23,3,[\"toolType\"]],false],[0,\" \"],[1,[23,3,[\"name\"]],false],[9],[0,\"\\n\"]],\"parameters\":[3]},null],[0,\"  \"],[9],[0,\"\\n  \"],[7,\"p\",true],[8],[0,\"Add Measurement Tool:\"],[9],[0,\"\\n  \"],[7,\"p\",true],[8],[0,\"\\n    \"],[7,\"label\",true],[8],[0,\"Tool Id:\\n      \"],[1,[28,\"input\",null,[[\"value\"],[[24,[\"toolName\"]]]]],false],[0,\"\\n    \"],[9],[0,\"\\n\"],[7,\"select\",true],[11,\"onchange\",[28,\"action\",[[23,0,[]],[28,\"mut\",[[24,[\"toolType\"]]],null]],[[\"value\"],[\"target.value\"]]]],[8],[0,\"\\n\"],[4,\"each\",[[28,\"-each-in\",[[24,[\"knownToolTypes\"]]],null]],null,{\"statements\":[[0,\"    \"],[7,\"option\",true],[11,\"value\",[23,1,[\"toolType\"]]],[11,\"selected\",[28,\"eq\",[[24,[\"toolType\"]],[23,2,[]]],null]],[8],[1,[23,1,[\"display\"]],false],[9],[0,\"\\n\"]],\"parameters\":[1,2]},null],[9],[0,\"\\n  \"],[7,\"button\",false],[3,\"action\",[[23,0,[]],\"addTool\",[24,[\"toolType\"]],[24,[\"toolName\"]]]],[8],[0,\"Add Tool\"],[9],[0,\"\\n  \"],[9],[0,\"\\n\"],[9],[0,\"\\n  \"],[5,\"input\",[[12,\"value\",\"Save\"],[12,\"type\",\"submit\"]],[[],[]]],[0,\"\\n  \"],[7,\"button\",false],[12,\"type\",\"button\"],[3,\"action\",[[23,0,[]],\"cancel\"]],[8],[0,\"Cancel\"],[9],[0,\"\\n\"],[9],[0,\"\\n\\n\"],[14,5],[0,\"\\n\"]],\"hasEval\":false}",
    meta: {
      moduleName: "sodstatus/components/perusals/edit-form.hbs"
    }
  });

  let PerusalsEditFormComponent = (_class = (_temp = class PerusalsEditFormComponent extends _component.default {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "store", _descriptor, this);

      _defineProperty(this, "knownToolTypes", Ember.Object.create({
        letterGrade: {
          toolType: 'letter-grade',
          display: 'Letter Grade'
        },
        somethingElse: {
          toolType: 'something-else',
          display: 'Something Else'
        }
      }));

      _initializerDefineProperty(this, "toolType", _descriptor2, this);

      _initializerDefineProperty(this, "errorMessage", _descriptor3, this);
    }

    save() {
      let model = this.args.perusal;

      if (!model.get('name')) {
        this.set("errorMessage", "name is required.");
        return true;
      }

      if (!model.get('username')) {
        this.set("errorMessage", "username is required.");
        return true;
      }

      return Ember.RSVP.all(model.get('tools').map(t => t.save())).then(tools => {
        return model.save();
      }).then(model => {
        return model;
      }, err => {
        this.errorMessage = 'problem saving the pursal: ' + err;
      });
    }

    cancel() {
      if (this.args.perusal.id) {
        this.args.perusal.destroyRecord();
      }
    }

    changeEventSort(val) {
      this.args.perusal.set('eventSort', val);
    }

    changeStationSort(val) {
      this.args.perusal.set('stationSort', val);
    }

    changePrimarySort(val) {
      this.args.perusal.set('primarySort', val);
    }

    addTool(toolType, toolName) {
      if (!this.args.perusal.get('tools').find(t => t.get('name') === toolName)) {
        let tool = this.store.createRecord('measurement-tool', {
          toolType: toolType,
          name: toolName,
          toolConfig: this.knownToolTypes.get(toolType.camelize()),
          perusal: this.args.perusal
        });
        this.args.perusal.get('tools').pushObject(tool);
      }
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "store", [Ember.inject.service], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, "toolType", [Ember._tracked], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: function () {
      return 'letter-grade';
    }
  }), _descriptor3 = _applyDecoratedDescriptor(_class.prototype, "errorMessage", [Ember._tracked], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: function () {
      return "";
    }
  }), _applyDecoratedDescriptor(_class.prototype, "save", [Ember._action], Object.getOwnPropertyDescriptor(_class.prototype, "save"), _class.prototype), _applyDecoratedDescriptor(_class.prototype, "cancel", [Ember._action], Object.getOwnPropertyDescriptor(_class.prototype, "cancel"), _class.prototype), _applyDecoratedDescriptor(_class.prototype, "changeEventSort", [Ember._action], Object.getOwnPropertyDescriptor(_class.prototype, "changeEventSort"), _class.prototype), _applyDecoratedDescriptor(_class.prototype, "changeStationSort", [Ember._action], Object.getOwnPropertyDescriptor(_class.prototype, "changeStationSort"), _class.prototype), _applyDecoratedDescriptor(_class.prototype, "changePrimarySort", [Ember._action], Object.getOwnPropertyDescriptor(_class.prototype, "changePrimarySort"), _class.prototype), _applyDecoratedDescriptor(_class.prototype, "addTool", [Ember._action], Object.getOwnPropertyDescriptor(_class.prototype, "addTool"), _class.prototype)), _class);
  _exports.default = PerusalsEditFormComponent;

  Ember._setComponentTemplate(__COLOCATED_TEMPLATE__, PerusalsEditFormComponent);
});
;define("sodstatus/components/perusals/quake-or-station-link", ["exports", "@glimmer/component"], function (_exports, _component) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _class, _descriptor, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  const __COLOCATED_TEMPLATE__ = Ember.HTMLBars.template(
  /*
    
  
  {{#if @quakeStation}}
  <LinkTo @route='quake-stations.quake-station' @model={{@quakeStation.id}} >{{quakeStation.quake.name}}
    {{#if isPrimaryByQuake}}
      {{@quakeStation.id}} {{@quakeStation.station.codes}} {{unless isSameAsCurr @quakeStation.quake.name}}
    {{else}}
      {{@quakeStation.id}} {{@quakeStation.quake.name}} {{unless isSameAsCurr @quakeStation.station.codes}}
    {{/if}}
  </LinkTo>
  {{else}}
    no qs
  {{/if}}
  
  {{yield}}
  
  */
  {
    id: "bg5yfbEO",
    block: "{\"symbols\":[\"@quakeStation\",\"&default\"],\"statements\":[[0,\"\\n\\n\"],[4,\"if\",[[23,1,[]]],null,{\"statements\":[[5,\"link-to\",[],[[\"@route\",\"@model\"],[\"quake-stations.quake-station\",[23,1,[\"id\"]]]],{\"statements\":[[1,[24,[\"quakeStation\",\"quake\",\"name\"]],false],[0,\"\\n\"],[4,\"if\",[[24,[\"isPrimaryByQuake\"]]],null,{\"statements\":[[0,\"    \"],[1,[23,1,[\"id\"]],false],[0,\" \"],[1,[23,1,[\"station\",\"codes\"]],false],[0,\" \"],[1,[28,\"unless\",[[24,[\"isSameAsCurr\"]],[23,1,[\"quake\",\"name\"]]],null],false],[0,\"\\n\"]],\"parameters\":[]},{\"statements\":[[0,\"    \"],[1,[23,1,[\"id\"]],false],[0,\" \"],[1,[23,1,[\"quake\",\"name\"]],false],[0,\" \"],[1,[28,\"unless\",[[24,[\"isSameAsCurr\"]],[23,1,[\"station\",\"codes\"]]],null],false],[0,\"\\n\"]],\"parameters\":[]}]],\"parameters\":[]}],[0,\"\\n\"]],\"parameters\":[]},{\"statements\":[[0,\"  no qs\\n\"]],\"parameters\":[]}],[0,\"\\n\"],[14,2],[0,\"\\n\"]],\"hasEval\":false}",
    meta: {
      moduleName: "sodstatus/components/perusals/quake-or-station-link.hbs"
    }
  });

  let PerusalsQuakeOrStationLinkComponent = (_class = (_temp = class PerusalsQuakeOrStationLinkComponent extends _component.default {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "tagName", _descriptor, this);
    }

    get isPrimaryByQuake() {
      return this.primarySort === 'quake';
    }

    get isSameAsCurr() {
      if (!this.quakeStation || !this.current) {
        return false;
      }

      if (this.isPrimaryByQuake) {
        return this.quakeStation.get('quake').get('id') === this.current.get('quake').get('id');
      } else {
        return this.quakeStation.get('station').get('id') === this.current.get('station').get('id');
      }
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "tagName", [Ember._tracked], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: function () {
      return 'span';
    }
  })), _class);
  _exports.default = PerusalsQuakeOrStationLinkComponent;

  Ember._setComponentTemplate(__COLOCATED_TEMPLATE__, PerusalsQuakeOrStationLinkComponent);
});
;define("sodstatus/components/point-path-layer", ["exports", "ember-leaflet/components/point-path-layer"], function (_exports, _pointPathLayer) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _pointPathLayer.default;
    }
  });
});
;define("sodstatus/components/polygon-layer", ["exports", "ember-leaflet/components/polygon-layer"], function (_exports, _polygonLayer) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _polygonLayer.default;
    }
  });
});
;define("sodstatus/components/polyline-layer", ["exports", "ember-leaflet/components/polyline-layer"], function (_exports, _polylineLayer) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _polylineLayer.default;
    }
  });
});
;define("sodstatus/components/popup-layer", ["exports", "ember-leaflet/components/popup-layer"], function (_exports, _popupLayer) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _popupLayer.default;
    }
  });
});
;define("sodstatus/components/quake-info", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  const __COLOCATED_TEMPLATE__ = Ember.HTMLBars.template(
  /*
    
  <div class="quake-info" >
  
  <table>
    <tbody>
      <tr>
        <td>Region</td>
        <td>{{@quake.name}}</td>
      </tr>
      <tr>
        <td>Time</td>
        <td>{{format-iso-date @quake.prefOrigin.time }}</td>
      </tr>
      <tr>
        <td>Mag</td>
        <td>{{@quake.prefMagnitude.magFormatted}} {{@quake.prefMagnitude.magType}}</td>
      </tr>
      <tr>
        <td>Depth</td>
        <td>{{@quake.prefOrigin.depthFormatted}} km</td>
      </tr>
      <tr>
        <td>Lat/Lon</td>
        <td>({{@quake.prefOrigin.latitudeFormatted}},{{@quake.prefOrigin.longitudeFormatted}})</td>
      </tr>
      <tr>
        <td>DbId</td>
        <td>{{@quake.id}}</td>
      </tr>
    </tbody>
  </table>
  
  
  {{yield}}
  </div>
  
  */
  {
    id: "8NQVy3zK",
    block: "{\"symbols\":[\"@quake\",\"&default\"],\"statements\":[[0,\"\\n\"],[7,\"div\",true],[10,\"class\",\"quake-info\"],[8],[0,\"\\n\\n\"],[7,\"table\",true],[8],[0,\"\\n  \"],[7,\"tbody\",true],[8],[0,\"\\n    \"],[7,\"tr\",true],[8],[0,\"\\n      \"],[7,\"td\",true],[8],[0,\"Region\"],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"name\"]],false],[9],[0,\"\\n    \"],[9],[0,\"\\n    \"],[7,\"tr\",true],[8],[0,\"\\n      \"],[7,\"td\",true],[8],[0,\"Time\"],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[28,\"format-iso-date\",[[23,1,[\"prefOrigin\",\"time\"]]],null],false],[9],[0,\"\\n    \"],[9],[0,\"\\n    \"],[7,\"tr\",true],[8],[0,\"\\n      \"],[7,\"td\",true],[8],[0,\"Mag\"],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"prefMagnitude\",\"magFormatted\"]],false],[0,\" \"],[1,[23,1,[\"prefMagnitude\",\"magType\"]],false],[9],[0,\"\\n    \"],[9],[0,\"\\n    \"],[7,\"tr\",true],[8],[0,\"\\n      \"],[7,\"td\",true],[8],[0,\"Depth\"],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"prefOrigin\",\"depthFormatted\"]],false],[0,\" km\"],[9],[0,\"\\n    \"],[9],[0,\"\\n    \"],[7,\"tr\",true],[8],[0,\"\\n      \"],[7,\"td\",true],[8],[0,\"Lat/Lon\"],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[0,\"(\"],[1,[23,1,[\"prefOrigin\",\"latitudeFormatted\"]],false],[0,\",\"],[1,[23,1,[\"prefOrigin\",\"longitudeFormatted\"]],false],[0,\")\"],[9],[0,\"\\n    \"],[9],[0,\"\\n    \"],[7,\"tr\",true],[8],[0,\"\\n      \"],[7,\"td\",true],[8],[0,\"DbId\"],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"id\"]],false],[9],[0,\"\\n    \"],[9],[0,\"\\n  \"],[9],[0,\"\\n\"],[9],[0,\"\\n\\n\\n\"],[14,2],[0,\"\\n\"],[9],[0,\"\\n\"]],\"hasEval\":false}",
    meta: {
      moduleName: "sodstatus/components/quake-info.hbs"
    }
  });

  var _default = Ember._setComponentTemplate(__COLOCATED_TEMPLATE__, Ember._templateOnlyComponent());

  _exports.default = _default;
});
;define("sodstatus/components/quake-list", ["exports", "@glimmer/component"], function (_exports, _component) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _dec, _class, _descriptor, _descriptor2, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  const __COLOCATED_TEMPLATE__ = Ember.HTMLBars.template(
  /*
    
  <table >
    <thead>
      <th {{action "sortBy" "name"}}>Name</th>
      <th {{action "sortBy" "prefOrigin.time"}}>Time</th>
      <th {{action "sortBy" "prefMagnitude.value"}}>Mag</th>
      <th {{action "sortBy" "prefOrigin.latitude"}}>Lat</th>
      <th {{action "sortBy" "prefOrigin.longitude"}}>Lon</th>
      <th {{action "sortBy" "prefOrigin.depth"}}>Depth(km)</th>
      <th {{action "sortBy" "sodStatus"}}>Status</th>
      <th {{action "sortBy" "numSuccessfulStations"}}>Num</th>
      </thead>
    {{#each sortedQuakes as |quake|}}
      <tr>
        <td>
          <LinkTo @route='quakes.quake' @model={{quake.id}} >{{quake.name}}</LinkTo>
        </td>
        <td>{{format-iso-date quake.prefOrigin.time }}</td>
        <td>{{quake.prefMagnitude.magFormatted}} {{quake.prefMagnitude.magType}}</td>
        <td>{{quake.prefOrigin.latitudeFormatted}}</td>
        <td>{{quake.prefOrigin.longitudeFormatted}}</td>
        <td>{{quake.prefOrigin.depthFormatted}} km</td>
        <td>{{quake.sodStatus}}</td>
        <td>{{quake.numSuccessfulStations}}</td>
      </tr>
    {{/each}}
  </table>
  
  {{yield}}
  
  */
  {
    id: "LsODiyvt",
    block: "{\"symbols\":[\"quake\",\"&default\"],\"statements\":[[0,\"\\n\"],[7,\"table\",true],[8],[0,\"\\n  \"],[7,\"thead\",true],[8],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"name\"]],[8],[0,\"Name\"],[9],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"prefOrigin.time\"]],[8],[0,\"Time\"],[9],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"prefMagnitude.value\"]],[8],[0,\"Mag\"],[9],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"prefOrigin.latitude\"]],[8],[0,\"Lat\"],[9],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"prefOrigin.longitude\"]],[8],[0,\"Lon\"],[9],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"prefOrigin.depth\"]],[8],[0,\"Depth(km)\"],[9],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"sodStatus\"]],[8],[0,\"Status\"],[9],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"numSuccessfulStations\"]],[8],[0,\"Num\"],[9],[0,\"\\n    \"],[9],[0,\"\\n\"],[4,\"each\",[[24,[\"sortedQuakes\"]]],null,{\"statements\":[[0,\"    \"],[7,\"tr\",true],[8],[0,\"\\n      \"],[7,\"td\",true],[8],[0,\"\\n        \"],[5,\"link-to\",[],[[\"@route\",\"@model\"],[\"quakes.quake\",[23,1,[\"id\"]]]],{\"statements\":[[1,[23,1,[\"name\"]],false]],\"parameters\":[]}],[0,\"\\n      \"],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[28,\"format-iso-date\",[[23,1,[\"prefOrigin\",\"time\"]]],null],false],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"prefMagnitude\",\"magFormatted\"]],false],[0,\" \"],[1,[23,1,[\"prefMagnitude\",\"magType\"]],false],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"prefOrigin\",\"latitudeFormatted\"]],false],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"prefOrigin\",\"longitudeFormatted\"]],false],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"prefOrigin\",\"depthFormatted\"]],false],[0,\" km\"],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"sodStatus\"]],false],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"numSuccessfulStations\"]],false],[9],[0,\"\\n    \"],[9],[0,\"\\n\"]],\"parameters\":[1]},null],[9],[0,\"\\n\\n\"],[14,2],[0,\"\\n\"]],\"hasEval\":false}",
    meta: {
      moduleName: "sodstatus/components/quake-list.hbs"
    }
  });

  let QuakeListComponent = (_dec = Ember.computed.sort('args.quakes', 'sortDefinition'), (_class = (_temp = class QuakeListComponent extends _component.default {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "sortDefinition", _descriptor, this);

      _initializerDefineProperty(this, "sortedQuakes", _descriptor2, this);
    }

    sortBy(key) {
      console.log(`QuakeStationsListComponent sortBy(${key})  `);
      let direction = "asc";

      if (this.sortDefinition[0].startsWith(key)) {
        if (this.sortDefinition[0].endsWith(":desc")) {
          direction = "asc";
        } else {
          direction = "desc";
        }
      } else {
        direction = "asc";
      }

      this.sortDefinition = [key + ":" + direction];
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "sortDefinition", [Ember._tracked], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: function () {
      return ['prefOrigin.time'];
    }
  }), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, "sortedQuakes", [_dec], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _applyDecoratedDescriptor(_class.prototype, "sortBy", [Ember._action], Object.getOwnPropertyDescriptor(_class.prototype, "sortBy"), _class.prototype)), _class));
  _exports.default = QuakeListComponent;

  Ember._setComponentTemplate(__COLOCATED_TEMPLATE__, QuakeListComponent);
});
;define("sodstatus/components/quake-station-info", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  const __COLOCATED_TEMPLATE__ = Ember.HTMLBars.template(
  /*
    
  
  <table>
    <tbody>
      <tr>
        <td>Dist</td>
        <td>{{@quakeStation.distDegFormatted}} deg/ {{@quakeStation.distKmFormatted}} km</td>
      </tr>
      <tr>
        <td>Azimuth</td>
        <td>{{@quakeStation.azimuthFormatted}}</td>
      </tr>
      <tr>
        <td>Backazimuth</td>
        <td>{{@quakeStation.backazimuthFormatted}}</td>
      </tr>
      <tr>
        <td>Status</td>
        <td>{{@quakeStation.sodStatus}}</td>
      </tr>
      <tr>
        <td>DbId</td>
        <td>{{@quakeStation.id}}</td>
      </tr>
    </tbody>
  </table>
  
  {{yield}}
  
  */
  {
    id: "CBvsaqce",
    block: "{\"symbols\":[\"@quakeStation\",\"&default\"],\"statements\":[[0,\"\\n\\n\"],[7,\"table\",true],[8],[0,\"\\n  \"],[7,\"tbody\",true],[8],[0,\"\\n    \"],[7,\"tr\",true],[8],[0,\"\\n      \"],[7,\"td\",true],[8],[0,\"Dist\"],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"distDegFormatted\"]],false],[0,\" deg/ \"],[1,[23,1,[\"distKmFormatted\"]],false],[0,\" km\"],[9],[0,\"\\n    \"],[9],[0,\"\\n    \"],[7,\"tr\",true],[8],[0,\"\\n      \"],[7,\"td\",true],[8],[0,\"Azimuth\"],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"azimuthFormatted\"]],false],[9],[0,\"\\n    \"],[9],[0,\"\\n    \"],[7,\"tr\",true],[8],[0,\"\\n      \"],[7,\"td\",true],[8],[0,\"Backazimuth\"],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"backazimuthFormatted\"]],false],[9],[0,\"\\n    \"],[9],[0,\"\\n    \"],[7,\"tr\",true],[8],[0,\"\\n      \"],[7,\"td\",true],[8],[0,\"Status\"],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"sodStatus\"]],false],[9],[0,\"\\n    \"],[9],[0,\"\\n    \"],[7,\"tr\",true],[8],[0,\"\\n      \"],[7,\"td\",true],[8],[0,\"DbId\"],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"id\"]],false],[9],[0,\"\\n    \"],[9],[0,\"\\n  \"],[9],[0,\"\\n\"],[9],[0,\"\\n\\n\"],[14,2],[0,\"\\n\"]],\"hasEval\":false}",
    meta: {
      moduleName: "sodstatus/components/quake-station-info.hbs"
    }
  });

  var _default = Ember._setComponentTemplate(__COLOCATED_TEMPLATE__, Ember._templateOnlyComponent());

  _exports.default = _default;
});
;define("sodstatus/components/quake-station-map", ["exports", "@glimmer/component"], function (_exports, _component) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _class, _descriptor, _descriptor2, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  const __COLOCATED_TEMPLATE__ = Ember.HTMLBars.template(
  /*
    
  
  <LeafletMap @worldCopyJump='true' @lat={{centerLat}} @lng={{centerLon}} @zoom={{zoomLevel}} as |layers|>
    <layers.tile @url="http://{s}.basemaps.cartocdn.com/light_all/{z}/{x}/{y}.png"/>
  
  
    {{#each stationList as |s|}}
      <layers.marker @lat={{s.latitude}} @lng={{sub-360 s.longitude}} class='stationMarker' as |marker|>
        <marker.popup>
          <h3><LinkTo @route='stations.station' @model={{s}} >{{s.codes}}</LinkTo></h3>
        </marker.popup>
      </layers.marker>
      <layers.marker @lat={{s.latitude}} @lng={{s.longitude}} class='stationMarker' as |marker|>
        <marker.popup>
          <h3><LinkTo @route='stations.station' @model={{s}} >{{s.codes}}</LinkTo></h3>
        </marker.popup>
      </layers.marker>
      <layers.marker @lat={{s.latitude}} @lng={{add-360 s.longitude}} class='stationMarker' as |marker|>
        <marker.popup>
          <h3><LinkTo @route='stations.station' @model={{s}} >{{s.codes}}</LinkTo></h3>
        </marker.popup>
      </layers.marker>
    {{/each}}
  
    {{#each quakeList as |q|}}
      <layers.circle-marker @lat={{q.prefOrigin.latitude}} @lng={{sub-360 q.prefOrigin.longitude}} @radius={{scaled-magnitude q pixelsPerMag=5}} class='stationMarker' as |marker|>
        <marker.popup>
          <h3>Quake: <LinkTo @route='quakes.quake.stations' @model={{q}} >{{q.name}} {{format-iso-date q.prefOrigin.time }} {{q.prefMagnitude.magFormatted}} {{q.prefMagnitude.magType}}</LinkTo></h3>
        </marker.popup>
      </layers.circle-marker>
        <layers.circle-marker @lat={{q.prefOrigin.latitude}} @lng={{q.prefOrigin.longitude}} @radius={{scaled-magnitude q pixelsPerMag=5}} class='stationMarker' as |marker|>
          <marker.popup>
            <h3>Quake: <LinkTo @route='quakes.quake.stations' @model={{q}} >{{q.name}} {{format-iso-date q.prefOrigin.time }} {{q.prefMagnitude.magFormatted}} {{q.prefMagnitude.magType}}</LinkTo></h3>
          </marker.popup>
        </layers.circle-marker>
      <layers.circle-marker @lat={{q.prefOrigin.latitude}} @lng={{add-360 q.prefOrigin.longitude}} @radius={{scaled-magnitude q pixelsPerMag=5}} class='stationMarker' as |marker|>
        <marker.popup>
          <h3>Quake: <LinkTo @route='quakes.quake.stations' @model={{q}} >{{q.name}} {{format-iso-date q.prefOrigin.time }} {{q.prefMagnitude.magFormatted}} {{q.prefMagnitude.magType}}</LinkTo></h3>
        </marker.popup>
      </layers.circle-marker>
    {{/each}}
  
  
  </LeafletMap>
  
  
  {{yield}}
  
  */
  {
    id: "DmCKrDjI",
    block: "{\"symbols\":[\"layers\",\"q\",\"marker\",\"marker\",\"marker\",\"s\",\"marker\",\"marker\",\"marker\",\"&default\"],\"statements\":[[0,\"\\n\\n\"],[5,\"leaflet-map\",[],[[\"@worldCopyJump\",\"@lat\",\"@lng\",\"@zoom\"],[\"true\",[22,\"centerLat\"],[22,\"centerLon\"],[22,\"zoomLevel\"]]],{\"statements\":[[0,\"\\n  \"],[6,[23,1,[\"tile\"]],[],[[\"@url\"],[\"http://{s}.basemaps.cartocdn.com/light_all/{z}/{x}/{y}.png\"]]],[0,\"\\n\\n\\n\"],[4,\"each\",[[24,[\"stationList\"]]],null,{\"statements\":[[0,\"    \"],[6,[23,1,[\"marker\"]],[[12,\"class\",\"stationMarker\"]],[[\"@lat\",\"@lng\"],[[23,6,[\"latitude\"]],[28,\"sub-360\",[[23,6,[\"longitude\"]]],null]]],{\"statements\":[[0,\"\\n      \"],[6,[23,9,[\"popup\"]],[],[[],[]],{\"statements\":[[0,\"\\n        \"],[7,\"h3\",true],[8],[5,\"link-to\",[],[[\"@route\",\"@model\"],[\"stations.station\",[23,6,[]]]],{\"statements\":[[1,[23,6,[\"codes\"]],false]],\"parameters\":[]}],[9],[0,\"\\n      \"]],\"parameters\":[]}],[0,\"\\n    \"]],\"parameters\":[9]}],[0,\"\\n    \"],[6,[23,1,[\"marker\"]],[[12,\"class\",\"stationMarker\"]],[[\"@lat\",\"@lng\"],[[23,6,[\"latitude\"]],[23,6,[\"longitude\"]]]],{\"statements\":[[0,\"\\n      \"],[6,[23,8,[\"popup\"]],[],[[],[]],{\"statements\":[[0,\"\\n        \"],[7,\"h3\",true],[8],[5,\"link-to\",[],[[\"@route\",\"@model\"],[\"stations.station\",[23,6,[]]]],{\"statements\":[[1,[23,6,[\"codes\"]],false]],\"parameters\":[]}],[9],[0,\"\\n      \"]],\"parameters\":[]}],[0,\"\\n    \"]],\"parameters\":[8]}],[0,\"\\n    \"],[6,[23,1,[\"marker\"]],[[12,\"class\",\"stationMarker\"]],[[\"@lat\",\"@lng\"],[[23,6,[\"latitude\"]],[28,\"add-360\",[[23,6,[\"longitude\"]]],null]]],{\"statements\":[[0,\"\\n      \"],[6,[23,7,[\"popup\"]],[],[[],[]],{\"statements\":[[0,\"\\n        \"],[7,\"h3\",true],[8],[5,\"link-to\",[],[[\"@route\",\"@model\"],[\"stations.station\",[23,6,[]]]],{\"statements\":[[1,[23,6,[\"codes\"]],false]],\"parameters\":[]}],[9],[0,\"\\n      \"]],\"parameters\":[]}],[0,\"\\n    \"]],\"parameters\":[7]}],[0,\"\\n\"]],\"parameters\":[6]},null],[0,\"\\n\"],[4,\"each\",[[24,[\"quakeList\"]]],null,{\"statements\":[[0,\"    \"],[6,[23,1,[\"circle-marker\"]],[[12,\"class\",\"stationMarker\"]],[[\"@lat\",\"@lng\",\"@radius\"],[[23,2,[\"prefOrigin\",\"latitude\"]],[28,\"sub-360\",[[23,2,[\"prefOrigin\",\"longitude\"]]],null],[28,\"scaled-magnitude\",[[23,2,[]]],[[\"pixelsPerMag\"],[5]]]]],{\"statements\":[[0,\"\\n      \"],[6,[23,5,[\"popup\"]],[],[[],[]],{\"statements\":[[0,\"\\n        \"],[7,\"h3\",true],[8],[0,\"Quake: \"],[5,\"link-to\",[],[[\"@route\",\"@model\"],[\"quakes.quake.stations\",[23,2,[]]]],{\"statements\":[[1,[23,2,[\"name\"]],false],[0,\" \"],[1,[28,\"format-iso-date\",[[23,2,[\"prefOrigin\",\"time\"]]],null],false],[0,\" \"],[1,[23,2,[\"prefMagnitude\",\"magFormatted\"]],false],[0,\" \"],[1,[23,2,[\"prefMagnitude\",\"magType\"]],false]],\"parameters\":[]}],[9],[0,\"\\n      \"]],\"parameters\":[]}],[0,\"\\n    \"]],\"parameters\":[5]}],[0,\"\\n      \"],[6,[23,1,[\"circle-marker\"]],[[12,\"class\",\"stationMarker\"]],[[\"@lat\",\"@lng\",\"@radius\"],[[23,2,[\"prefOrigin\",\"latitude\"]],[23,2,[\"prefOrigin\",\"longitude\"]],[28,\"scaled-magnitude\",[[23,2,[]]],[[\"pixelsPerMag\"],[5]]]]],{\"statements\":[[0,\"\\n        \"],[6,[23,4,[\"popup\"]],[],[[],[]],{\"statements\":[[0,\"\\n          \"],[7,\"h3\",true],[8],[0,\"Quake: \"],[5,\"link-to\",[],[[\"@route\",\"@model\"],[\"quakes.quake.stations\",[23,2,[]]]],{\"statements\":[[1,[23,2,[\"name\"]],false],[0,\" \"],[1,[28,\"format-iso-date\",[[23,2,[\"prefOrigin\",\"time\"]]],null],false],[0,\" \"],[1,[23,2,[\"prefMagnitude\",\"magFormatted\"]],false],[0,\" \"],[1,[23,2,[\"prefMagnitude\",\"magType\"]],false]],\"parameters\":[]}],[9],[0,\"\\n        \"]],\"parameters\":[]}],[0,\"\\n      \"]],\"parameters\":[4]}],[0,\"\\n    \"],[6,[23,1,[\"circle-marker\"]],[[12,\"class\",\"stationMarker\"]],[[\"@lat\",\"@lng\",\"@radius\"],[[23,2,[\"prefOrigin\",\"latitude\"]],[28,\"add-360\",[[23,2,[\"prefOrigin\",\"longitude\"]]],null],[28,\"scaled-magnitude\",[[23,2,[]]],[[\"pixelsPerMag\"],[5]]]]],{\"statements\":[[0,\"\\n      \"],[6,[23,3,[\"popup\"]],[],[[],[]],{\"statements\":[[0,\"\\n        \"],[7,\"h3\",true],[8],[0,\"Quake: \"],[5,\"link-to\",[],[[\"@route\",\"@model\"],[\"quakes.quake.stations\",[23,2,[]]]],{\"statements\":[[1,[23,2,[\"name\"]],false],[0,\" \"],[1,[28,\"format-iso-date\",[[23,2,[\"prefOrigin\",\"time\"]]],null],false],[0,\" \"],[1,[23,2,[\"prefMagnitude\",\"magFormatted\"]],false],[0,\" \"],[1,[23,2,[\"prefMagnitude\",\"magType\"]],false]],\"parameters\":[]}],[9],[0,\"\\n      \"]],\"parameters\":[]}],[0,\"\\n    \"]],\"parameters\":[3]}],[0,\"\\n\"]],\"parameters\":[2]},null],[0,\"\\n\\n\"]],\"parameters\":[1]}],[0,\"\\n\\n\\n\"],[14,10],[0,\"\\n\"]],\"hasEval\":false}",
    meta: {
      moduleName: "sodstatus/components/quake-station-map.hbs"
    }
  });

  let QuakeStationMapComponent = (_class = (_temp = class QuakeStationMapComponent extends _component.default {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "zoomLevel", _descriptor, this);

      _initializerDefineProperty(this, "pixelPerMagnitude", _descriptor2, this);
    }

    get quakeList() {
      if (this.args.quakes) {
        if (Ember.isArray(this.args.quakes)) {
          return this.args.quakes;
        } else {
          return Ember.A([this.args.quakes]);
        }
      } else if (this.args.quakeStations) {
        return this.args.quakeStations.map(qs => qs.quake);
      }

      return Ember.A([]);
    }

    get stationList() {
      if (this.args.stations) {
        if (Ember.isArray(this.args.stations)) {
          return this.args.stations;
        } else {
          return Ember.A([this.args.stations]);
        }
      } else if (this.args.quakeStations) {
        return this.args.quakeStations.map(qs => qs.station);
      }

      return Ember.A([]);
    }

    get centerLat() {
      const b = this.bounds;
      return (b[0][0] + b[1][0]) / 2;
    }

    get centerLon() {
      const b = this.bounds;
      return (b[0][1] + b[1][1]) / 2;
    }

    get originList() {
      let out = this.quakeList.getEach('prefOrigin').filter(o => o && o.get('latitude') && !Number.isNaN(o.get('latitude')) && !Number.isNaN(o.get('longitude')));
      return out;
    }

    get bounds() {
      let originList = this.originList ? this.originList : [];
      let stationList = this.stationList ? this.stationList : [];

      if ((!this.quakeList || this.quakeList.length === 0) && (!this.stationList || this.stationList.length === 0)) {
        return [[-0.5, 0.5], [-0.5, 0.5]];
      }

      let minLat = 99;
      let maxLat = -99;
      let minLon = 200;
      let maxLon = -200;

      let minLatFn = function (a, b) {
        if (!b || a < b.get('latitude')) {
          return a;
        } else {
          return b.get('latitude');
        }
      };

      minLat = originList.reduce(minLatFn, minLat);
      minLat = stationList.reduce(minLatFn, minLat);

      let maxLatFn = function (a, b) {
        if (!b || a > b.get('latitude')) {
          return a;
        } else {
          return b.get('latitude');
        }
      };

      maxLat = originList.reduce(maxLatFn, maxLat);
      maxLat = stationList.reduce(maxLatFn, maxLat);

      let minLonFn = function (a, b) {
        if (!b || a < b.get('longitude')) {
          return a;
        } else {
          return b.get('longitude');
        }
      };

      minLon = originList.reduce(minLonFn, minLon);
      minLon = stationList.reduce(minLonFn, minLon);

      let maxLonFn = function (a, b) {
        if (!b || a > b.get('longitude')) {
          return a;
        } else {
          return b.get('longitude');
        }
      };

      maxLon = originList.reduce(maxLonFn, maxLon);
      maxLon = stationList.reduce(maxLonFn, maxLon); // min 1 deg

      if (Math.abs(maxLat - minLat) < 1) {
        minLat = (minLat + maxLat) / 2 - 0.5;
        maxLat = (minLat + maxLat) / 2 + 0.5;
      }

      if (Math.abs(maxLon - minLon) < 1) {
        minLon = (minLon + maxLon) / 2 - 0.5;
        maxLon = (minLon + maxLon) / 2 + 0.5;
      } // expand by 50%, 25% on each edge


      let degExpand = Math.max(maxLon - minLon, maxLat - minLat) * 0.25;

      if (degExpand > 10) {
        degExpand = 10;
      }

      maxLat += degExpand;

      if (maxLat > 90) {
        maxLat = 90.0;
      }

      minLat -= degExpand;

      if (minLat < -90) {
        minLat = -90.0;
      }

      maxLon += degExpand;
      minLon -= degExpand;
      return [[minLat, minLon], [maxLat, maxLon]];
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "zoomLevel", [Ember._tracked], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: function () {
      return 1;
    }
  }), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, "pixelPerMagnitude", [Ember._tracked], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: function () {
      return 3;
    }
  })), _class);
  _exports.default = QuakeStationMapComponent;

  Ember._setComponentTemplate(__COLOCATED_TEMPLATE__, QuakeStationMapComponent);
});
;define("sodstatus/components/quake-stations-list", ["exports", "@glimmer/component"], function (_exports, _component) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _dec, _class, _descriptor, _descriptor2, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  const __COLOCATED_TEMPLATE__ = Ember.HTMLBars.template(
  /*
    <div class="quake-stations-list">
  <table >
    <thead>
      <th {{action "sortBy" "station.codes"}}>Name</th>
      <th {{action "sortBy" "distdeg"}}>Dist</th>
      <th {{action "sortBy" "station.latitude"}}>Lat</th>
      <th {{action "sortBy" "station.longitude"}}>Lon</th>
      <th {{action "sortBy" "sodStatus"}}>Status</th>
      </thead>
    {{#each sortedQuakeStationPairs as |esps|}}
      <tr>
        <td><LinkTo @route='quake-stations.quake-station' @model={{esps.id}} >{{esps.station.codes}}</LinkTo></td>
        <td>{{format-number esps.distdeg 2 }}</td>
        <td>{{esps.station.latitudeFormatted}}</td>
        <td>{{esps.station.longitudeFormatted}}</td>
        <td>{{esps.sodStatus}}</td>
      </tr>
    {{/each}}
  </table>
  
  {{yield}}
  </div>
  
  */
  {
    id: "bMby6m2n",
    block: "{\"symbols\":[\"esps\",\"&default\"],\"statements\":[[7,\"div\",true],[10,\"class\",\"quake-stations-list\"],[8],[0,\"\\n\"],[7,\"table\",true],[8],[0,\"\\n  \"],[7,\"thead\",true],[8],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"station.codes\"]],[8],[0,\"Name\"],[9],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"distdeg\"]],[8],[0,\"Dist\"],[9],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"station.latitude\"]],[8],[0,\"Lat\"],[9],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"station.longitude\"]],[8],[0,\"Lon\"],[9],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"sodStatus\"]],[8],[0,\"Status\"],[9],[0,\"\\n    \"],[9],[0,\"\\n\"],[4,\"each\",[[24,[\"sortedQuakeStationPairs\"]]],null,{\"statements\":[[0,\"    \"],[7,\"tr\",true],[8],[0,\"\\n      \"],[7,\"td\",true],[8],[5,\"link-to\",[],[[\"@route\",\"@model\"],[\"quake-stations.quake-station\",[23,1,[\"id\"]]]],{\"statements\":[[1,[23,1,[\"station\",\"codes\"]],false]],\"parameters\":[]}],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[28,\"format-number\",[[23,1,[\"distdeg\"]],2],null],false],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"station\",\"latitudeFormatted\"]],false],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"station\",\"longitudeFormatted\"]],false],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"sodStatus\"]],false],[9],[0,\"\\n    \"],[9],[0,\"\\n\"]],\"parameters\":[1]},null],[9],[0,\"\\n\\n\"],[14,2],[0,\"\\n\"],[9],[0,\"\\n\"]],\"hasEval\":false}",
    meta: {
      moduleName: "sodstatus/components/quake-stations-list.hbs"
    }
  });

  let QuakeStationsListComponent = (_dec = Ember.computed.sort('args.quakeStationPairs', 'sortDefinition'), (_class = (_temp = class QuakeStationsListComponent extends _component.default {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "sortDefinition", _descriptor, this);

      _initializerDefineProperty(this, "sortedQuakeStationPairs", _descriptor2, this);
    }

    sortBy(key) {
      console.log(`QuakeStationsListComponent sortBy(${key})  `);
      let direction = "asc";

      if (this.sortDefinition[0].startsWith(key)) {
        if (this.sortDefinition[0].endsWith(":desc")) {
          direction = "asc";
        } else {
          direction = "desc";
        }
      } else {
        direction = "asc";
      }

      this.sortDefinition = [key + ":" + direction];
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "sortDefinition", [Ember._tracked], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: function () {
      return ['station.stationCode'];
    }
  }), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, "sortedQuakeStationPairs", [_dec], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _applyDecoratedDescriptor(_class.prototype, "sortBy", [Ember._action], Object.getOwnPropertyDescriptor(_class.prototype, "sortBy"), _class.prototype)), _class));
  _exports.default = QuakeStationsListComponent;

  Ember._setComponentTemplate(__COLOCATED_TEMPLATE__, QuakeStationsListComponent);
});
;define("sodstatus/components/rectangle-layer", ["exports", "ember-leaflet/components/rectangle-layer"], function (_exports, _rectangleLayer) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _rectangleLayer.default;
    }
  });
});
;define("sodstatus/components/seismogram-display", ["exports", "@glimmer/component", "seisplotjs"], function (_exports, _component, _seisplotjs) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _class;

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  const __COLOCATED_TEMPLATE__ = Ember.HTMLBars.template(
  /*
    
  {{#each @quakeVector.waveforms as |w|}}
  <h5>Download: <a href={{w.dataUrl}} download>{{w.dataUrl}}</a></h5>
  {{/each}}
  
  <div class="seismogramDiv" ...attributes {{did-insert this.createGraph}}>
  <h5>Loading...</h5>
  </div>
  {{yield}}
  
  */
  {
    id: "PY89/sLp",
    block: "{\"symbols\":[\"w\",\"@quakeVector\",\"&attrs\",\"&default\"],\"statements\":[[0,\"\\n\"],[4,\"each\",[[23,2,[\"waveforms\"]]],null,{\"statements\":[[7,\"h5\",true],[8],[0,\"Download: \"],[7,\"a\",true],[11,\"href\",[23,1,[\"dataUrl\"]]],[10,\"download\",\"\"],[8],[1,[23,1,[\"dataUrl\"]],false],[9],[9],[0,\"\\n\"]],\"parameters\":[1]},null],[0,\"\\n\"],[7,\"div\",false],[12,\"class\",\"seismogramDiv\"],[13,3],[3,\"did-insert\",[[23,0,[\"createGraph\"]]]],[8],[0,\"\\n\"],[7,\"h5\",true],[8],[0,\"Loading...\"],[9],[0,\"\\n\"],[9],[0,\"\\n\"],[14,4],[0,\"\\n\"]],\"hasEval\":false}",
    meta: {
      moduleName: "sodstatus/components/seismogram-display.hbs"
    }
  });

  let SeismogramDisplayComponent = (_class = class SeismogramDisplayComponent extends _component.default {
    async createGraph(element) {
      let div = _seisplotjs.d3.select(element);

      if (this.args.quakeVector) {
        let seisConfig = new _seisplotjs.seismographconfig.SeismographConfig();

        if (this.args.title) {
          seisConfig.title = this.args.title;
        } else {
          let channels = await this.args.quakeVector.channels;

          if (channels) {
            seisConfig.title = "";
            channels.forEach(c => {
              seisConfig.title += c.locCode + "." + c.channelCode;
            });
          } else {
            seisConfig.title = "no channels...";
          }
        }

        seisConfig.margin.top = 25;
        await Ember.RSVP.all(this.args.quakeVector.waveforms); //let seis = seismogram.Seismogram.createFromContiguousData(dataArray, sampleRate, start);
        //let waveforms = await RSVP.all(Array.from(this.args.quakeVector.waveforms));

        if (!this.args.quakeVector.waveforms || this.args.quakeVector.waveforms.length === 0) {
          div.select("h5").text("No data...");
        } else {
          await Ember.RSVP.all(this.args.quakeVector.waveforms.map(w => w.loadWaveform())).then(waveforms => {
            let seisDisplayDataList = [];

            for (const seis of waveforms) {
              let seisData = _seisplotjs.seismogram.SeismogramDisplayData.fromSeismogram(seis);

              seisDisplayDataList.push(seisData);
            }

            div.select("h5").remove();
            let graph = new _seisplotjs.seismograph.Seismograph(div, seisConfig, seisDisplayDataList);
            graph.draw();

            if (graph.checkResize()) {
              graph.draw();
            }

            return waveforms;
          }).then(waveforms => {
            console.log('draw waveforms then finished');
          });
        }
      } else {
        div.append('p').text("SeismogramDisplay but no QV...");
      }
    }

  }, (_applyDecoratedDescriptor(_class.prototype, "createGraph", [Ember._action], Object.getOwnPropertyDescriptor(_class.prototype, "createGraph"), _class.prototype)), _class);
  _exports.default = SeismogramDisplayComponent;

  Ember._setComponentTemplate(__COLOCATED_TEMPLATE__, SeismogramDisplayComponent);
});
;define("sodstatus/components/show-hide", ["exports", "@glimmer/component"], function (_exports, _component) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _class, _descriptor, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  const __COLOCATED_TEMPLATE__ = Ember.HTMLBars.template(
  /*
    <button {{on "click" this.toggleHide}}>{{this.buttonText}} {{@divTitle}}</button>
  <div class="show-hide" hidden={{this.isHidden}}>
    {{yield}}
  </div>
  
  */
  {
    id: "5pkYrE05",
    block: "{\"symbols\":[\"@divTitle\",\"&default\"],\"statements\":[[7,\"button\",false],[3,\"on\",[\"click\",[23,0,[\"toggleHide\"]]]],[8],[1,[23,0,[\"buttonText\"]],false],[0,\" \"],[1,[23,1,[]],false],[9],[0,\"\\n\"],[7,\"div\",true],[10,\"class\",\"show-hide\"],[11,\"hidden\",[23,0,[\"isHidden\"]]],[8],[0,\"\\n  \"],[14,2],[0,\"\\n\"],[9],[0,\"\\n\"]],\"hasEval\":false}",
    meta: {
      moduleName: "sodstatus/components/show-hide.hbs"
    }
  });

  let ShowHideComponent = (_class = (_temp = class ShowHideComponent extends _component.default {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "hide", _descriptor, this);
    }

    get isHidden() {
      return this.hide;
    }

    toggleHide() {
      this.hide = !this.hide;
    }

    get buttonText() {
      return this.hide ? "Show" : "Hide";
    }

    showMe() {
      this.hide = false;
    }

    hideMe() {
      this.hide = true;
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "hide", [Ember._tracked], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: function () {
      return false;
    }
  }), _applyDecoratedDescriptor(_class.prototype, "toggleHide", [Ember._action], Object.getOwnPropertyDescriptor(_class.prototype, "toggleHide"), _class.prototype), _applyDecoratedDescriptor(_class.prototype, "showMe", [Ember._action], Object.getOwnPropertyDescriptor(_class.prototype, "showMe"), _class.prototype), _applyDecoratedDescriptor(_class.prototype, "hideMe", [Ember._action], Object.getOwnPropertyDescriptor(_class.prototype, "hideMe"), _class.prototype)), _class);
  _exports.default = ShowHideComponent;

  Ember._setComponentTemplate(__COLOCATED_TEMPLATE__, ShowHideComponent);
});
;define("sodstatus/components/station-info", ["exports", "@glimmer/component"], function (_exports, _component) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  const __COLOCATED_TEMPLATE__ = Ember.HTMLBars.template(
  /*
    <div class="station-info">
  
  
  <table>
    <tbody>
      <tr>
        <td>Network</td>
        <td><LinkTo @route='networks.network'  @model={{@station.network}}>
            {{@station.network.networkCode}}
          </LinkTo></td>
      </tr>
      <tr>
        <td>Station</td>
        <td><LinkTo @route='stations.station.quakes' @model={{@station}}>{{@station.stationCode}}</LinkTo></td>
      </tr>
      <tr>
        <td>Name</td>
        <td>{{@station.site.name}}</td>
      </tr>
      <tr>
        <td>Desc</td>
        <td>{{@station.site.description}}</td>
      </tr>
      <tr>
        <td>Time Epoch</td>
        <td>{{format-iso-date @station.startTime format='YYYY-MM-DD'}}
        {{#if @station.endTime}} to {{format-iso-date @station.endTime format='YYYY-MM-DD'}}
        {{else}}
        until&#8230;
        {{/if}}</td>
      </tr>
      <tr>
        <td>Lat/Lon</td>
        <td>({{@station.latitudeFormatted}}, {{@station.longitudeFormatted}})</td>
      </tr>
      <tr>
        <td>Elevation</td>
        <td>{{@station.elevationFormatted}} m</td>
      </tr>
    </tbody>
  </table>
  
  <h5>Channels</h5>
  
  <ShowHide @divTitle="Channels">
        <table>
         <tr><th>Id</th>
             <th>Codes</th>
             <th>Start</th>
             <th>End</th>
             <th>Lat</th>
             <th>Lon</th>
             <th>Elev</th>
             <th>Depth</th>
             <th>Sps</th>
         </tr>
        {{#each @station.channels as |chan|}}
          <tr><td>{{chan.id}}</td>
              <td> {{chan.locCode}}.{{chan.channelCode}}</td>
              <td>{{format-iso-date chan.startTime format='YYYY-MM-DD'}}</td>
              <td>{{format-iso-date chan.endTime format='YYYY-MM-DD'}}</td>
              <td>{{chan.latitudeFormatted}}</td>
              <td>{{chan.longitudeFormatted}}</td>
              <td>{{chan.elevationFormatted}}</td>
              <td>{{chan.depthFormatted}}</td>
              <td>{{chan.sps}}</td>
          </tr>
        {{/each}}
        </table>
    </ShowHide>
  </div>
  
  
  
  {{yield}}
  
  */
  {
    id: "prUkfKTf",
    block: "{\"symbols\":[\"chan\",\"@station\",\"&default\"],\"statements\":[[7,\"div\",true],[10,\"class\",\"station-info\"],[8],[0,\"\\n\\n\\n\"],[7,\"table\",true],[8],[0,\"\\n  \"],[7,\"tbody\",true],[8],[0,\"\\n    \"],[7,\"tr\",true],[8],[0,\"\\n      \"],[7,\"td\",true],[8],[0,\"Network\"],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[5,\"link-to\",[],[[\"@route\",\"@model\"],[\"networks.network\",[23,2,[\"network\"]]]],{\"statements\":[[0,\"\\n          \"],[1,[23,2,[\"network\",\"networkCode\"]],false],[0,\"\\n        \"]],\"parameters\":[]}],[9],[0,\"\\n    \"],[9],[0,\"\\n    \"],[7,\"tr\",true],[8],[0,\"\\n      \"],[7,\"td\",true],[8],[0,\"Station\"],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[5,\"link-to\",[],[[\"@route\",\"@model\"],[\"stations.station.quakes\",[23,2,[]]]],{\"statements\":[[1,[23,2,[\"stationCode\"]],false]],\"parameters\":[]}],[9],[0,\"\\n    \"],[9],[0,\"\\n    \"],[7,\"tr\",true],[8],[0,\"\\n      \"],[7,\"td\",true],[8],[0,\"Name\"],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,2,[\"site\",\"name\"]],false],[9],[0,\"\\n    \"],[9],[0,\"\\n    \"],[7,\"tr\",true],[8],[0,\"\\n      \"],[7,\"td\",true],[8],[0,\"Desc\"],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,2,[\"site\",\"description\"]],false],[9],[0,\"\\n    \"],[9],[0,\"\\n    \"],[7,\"tr\",true],[8],[0,\"\\n      \"],[7,\"td\",true],[8],[0,\"Time Epoch\"],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[28,\"format-iso-date\",[[23,2,[\"startTime\"]]],[[\"format\"],[\"YYYY-MM-DD\"]]],false],[0,\"\\n      \"],[4,\"if\",[[23,2,[\"endTime\"]]],null,{\"statements\":[[0,\" to \"],[1,[28,\"format-iso-date\",[[23,2,[\"endTime\"]]],[[\"format\"],[\"YYYY-MM-DD\"]]],false],[0,\"\\n\"]],\"parameters\":[]},{\"statements\":[[0,\"      until\u2026\\n      \"]],\"parameters\":[]}],[9],[0,\"\\n    \"],[9],[0,\"\\n    \"],[7,\"tr\",true],[8],[0,\"\\n      \"],[7,\"td\",true],[8],[0,\"Lat/Lon\"],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[0,\"(\"],[1,[23,2,[\"latitudeFormatted\"]],false],[0,\", \"],[1,[23,2,[\"longitudeFormatted\"]],false],[0,\")\"],[9],[0,\"\\n    \"],[9],[0,\"\\n    \"],[7,\"tr\",true],[8],[0,\"\\n      \"],[7,\"td\",true],[8],[0,\"Elevation\"],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,2,[\"elevationFormatted\"]],false],[0,\" m\"],[9],[0,\"\\n    \"],[9],[0,\"\\n  \"],[9],[0,\"\\n\"],[9],[0,\"\\n\\n\"],[7,\"h5\",true],[8],[0,\"Channels\"],[9],[0,\"\\n\\n\"],[5,\"show-hide\",[],[[\"@divTitle\"],[\"Channels\"]],{\"statements\":[[0,\"\\n      \"],[7,\"table\",true],[8],[0,\"\\n       \"],[7,\"tr\",true],[8],[7,\"th\",true],[8],[0,\"Id\"],[9],[0,\"\\n           \"],[7,\"th\",true],[8],[0,\"Codes\"],[9],[0,\"\\n           \"],[7,\"th\",true],[8],[0,\"Start\"],[9],[0,\"\\n           \"],[7,\"th\",true],[8],[0,\"End\"],[9],[0,\"\\n           \"],[7,\"th\",true],[8],[0,\"Lat\"],[9],[0,\"\\n           \"],[7,\"th\",true],[8],[0,\"Lon\"],[9],[0,\"\\n           \"],[7,\"th\",true],[8],[0,\"Elev\"],[9],[0,\"\\n           \"],[7,\"th\",true],[8],[0,\"Depth\"],[9],[0,\"\\n           \"],[7,\"th\",true],[8],[0,\"Sps\"],[9],[0,\"\\n       \"],[9],[0,\"\\n\"],[4,\"each\",[[23,2,[\"channels\"]]],null,{\"statements\":[[0,\"        \"],[7,\"tr\",true],[8],[7,\"td\",true],[8],[1,[23,1,[\"id\"]],false],[9],[0,\"\\n            \"],[7,\"td\",true],[8],[0,\" \"],[1,[23,1,[\"locCode\"]],false],[0,\".\"],[1,[23,1,[\"channelCode\"]],false],[9],[0,\"\\n            \"],[7,\"td\",true],[8],[1,[28,\"format-iso-date\",[[23,1,[\"startTime\"]]],[[\"format\"],[\"YYYY-MM-DD\"]]],false],[9],[0,\"\\n            \"],[7,\"td\",true],[8],[1,[28,\"format-iso-date\",[[23,1,[\"endTime\"]]],[[\"format\"],[\"YYYY-MM-DD\"]]],false],[9],[0,\"\\n            \"],[7,\"td\",true],[8],[1,[23,1,[\"latitudeFormatted\"]],false],[9],[0,\"\\n            \"],[7,\"td\",true],[8],[1,[23,1,[\"longitudeFormatted\"]],false],[9],[0,\"\\n            \"],[7,\"td\",true],[8],[1,[23,1,[\"elevationFormatted\"]],false],[9],[0,\"\\n            \"],[7,\"td\",true],[8],[1,[23,1,[\"depthFormatted\"]],false],[9],[0,\"\\n            \"],[7,\"td\",true],[8],[1,[23,1,[\"sps\"]],false],[9],[0,\"\\n        \"],[9],[0,\"\\n\"]],\"parameters\":[1]},null],[0,\"      \"],[9],[0,\"\\n  \"]],\"parameters\":[]}],[0,\"\\n\"],[9],[0,\"\\n\\n\\n\\n\"],[14,3],[0,\"\\n\"]],\"hasEval\":false}",
    meta: {
      moduleName: "sodstatus/components/station-info.hbs"
    }
  });

  class StationInfoComponent extends _component.default {}

  _exports.default = StationInfoComponent;

  Ember._setComponentTemplate(__COLOCATED_TEMPLATE__, StationInfoComponent);
});
;define("sodstatus/components/station-list", ["exports", "@glimmer/component"], function (_exports, _component) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _dec, _class, _descriptor, _descriptor2, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  const __COLOCATED_TEMPLATE__ = Ember.HTMLBars.template(
  /*
    <table >
    <thead>
      <th {{action "sortBy" "codes"}}>Codes</th>
      <th {{action "sortBy" "latitude"}}>Lat</th>
      <th {{action "sortBy" "longitude"}}>Lon</th>
      <th {{action "sortBy" "name"}}>Name</th>
      </thead>
    {{#each sortedStations as |s|}}
      <tr>
        <td><LinkTo @route='stations.station' @model={{s.id}} >{{s.codes}}</LinkTo></td>
        <td>{{s.latitudeFormatted}}</td>
        <td>{{s.longitudeFormatted}}</td>
        <td>{{s.site.name}}</td>
      </tr>
    {{/each}}
  </table>
  
  {{yield}}
  
  */
  {
    id: "jDClPUeC",
    block: "{\"symbols\":[\"s\",\"&default\"],\"statements\":[[7,\"table\",true],[8],[0,\"\\n  \"],[7,\"thead\",true],[8],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"codes\"]],[8],[0,\"Codes\"],[9],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"latitude\"]],[8],[0,\"Lat\"],[9],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"longitude\"]],[8],[0,\"Lon\"],[9],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"name\"]],[8],[0,\"Name\"],[9],[0,\"\\n    \"],[9],[0,\"\\n\"],[4,\"each\",[[24,[\"sortedStations\"]]],null,{\"statements\":[[0,\"    \"],[7,\"tr\",true],[8],[0,\"\\n      \"],[7,\"td\",true],[8],[5,\"link-to\",[],[[\"@route\",\"@model\"],[\"stations.station\",[23,1,[\"id\"]]]],{\"statements\":[[1,[23,1,[\"codes\"]],false]],\"parameters\":[]}],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"latitudeFormatted\"]],false],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"longitudeFormatted\"]],false],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"site\",\"name\"]],false],[9],[0,\"\\n    \"],[9],[0,\"\\n\"]],\"parameters\":[1]},null],[9],[0,\"\\n\\n\"],[14,2],[0,\"\\n\"]],\"hasEval\":false}",
    meta: {
      moduleName: "sodstatus/components/station-list.hbs"
    }
  });

  let StationListComponent = (_dec = Ember.computed.sort('args.stations', 'sortDefinition'), (_class = (_temp = class StationListComponent extends _component.default {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "sortDefinition", _descriptor, this);

      _initializerDefineProperty(this, "sortedStations", _descriptor2, this);
    }

    sortBy(key) {
      let direction = "asc";

      if (this.sortDefinition[0].startsWith(key)) {
        if (this.sortDefinition[0].endsWith(":desc")) {
          direction = "asc";
        } else {
          direction = "desc";
        }
      } else {
        direction = "asc";
      }

      this.sortDefinition = [key + ":" + direction];
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "sortDefinition", [Ember._tracked], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: function () {
      return ['station.stationCode'];
    }
  }), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, "sortedStations", [_dec], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _applyDecoratedDescriptor(_class.prototype, "sortBy", [Ember._action], Object.getOwnPropertyDescriptor(_class.prototype, "sortBy"), _class.prototype)), _class));
  _exports.default = StationListComponent;

  Ember._setComponentTemplate(__COLOCATED_TEMPLATE__, StationListComponent);
});
;define("sodstatus/components/station-quakes-list", ["exports", "@glimmer/component"], function (_exports, _component) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _dec, _class, _descriptor, _descriptor2, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  const __COLOCATED_TEMPLATE__ = Ember.HTMLBars.template(
  /*
    <div class="station-quakes-list">
  <table >
    <thead>
      <th {{action "sortBy" "quake.name"}}>Name</th>
      <th {{action "sortBy" "distdeg"}}>Dist</th>
      <th {{action "sortBy" "quake.prefOrigin.time"}}>Time</th>
      <th {{action "sortBy" "quake.prefMagnitude.value"}}>Mag</th>
      <th {{action "sortBy" "quake.prefOrigin.latitude"}}>Lat</th>
      <th {{action "sortBy" "quake.prefOrigin.longitude"}}>Lon</th>
      <th {{action "sortBy" "quake.prefOrigin.depth"}}>Depth(km)</th>
      <th {{action "sortBy" "sodStatus"}}>Status</th>
      </thead>
    {{#each sortedQuakes as |esps|}}
      <tr>
        <td><LinkTo @route='quake-stations.quake-station' @model={{esps.id}} >{{esps.quake.name}}</LinkTo></td>
        <td>{{format-number esps.distdeg 2 }}</td>
        <td>{{format-iso-date esps.quake.prefOrigin.time }}</td>
        <td>{{esps.quake.prefMagnitude.magFormatted}} {{esps.quake.prefMagnitude.magType}}</td>
        <td>{{esps.quake.prefOrigin.latitudeFormatted}}</td>
        <td>{{esps.quake.prefOrigin.longitudeFormatted}}</td>
        <td>{{esps.quake.prefOrigin.depthFormatted}} km</td>
        <td>{{esps.quake.sodStatus}}</td>
      </tr>
    {{/each}}
  </table>
  
  {{yield}}
  </div>
  
  */
  {
    id: "masWqfGE",
    block: "{\"symbols\":[\"esps\",\"&default\"],\"statements\":[[7,\"div\",true],[10,\"class\",\"station-quakes-list\"],[8],[0,\"\\n\"],[7,\"table\",true],[8],[0,\"\\n  \"],[7,\"thead\",true],[8],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"quake.name\"]],[8],[0,\"Name\"],[9],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"distdeg\"]],[8],[0,\"Dist\"],[9],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"quake.prefOrigin.time\"]],[8],[0,\"Time\"],[9],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"quake.prefMagnitude.value\"]],[8],[0,\"Mag\"],[9],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"quake.prefOrigin.latitude\"]],[8],[0,\"Lat\"],[9],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"quake.prefOrigin.longitude\"]],[8],[0,\"Lon\"],[9],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"quake.prefOrigin.depth\"]],[8],[0,\"Depth(km)\"],[9],[0,\"\\n    \"],[7,\"th\",false],[3,\"action\",[[23,0,[]],\"sortBy\",\"sodStatus\"]],[8],[0,\"Status\"],[9],[0,\"\\n    \"],[9],[0,\"\\n\"],[4,\"each\",[[24,[\"sortedQuakes\"]]],null,{\"statements\":[[0,\"    \"],[7,\"tr\",true],[8],[0,\"\\n      \"],[7,\"td\",true],[8],[5,\"link-to\",[],[[\"@route\",\"@model\"],[\"quake-stations.quake-station\",[23,1,[\"id\"]]]],{\"statements\":[[1,[23,1,[\"quake\",\"name\"]],false]],\"parameters\":[]}],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[28,\"format-number\",[[23,1,[\"distdeg\"]],2],null],false],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[28,\"format-iso-date\",[[23,1,[\"quake\",\"prefOrigin\",\"time\"]]],null],false],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"quake\",\"prefMagnitude\",\"magFormatted\"]],false],[0,\" \"],[1,[23,1,[\"quake\",\"prefMagnitude\",\"magType\"]],false],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"quake\",\"prefOrigin\",\"latitudeFormatted\"]],false],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"quake\",\"prefOrigin\",\"longitudeFormatted\"]],false],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"quake\",\"prefOrigin\",\"depthFormatted\"]],false],[0,\" km\"],[9],[0,\"\\n      \"],[7,\"td\",true],[8],[1,[23,1,[\"quake\",\"sodStatus\"]],false],[9],[0,\"\\n    \"],[9],[0,\"\\n\"]],\"parameters\":[1]},null],[9],[0,\"\\n\\n\"],[14,2],[0,\"\\n\"],[9],[0,\"\\n\"]],\"hasEval\":false}",
    meta: {
      moduleName: "sodstatus/components/station-quakes-list.hbs"
    }
  });

  let StationQuakesListComponent = (_dec = Ember.computed.sort('args.quakeStationPairs', 'sortDefinition'), (_class = (_temp = class StationQuakesListComponent extends _component.default {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "sortDefinition", _descriptor, this);

      _initializerDefineProperty(this, "sortedQuakes", _descriptor2, this);
    }

    sortBy(key) {
      console.log(`sortBy(${key})  `);
      let direction = "asc";

      if (this.sortDefinition[0].startsWith(key)) {
        if (this.sortDefinition[0].endsWith(":desc")) {
          direction = "asc";
        } else {
          direction = "desc";
        }
      } else {
        direction = "asc";
      }

      this.sortDefinition = [key + ":" + direction];
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "sortDefinition", [Ember._tracked], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: function () {
      return ['quake.prefOrigin.time'];
    }
  }), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, "sortedQuakes", [_dec], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _applyDecoratedDescriptor(_class.prototype, "sortBy", [Ember._action], Object.getOwnPropertyDescriptor(_class.prototype, "sortBy"), _class.prototype)), _class));
  _exports.default = StationQuakesListComponent;

  Ember._setComponentTemplate(__COLOCATED_TEMPLATE__, StationQuakesListComponent);
});
;define("sodstatus/components/tile-layer", ["exports", "ember-leaflet/components/tile-layer"], function (_exports, _tileLayer) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _tileLayer.default;
    }
  });
});
;define("sodstatus/components/tooltip-layer", ["exports", "ember-leaflet/components/tooltip-layer"], function (_exports, _tooltipLayer) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _tooltipLayer.default;
    }
  });
});
;define("sodstatus/components/video-layer", ["exports", "ember-leaflet/components/video-layer"], function (_exports, _videoLayer) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _videoLayer.default;
    }
  });
});
;define("sodstatus/components/welcome-page", ["exports", "ember-welcome-page/components/welcome-page"], function (_exports, _welcomePage) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _welcomePage.default;
    }
  });
});
;define("sodstatus/components/wms-tile-layer", ["exports", "ember-leaflet/components/wms-tile-layer"], function (_exports, _wmsTileLayer) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _wmsTileLayer.default;
    }
  });
});
;define("sodstatus/controllers/perusals/new", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _class;

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  let PerusalsNewController = (_class = class PerusalsNewController extends Ember.Controller {
    save(model) {
      return this.transitionToRoute('perusals.perusal', model);
    }

    cancel() {
      return this.transitionToRoute('perusals');
    }

  }, (_applyDecoratedDescriptor(_class.prototype, "save", [Ember._action], Object.getOwnPropertyDescriptor(_class.prototype, "save"), _class.prototype), _applyDecoratedDescriptor(_class.prototype, "cancel", [Ember._action], Object.getOwnPropertyDescriptor(_class.prototype, "cancel"), _class.prototype)), _class);
  _exports.default = PerusalsNewController;
});
;define("sodstatus/data-adapter", ["exports", "@ember-data/debug"], function (_exports, _debug) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _debug.default;
    }
  });
});
;define("sodstatus/helpers/-clear-element", ["exports", "ember-in-element-polyfill/helpers/-clear-element"], function (_exports, _clearElement) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _clearElement.default;
    }
  });
  Object.defineProperty(_exports, "clearElement", {
    enumerable: true,
    get: function () {
      return _clearElement.clearElement;
    }
  });
});
;define("sodstatus/helpers/add-360", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.Helper.helper(function add360(lon) {
    return lon + 360;
  });

  _exports.default = _default;
});
;define("sodstatus/helpers/and", ["exports", "ember-truth-helpers/helpers/and"], function (_exports, _and) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _and.default;
    }
  });
  Object.defineProperty(_exports, "and", {
    enumerable: true,
    get: function () {
      return _and.and;
    }
  });
});
;define("sodstatus/helpers/app-version", ["exports", "sodstatus/config/environment", "ember-cli-app-version/utils/regexp"], function (_exports, _environment, _regexp) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.appVersion = appVersion;
  _exports.default = void 0;

  function appVersion(_, hash = {}) {
    const version = _environment.default.APP.version; // e.g. 1.0.0-alpha.1+4jds75hf
    // Allow use of 'hideSha' and 'hideVersion' For backwards compatibility

    let versionOnly = hash.versionOnly || hash.hideSha;
    let shaOnly = hash.shaOnly || hash.hideVersion;
    let match = null;

    if (versionOnly) {
      if (hash.showExtended) {
        match = version.match(_regexp.versionExtendedRegExp); // 1.0.0-alpha.1
      } // Fallback to just version


      if (!match) {
        match = version.match(_regexp.versionRegExp); // 1.0.0
      }
    }

    if (shaOnly) {
      match = version.match(_regexp.shaRegExp); // 4jds75hf
    }

    return match ? match[0] : version;
  }

  var _default = Ember.Helper.helper(appVersion);

  _exports.default = _default;
});
;define("sodstatus/helpers/div-icon", ["exports", "ember-leaflet/helpers/div-icon"], function (_exports, _divIcon) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _divIcon.default;
    }
  });
  Object.defineProperty(_exports, "divIcon", {
    enumerable: true,
    get: function () {
      return _divIcon.divIcon;
    }
  });
});
;define("sodstatus/helpers/ember-leaflet-assign-to", ["exports", "ember-leaflet/helpers/ember-leaflet-assign-to"], function (_exports, _emberLeafletAssignTo) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _emberLeafletAssignTo.default;
    }
  });
  Object.defineProperty(_exports, "emberLeafletAssignTo", {
    enumerable: true,
    get: function () {
      return _emberLeafletAssignTo.emberLeafletAssignTo;
    }
  });
});
;define("sodstatus/helpers/eq", ["exports", "ember-truth-helpers/helpers/equal"], function (_exports, _equal) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _equal.default;
    }
  });
  Object.defineProperty(_exports, "equal", {
    enumerable: true,
    get: function () {
      return _equal.equal;
    }
  });
});
;define("sodstatus/helpers/format-iso-date", ["exports", "moment"], function (_exports, _moment) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.Helper.helper(function formatIsoDate(params, hash) {
    if (typeof params[0] === 'undefined') return "";
    let defaultFormat = 'YYYY-MM-DD[T]HH:mm:ss.SSSS';
    let date = params[0];
    let format = hash.format === undefined ? defaultFormat : hash.format;

    if (date === undefined || date === null) {
      return "";
    } else {
      return (0, _moment.default)(date).utc().format(format);
    }
  });

  _exports.default = _default;
});
;define("sodstatus/helpers/format-number", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.Helper.helper(function formatNumber(params
  /*, hash*/
  ) {
    if (typeof params[0] === 'undefined') {
      return "";
    }

    let decimalDigits = params[1] === undefined ? 2 : params[1];
    return params[0].toFixed(decimalDigits);
  });

  _exports.default = _default;
});
;define("sodstatus/helpers/format-xml", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.Helper.helper(function formatXml(params
  /*, hash*/
  ) {
    let raw = params[0];
    return Ember.String.htmlSafe(doformatXml(raw));
  }); // modified from from https://gist.github.com/kurtsson/3f1c8efc0ccd549c9e31


  _exports.default = _default;

  function doformatXml(xml) {
    var formatted = '';
    var zapSpace = /(>)( )+(<)(\/*)/g;
    xml = xml.toString().replace(zapSpace, '$1\r\n$3$4');
    var reg = /(>)(<)(\/*)/g;
    xml = xml.toString().replace(reg, '$1\r\n$2$3');
    var pad = 0;
    var nodes = xml.split('\r\n');

    for (var n = 0; n < nodes.length; n++) {
      var node = nodes[n];
      var indent = 0;

      if (node.match(/.+<\/\w[^>]*>$/)) {
        indent = 0;
      } else if (node.match(/^<\/\w/)) {
        if (pad !== 0) {
          pad -= 1;
        }
      } else if (node.match(/^<\w[^>]*[^/]>.*$/)) {
        indent = 1;
      } else {
        indent = 0;
      }

      var padding = '';

      for (var i = 0; i < pad; i++) {
        //padding += '  ';
        padding += '  ';
      } //formatted += padding + escapeBrackets(node) + '<br/>';


      formatted += padding + escapeBrackets(node) + '\n';
      pad += indent;
    }

    return formatted;
  }

  function escapeBrackets(node) {
    //return formatted.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;').replace(/ /g, '&nbsp;');
    return node.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/ /g, '&nbsp;');
  }
});
;define("sodstatus/helpers/gt", ["exports", "ember-truth-helpers/helpers/gt"], function (_exports, _gt) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _gt.default;
    }
  });
  Object.defineProperty(_exports, "gt", {
    enumerable: true,
    get: function () {
      return _gt.gt;
    }
  });
});
;define("sodstatus/helpers/gte", ["exports", "ember-truth-helpers/helpers/gte"], function (_exports, _gte) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _gte.default;
    }
  });
  Object.defineProperty(_exports, "gte", {
    enumerable: true,
    get: function () {
      return _gte.gte;
    }
  });
});
;define("sodstatus/helpers/icon", ["exports", "ember-leaflet/helpers/icon"], function (_exports, _icon) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _icon.default;
    }
  });
  Object.defineProperty(_exports, "icon", {
    enumerable: true,
    get: function () {
      return _icon.icon;
    }
  });
});
;define("sodstatus/helpers/is-after", ["exports", "ember-moment/helpers/is-after"], function (_exports, _isAfter) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _isAfter.default;
    }
  });
});
;define("sodstatus/helpers/is-array", ["exports", "ember-truth-helpers/helpers/is-array"], function (_exports, _isArray) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _isArray.default;
    }
  });
  Object.defineProperty(_exports, "isArray", {
    enumerable: true,
    get: function () {
      return _isArray.isArray;
    }
  });
});
;define("sodstatus/helpers/is-before", ["exports", "ember-moment/helpers/is-before"], function (_exports, _isBefore) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _isBefore.default;
    }
  });
});
;define("sodstatus/helpers/is-between", ["exports", "ember-moment/helpers/is-between"], function (_exports, _isBetween) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _isBetween.default;
    }
  });
});
;define("sodstatus/helpers/is-empty", ["exports", "ember-truth-helpers/helpers/is-empty"], function (_exports, _isEmpty) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _isEmpty.default;
    }
  });
});
;define("sodstatus/helpers/is-equal", ["exports", "ember-truth-helpers/helpers/is-equal"], function (_exports, _isEqual) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _isEqual.default;
    }
  });
  Object.defineProperty(_exports, "isEqual", {
    enumerable: true,
    get: function () {
      return _isEqual.isEqual;
    }
  });
});
;define("sodstatus/helpers/is-same-or-after", ["exports", "ember-moment/helpers/is-same-or-after"], function (_exports, _isSameOrAfter) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _isSameOrAfter.default;
    }
  });
});
;define("sodstatus/helpers/is-same-or-before", ["exports", "ember-moment/helpers/is-same-or-before"], function (_exports, _isSameOrBefore) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _isSameOrBefore.default;
    }
  });
});
;define("sodstatus/helpers/is-same", ["exports", "ember-moment/helpers/is-same"], function (_exports, _isSame) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _isSame.default;
    }
  });
});
;define("sodstatus/helpers/lat-lng-bounds", ["exports", "ember-leaflet/helpers/lat-lng-bounds"], function (_exports, _latLngBounds) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _latLngBounds.default;
    }
  });
  Object.defineProperty(_exports, "latLngBounds", {
    enumerable: true,
    get: function () {
      return _latLngBounds.latLngBounds;
    }
  });
});
;define("sodstatus/helpers/lf-lock-model", ["exports", "liquid-fire/helpers/lf-lock-model"], function (_exports, _lfLockModel) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _lfLockModel.default;
    }
  });
  Object.defineProperty(_exports, "lfLockModel", {
    enumerable: true,
    get: function () {
      return _lfLockModel.lfLockModel;
    }
  });
});
;define("sodstatus/helpers/lf-or", ["exports", "liquid-fire/helpers/lf-or"], function (_exports, _lfOr) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _lfOr.default;
    }
  });
  Object.defineProperty(_exports, "lfOr", {
    enumerable: true,
    get: function () {
      return _lfOr.lfOr;
    }
  });
});
;define("sodstatus/helpers/lt", ["exports", "ember-truth-helpers/helpers/lt"], function (_exports, _lt) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _lt.default;
    }
  });
  Object.defineProperty(_exports, "lt", {
    enumerable: true,
    get: function () {
      return _lt.lt;
    }
  });
});
;define("sodstatus/helpers/lte", ["exports", "ember-truth-helpers/helpers/lte"], function (_exports, _lte) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _lte.default;
    }
  });
  Object.defineProperty(_exports, "lte", {
    enumerable: true,
    get: function () {
      return _lte.lte;
    }
  });
});
;define("sodstatus/helpers/moment-add", ["exports", "ember-moment/helpers/moment-add"], function (_exports, _momentAdd) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _momentAdd.default;
    }
  });
});
;define("sodstatus/helpers/moment-calendar", ["exports", "ember-moment/helpers/moment-calendar"], function (_exports, _momentCalendar) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _momentCalendar.default;
    }
  });
});
;define("sodstatus/helpers/moment-diff", ["exports", "ember-moment/helpers/moment-diff"], function (_exports, _momentDiff) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _momentDiff.default;
    }
  });
});
;define("sodstatus/helpers/moment-duration", ["exports", "ember-moment/helpers/moment-duration"], function (_exports, _momentDuration) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _momentDuration.default;
    }
  });
});
;define("sodstatus/helpers/moment-format", ["exports", "ember-moment/helpers/moment-format"], function (_exports, _momentFormat) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _momentFormat.default;
    }
  });
});
;define("sodstatus/helpers/moment-from-now", ["exports", "ember-moment/helpers/moment-from-now"], function (_exports, _momentFromNow) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _momentFromNow.default;
    }
  });
});
;define("sodstatus/helpers/moment-from", ["exports", "ember-moment/helpers/moment-from"], function (_exports, _momentFrom) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _momentFrom.default;
    }
  });
});
;define("sodstatus/helpers/moment-subtract", ["exports", "ember-moment/helpers/moment-subtract"], function (_exports, _momentSubtract) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _momentSubtract.default;
    }
  });
});
;define("sodstatus/helpers/moment-to-date", ["exports", "ember-moment/helpers/moment-to-date"], function (_exports, _momentToDate) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _momentToDate.default;
    }
  });
});
;define("sodstatus/helpers/moment-to-now", ["exports", "ember-moment/helpers/moment-to-now"], function (_exports, _momentToNow) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _momentToNow.default;
    }
  });
});
;define("sodstatus/helpers/moment-to", ["exports", "ember-moment/helpers/moment-to"], function (_exports, _momentTo) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _momentTo.default;
    }
  });
});
;define("sodstatus/helpers/moment-unix", ["exports", "ember-moment/helpers/unix"], function (_exports, _unix) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _unix.default;
    }
  });
});
;define("sodstatus/helpers/moment", ["exports", "ember-moment/helpers/moment"], function (_exports, _moment) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _moment.default;
    }
  });
});
;define("sodstatus/helpers/not-eq", ["exports", "ember-truth-helpers/helpers/not-equal"], function (_exports, _notEqual) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _notEqual.default;
    }
  });
  Object.defineProperty(_exports, "notEq", {
    enumerable: true,
    get: function () {
      return _notEqual.notEq;
    }
  });
});
;define("sodstatus/helpers/not", ["exports", "ember-truth-helpers/helpers/not"], function (_exports, _not) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _not.default;
    }
  });
  Object.defineProperty(_exports, "not", {
    enumerable: true,
    get: function () {
      return _not.not;
    }
  });
});
;define("sodstatus/helpers/now", ["exports", "ember-moment/helpers/now"], function (_exports, _now) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _now.default;
    }
  });
});
;define("sodstatus/helpers/or", ["exports", "ember-truth-helpers/helpers/or"], function (_exports, _or) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _or.default;
    }
  });
  Object.defineProperty(_exports, "or", {
    enumerable: true,
    get: function () {
      return _or.or;
    }
  });
});
;define("sodstatus/helpers/pluralize", ["exports", "ember-inflector/lib/helpers/pluralize"], function (_exports, _pluralize) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  var _default = _pluralize.default;
  _exports.default = _default;
});
;define("sodstatus/helpers/point", ["exports", "ember-leaflet/helpers/point"], function (_exports, _point) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _point.default;
    }
  });
  Object.defineProperty(_exports, "point", {
    enumerable: true,
    get: function () {
      return _point.point;
    }
  });
});
;define("sodstatus/helpers/scaled-magnitude", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.Helper.helper(function scaledMagnitude([quake], {
    pixelsPerMag
  }) {
    let pxPer = pixelsPerMag || 5;
    pxPer = 1.0 * pxPer;
    return quake.get('prefMagnitude').get('value') * pxPer;
  });

  _exports.default = _default;
});
;define("sodstatus/helpers/singularize", ["exports", "ember-inflector/lib/helpers/singularize"], function (_exports, _singularize) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  var _default = _singularize.default;
  _exports.default = _default;
});
;define("sodstatus/helpers/sub-360", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.Helper.helper(function sub360(lon) {
    return lon - 360;
  });

  _exports.default = _default;
});
;define("sodstatus/helpers/unix", ["exports", "ember-moment/helpers/unix"], function (_exports, _unix) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _unix.default;
    }
  });
});
;define("sodstatus/helpers/utc", ["exports", "ember-moment/helpers/utc"], function (_exports, _utc) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _utc.default;
    }
  });
  Object.defineProperty(_exports, "utc", {
    enumerable: true,
    get: function () {
      return _utc.utc;
    }
  });
});
;define("sodstatus/helpers/xor", ["exports", "ember-truth-helpers/helpers/xor"], function (_exports, _xor) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _xor.default;
    }
  });
  Object.defineProperty(_exports, "xor", {
    enumerable: true,
    get: function () {
      return _xor.xor;
    }
  });
});
;define("sodstatus/initializers/app-version", ["exports", "ember-cli-app-version/initializer-factory", "sodstatus/config/environment"], function (_exports, _initializerFactory, _environment) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  let name, version;

  if (_environment.default.APP) {
    name = _environment.default.APP.name;
    version = _environment.default.APP.version;
  }

  var _default = {
    name: 'App Version',
    initialize: (0, _initializerFactory.default)(name, version)
  };
  _exports.default = _default;
});
;define("sodstatus/initializers/container-debug-adapter", ["exports", "ember-resolver/resolvers/classic/container-debug-adapter"], function (_exports, _containerDebugAdapter) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  var _default = {
    name: 'container-debug-adapter',

    initialize() {
      let app = arguments[1] || arguments[0];
      app.register('container-debug-adapter:main', _containerDebugAdapter.default);
      app.inject('container-debug-adapter:main', 'namespace', 'application:main');
    }

  };
  _exports.default = _default;
});
;define("sodstatus/initializers/ember-data-data-adapter", ["exports", "@ember-data/debug/setup"], function (_exports, _setup) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _setup.default;
    }
  });
});
;define("sodstatus/initializers/ember-data", ["exports", "ember-data", "ember-data/setup-container"], function (_exports, _emberData, _setupContainer) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  /*
    This code initializes EmberData in an Ember application.
  
    It ensures that the `store` service is automatically injected
    as the `store` property on all routes and controllers.
  */
  var _default = {
    name: 'ember-data',
    initialize: _setupContainer.default
  };
  _exports.default = _default;
});
;define("sodstatus/initializers/export-application-global", ["exports", "sodstatus/config/environment"], function (_exports, _environment) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.initialize = initialize;
  _exports.default = void 0;

  function initialize() {
    var application = arguments[1] || arguments[0];

    if (_environment.default.exportApplicationGlobal !== false) {
      var theGlobal;

      if (typeof window !== 'undefined') {
        theGlobal = window;
      } else if (typeof global !== 'undefined') {
        theGlobal = global;
      } else if (typeof self !== 'undefined') {
        theGlobal = self;
      } else {
        // no reasonable global, just bail
        return;
      }

      var value = _environment.default.exportApplicationGlobal;
      var globalName;

      if (typeof value === 'string') {
        globalName = value;
      } else {
        globalName = Ember.String.classify(_environment.default.modulePrefix);
      }

      if (!theGlobal[globalName]) {
        theGlobal[globalName] = application;
        application.reopen({
          willDestroy: function () {
            this._super.apply(this, arguments);

            delete theGlobal[globalName];
          }
        });
      }
    }
  }

  var _default = {
    name: 'export-application-global',
    initialize: initialize
  };
  _exports.default = _default;
});
;define("sodstatus/initializers/leaflet-assets", ["exports", "ember-leaflet/initializers/leaflet-assets"], function (_exports, _leafletAssets) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _leafletAssets.default;
    }
  });
  Object.defineProperty(_exports, "initialize", {
    enumerable: true,
    get: function () {
      return _leafletAssets.initialize;
    }
  });
});
;define("sodstatus/initializers/liquid-fire", ["exports", "liquid-fire/velocity-ext"], function (_exports, _velocityExt) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  var _default = {
    name: 'liquid-fire',
    initialize: function () {}
  };
  _exports.default = _default;
});
;define("sodstatus/instance-initializers/ember-data", ["exports", "ember-data/initialize-store-service"], function (_exports, _initializeStoreService) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  var _default = {
    name: 'ember-data',
    initialize: _initializeStoreService.default
  };
  _exports.default = _default;
});
;define("sodstatus/models/arm", ["exports", "@ember-data/model"], function (_exports, _model) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _dec, _dec2, _class, _descriptor, _descriptor2, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  let ArmModel = (_dec = (0, _model.attr)('string'), _dec2 = (0, _model.attr)('boolean'), (_class = (_temp = class ArmModel extends _model.default {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "name", _descriptor, this);

      _initializerDefineProperty(this, "isActive", _descriptor2, this);
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "name", [_dec], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, "isActive", [_dec2], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  })), _class));
  _exports.default = ArmModel;
});
;define("sodstatus/models/channel", ["exports", "@ember-data/model"], function (_exports, _model) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _dec9, _dec10, _class, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _descriptor9, _descriptor10, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  let ChannelModel = (_dec = (0, _model.attr)('string'), _dec2 = (0, _model.attr)('string'), _dec3 = (0, _model.belongsTo)('station', {
    async: true
  }), _dec4 = (0, _model.attr)('date'), _dec5 = (0, _model.attr)('date'), _dec6 = (0, _model.attr)('number'), _dec7 = (0, _model.attr)('number'), _dec8 = (0, _model.attr)('number'), _dec9 = (0, _model.attr)('number'), _dec10 = (0, _model.attr)('number'), (_class = (_temp = class ChannelModel extends _model.default {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "channelCode", _descriptor, this);

      _initializerDefineProperty(this, "locCode", _descriptor2, this);

      _initializerDefineProperty(this, "station", _descriptor3, this);

      _initializerDefineProperty(this, "startTime", _descriptor4, this);

      _initializerDefineProperty(this, "endTime", _descriptor5, this);

      _initializerDefineProperty(this, "latitude", _descriptor6, this);

      _initializerDefineProperty(this, "longitude", _descriptor7, this);

      _initializerDefineProperty(this, "elevation", _descriptor8, this);

      _initializerDefineProperty(this, "depth", _descriptor9, this);

      _initializerDefineProperty(this, "sps", _descriptor10, this);
    }

    get latitudeFormatted() {
      if (this.latitude) {
        return this.latitude.toFixed(2);
      } else {
        return "UNDEF";
      }
    }

    get longitudeFormatted() {
      if (this.longitude) {
        return this.longitude.toFixed(2);
      } else {
        return "UNDEF";
      }
    }

    get elevationFormatted() {
      if (this.elevation) {
        return this.elevation.toFixed(2);
      } else {
        return "UNDEF";
      }
    }

    get depthFormatted() {
      if (this.depth) {
        return this.depth.toFixed(2);
      } else {
        return "UNDEF";
      }
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "channelCode", [_dec], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, "locCode", [_dec2], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor3 = _applyDecoratedDescriptor(_class.prototype, "station", [_dec3], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor4 = _applyDecoratedDescriptor(_class.prototype, "startTime", [_dec4], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor5 = _applyDecoratedDescriptor(_class.prototype, "endTime", [_dec5], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor6 = _applyDecoratedDescriptor(_class.prototype, "latitude", [_dec6], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor7 = _applyDecoratedDescriptor(_class.prototype, "longitude", [_dec7], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor8 = _applyDecoratedDescriptor(_class.prototype, "elevation", [_dec8], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor9 = _applyDecoratedDescriptor(_class.prototype, "depth", [_dec9], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor10 = _applyDecoratedDescriptor(_class.prototype, "sps", [_dec10], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  })), _class));
  _exports.default = ChannelModel;
});
;define("sodstatus/models/magnitude", ["exports", "@ember-data/model"], function (_exports, _model) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _dec, _dec2, _dec3, _class, _descriptor, _descriptor2, _descriptor3, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  let MagnitudeModel = (_dec = (0, _model.attr)('number'), _dec2 = (0, _model.attr)('string'), _dec3 = (0, _model.attr)('string'), (_class = (_temp = class MagnitudeModel extends _model.default {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "value", _descriptor, this);

      _initializerDefineProperty(this, "magType", _descriptor2, this);

      _initializerDefineProperty(this, "contributor", _descriptor3, this);
    }

    get magFormatted() {
      return this.get('value').toFixed(2);
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "value", [_dec], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, "magType", [_dec2], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor3 = _applyDecoratedDescriptor(_class.prototype, "contributor", [_dec3], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  })), _class));
  _exports.default = MagnitudeModel;
});
;define("sodstatus/models/measurement-tool", ["exports", "@ember-data/model"], function (_exports, _model) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _dec, _dec2, _dec3, _dec4, _class, _descriptor, _descriptor2, _descriptor3, _descriptor4, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  let MeasurementToolModel = (_dec = (0, _model.attr)('string'), _dec2 = (0, _model.attr)('string'), _dec3 = (0, _model.attr)(), _dec4 = (0, _model.belongsTo)('perusal'), (_class = (_temp = class MeasurementToolModel extends _model.default {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "toolType", _descriptor, this);

      _initializerDefineProperty(this, "name", _descriptor2, this);

      _initializerDefineProperty(this, "toolConfig", _descriptor3, this);

      _initializerDefineProperty(this, "perusal", _descriptor4, this);
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "toolType", [_dec], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, "name", [_dec2], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor3 = _applyDecoratedDescriptor(_class.prototype, "toolConfig", [_dec3], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor4 = _applyDecoratedDescriptor(_class.prototype, "perusal", [_dec4], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  })), _class));
  _exports.default = MeasurementToolModel;
});
;define("sodstatus/models/measurement", ["exports", "@ember-data/model"], function (_exports, _model) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _dec, _dec2, _dec3, _dec4, _class, _descriptor, _descriptor2, _descriptor3, _descriptor4, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  let MeasurementModel = (_dec = (0, _model.attr)('string'), _dec2 = (0, _model.belongsTo)('quake-station'), _dec3 = (0, _model.belongsTo)('perusal'), _dec4 = (0, _model.attr)(), (_class = (_temp = class MeasurementModel extends _model.default {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "name", _descriptor, this);

      _initializerDefineProperty(this, "quakeStation", _descriptor2, this);

      _initializerDefineProperty(this, "perusal", _descriptor3, this);

      _initializerDefineProperty(this, "value", _descriptor4, this);
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "name", [_dec], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, "quakeStation", [_dec2], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor3 = _applyDecoratedDescriptor(_class.prototype, "perusal", [_dec3], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor4 = _applyDecoratedDescriptor(_class.prototype, "value", [_dec4], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  })), _class));
  _exports.default = MeasurementModel;
});
;define("sodstatus/models/network", ["exports", "@ember-data/model"], function (_exports, _model) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _dec, _dec2, _dec3, _class, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  let NetworkModel = (_dec = (0, _model.attr)('date'), _dec2 = (0, _model.attr)('date'), _dec3 = (0, _model.hasMany)('station', {
    async: true
  }), (_class = (_temp = class NetworkModel extends _model.default {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "networkCode", _descriptor, this);

      _initializerDefineProperty(this, "startTime", _descriptor2, this);

      _initializerDefineProperty(this, "endTime", _descriptor3, this);

      _initializerDefineProperty(this, "description", _descriptor4, this);

      _initializerDefineProperty(this, "stations", _descriptor5, this);
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "networkCode", [_model.attr], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, "startTime", [_dec], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor3 = _applyDecoratedDescriptor(_class.prototype, "endTime", [_dec2], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor4 = _applyDecoratedDescriptor(_class.prototype, "description", [_model.attr], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor5 = _applyDecoratedDescriptor(_class.prototype, "stations", [_dec3], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  })), _class));
  _exports.default = NetworkModel;
});
;define("sodstatus/models/origin", ["exports", "@ember-data/model"], function (_exports, _model) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _class, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  let OriginModel = (_dec = (0, _model.belongsTo)('quake', {
    inverse: 'prefOrigin'
  }), _dec2 = (0, _model.attr)('date'), _dec3 = (0, _model.attr)('number'), _dec4 = (0, _model.attr)('number'), _dec5 = (0, _model.attr)('number'), _dec6 = (0, _model.attr)('number'), _dec7 = (0, _model.attr)('string'), _dec8 = (0, _model.attr)('string'), (_class = (_temp = class OriginModel extends _model.default {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "quake", _descriptor, this);

      _initializerDefineProperty(this, "time", _descriptor2, this);

      _initializerDefineProperty(this, "latitude", _descriptor3, this);

      _initializerDefineProperty(this, "longitude", _descriptor4, this);

      _initializerDefineProperty(this, "depth", _descriptor5, this);

      _initializerDefineProperty(this, "elevation", _descriptor6, this);

      _initializerDefineProperty(this, "catalog", _descriptor7, this);

      _initializerDefineProperty(this, "contributor", _descriptor8, this);
    }

    get latitudeFormatted() {
      return this.latitude.toFixed(2);
    }

    get longitudeFormatted() {
      return this.longitude.toFixed(2);
    }

    get depthFormatted() {
      return this.depth.toFixed(2);
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "quake", [_dec], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, "time", [_dec2], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor3 = _applyDecoratedDescriptor(_class.prototype, "latitude", [_dec3], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor4 = _applyDecoratedDescriptor(_class.prototype, "longitude", [_dec4], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor5 = _applyDecoratedDescriptor(_class.prototype, "depth", [_dec5], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor6 = _applyDecoratedDescriptor(_class.prototype, "elevation", [_dec6], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor7 = _applyDecoratedDescriptor(_class.prototype, "catalog", [_dec7], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor8 = _applyDecoratedDescriptor(_class.prototype, "contributor", [_dec8], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  })), _class));
  _exports.default = OriginModel;
});
;define("sodstatus/models/perusal", ["exports", "@ember-data/model"], function (_exports, _model) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _dec9, _dec10, _class, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _descriptor9, _descriptor10, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  let PerusalModel = (_dec = (0, _model.attr)('string'), _dec2 = (0, _model.attr)('string'), _dec3 = (0, _model.attr)('string'), _dec4 = (0, _model.attr)('string'), _dec5 = (0, _model.attr)('string'), _dec6 = (0, _model.belongsTo)('quake-station', {
    async: true
  }), _dec7 = (0, _model.belongsTo)('quake-station', {
    async: true
  }), _dec8 = (0, _model.belongsTo)('quake-station'), _dec9 = (0, _model.belongsTo)('quake-station', {
    async: true
  }), _dec10 = (0, _model.hasMany)('measurement-tool'), (_class = (_temp = class PerusalModel extends _model.default {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "name", _descriptor, this);

      _initializerDefineProperty(this, "username", _descriptor2, this);

      _initializerDefineProperty(this, "primarySort", _descriptor3, this);

      _initializerDefineProperty(this, "eventSort", _descriptor4, this);

      _initializerDefineProperty(this, "stationSort", _descriptor5, this);

      _initializerDefineProperty(this, "first", _descriptor6, this);

      _initializerDefineProperty(this, "prev", _descriptor7, this);

      _initializerDefineProperty(this, "curr", _descriptor8, this);

      _initializerDefineProperty(this, "next", _descriptor9, this);

      _initializerDefineProperty(this, "tools", _descriptor10, this);
    }

    goToFirst() {
      const mythis = this;
      return this.hashQuakeStation(this.get('first')).then(() => {
        let f = this.get('first');
        this.setProperties({
          'prev': null,
          'curr': f,
          'next': null
        });
      }).then(() => mythis.save());
    }

    goToPrev() {
      const mythis = this;
      return this.hashQuakeStation(this.get('prev')).then(() => {
        let n = this.get('prev');
        let c = this.get('curr');
        this.setProperties({
          'next': c,
          'curr': n,
          'prev': null
        });
      }).then(() => mythis.save()).then(() => console.log(`after goToPrev ${mythis.prev}`));
    }

    goToNext() {
      const mythis = this;
      return this.hashQuakeStation(this.get('next')).then(() => {
        let n = this.get('next');
        let c = this.get('curr');
        this.setProperties({
          'prev': c,
          'curr': n,
          'next': null
        });
      }).then(() => mythis.save());
    }

    doSave() {
      console.log("doSave");
      this.save();
    }

    delete() {
      this.store.deleteRecord(this);
    }

    hashQuakeStation(qs) {
      let perusalThis = this;

      if (qs) {
        // kind of dumb, but sometimes qs is a promise and sometimes not
        if (qs.then) {
          return qs.then(r => {
            if (r) return perusalThis.hashQuakeStation(r);
            return r;
          });
        }

        return Ember.RSVP.hash({
          qs: qs,
          staHash: qs.get('station').then(s => s.get('latitude')),
          netHash: qs.get('station').get('network'),
          quakeHash: qs.get('quake').then(function (q) {
            return q.get('prefOrigin');
          }).then(function (o) {
            return o.get('latitude');
          }).then(l => console.log("Got latitude: " + l)),
          qvHash: qs.get('ecps'),
          measurementHas: qs.get('measurements'),
          measurementAllHas: Ember.RSVP.all(Array.from(qs.get('measurements')))
        }).then(hash => hash.qs).then(qs => {
          console.log(`hashQuakeStation ${qs}  ${qs.measurements}`);
          return qs;
        });
      } else {
        console.assert(false, "perusal.hashQuakeStation: ERROR qs is null!!!");
        return null;
      }
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "name", [_dec], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, "username", [_dec2], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor3 = _applyDecoratedDescriptor(_class.prototype, "primarySort", [_dec3], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor4 = _applyDecoratedDescriptor(_class.prototype, "eventSort", [_dec4], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor5 = _applyDecoratedDescriptor(_class.prototype, "stationSort", [_dec5], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor6 = _applyDecoratedDescriptor(_class.prototype, "first", [_dec6], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor7 = _applyDecoratedDescriptor(_class.prototype, "prev", [_dec7], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor8 = _applyDecoratedDescriptor(_class.prototype, "curr", [_dec8], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor9 = _applyDecoratedDescriptor(_class.prototype, "next", [_dec9], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor10 = _applyDecoratedDescriptor(_class.prototype, "tools", [_dec10], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _applyDecoratedDescriptor(_class.prototype, "goToFirst", [Ember._action], Object.getOwnPropertyDescriptor(_class.prototype, "goToFirst"), _class.prototype), _applyDecoratedDescriptor(_class.prototype, "goToPrev", [Ember._action], Object.getOwnPropertyDescriptor(_class.prototype, "goToPrev"), _class.prototype), _applyDecoratedDescriptor(_class.prototype, "goToNext", [Ember._action], Object.getOwnPropertyDescriptor(_class.prototype, "goToNext"), _class.prototype), _applyDecoratedDescriptor(_class.prototype, "doSave", [Ember._action], Object.getOwnPropertyDescriptor(_class.prototype, "doSave"), _class.prototype), _applyDecoratedDescriptor(_class.prototype, "delete", [Ember._action], Object.getOwnPropertyDescriptor(_class.prototype, "delete"), _class.prototype)), _class));
  _exports.default = PerusalModel;
});
;define("sodstatus/models/quake-station", ["exports", "@ember-data/model", "seisplotjs"], function (_exports, _model, _seisplotjs) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _class, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  let QuakeStationModel = (_dec = (0, _model.attr)('string'), _dec2 = (0, _model.attr)('number'), _dec3 = (0, _model.attr)('number'), _dec4 = (0, _model.attr)('number'), _dec5 = (0, _model.belongsTo)('quake'), _dec6 = (0, _model.belongsTo)('station'), _dec7 = (0, _model.hasMany)('quake-vector'), _dec8 = (0, _model.hasMany)('measurement'), (_class = (_temp = class QuakeStationModel extends _model.default {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "sodStatus", _descriptor, this);

      _initializerDefineProperty(this, "distdeg", _descriptor2, this);

      _initializerDefineProperty(this, "azimuth", _descriptor3, this);

      _initializerDefineProperty(this, "backazimuth", _descriptor4, this);

      _initializerDefineProperty(this, "quake", _descriptor5, this);

      _initializerDefineProperty(this, "station", _descriptor6, this);

      _initializerDefineProperty(this, "ecps", _descriptor7, this);

      _initializerDefineProperty(this, "measurements", _descriptor8, this);
    }

    get sortedQuakeVectors() {
      console.log("in sortedQuakeVectors");

      if (this.ecps) {
        //return this.ecps.sortBy('channels');
        const sortedQV = this.ecps.toArray();
        sortedQV.sort((a, b) => {
          const aName = a.channels.firstObject.locCode + "." + a.channels.firstObject.channelCode;
          const bName = b.channels.firstObject.locCode + "." + b.channels.firstObject.channelCode;

          if (aName < bName) {
            return -1;
          }

          if (aName > bName) {
            return 1;
          }

          return 0;
        });
        return Ember.ArrayProxy.create({
          content: Ember.A(sortedQV)
        });
      } else {
        return [];
      }
    }

    get distDegFormatted() {
      if (this.distdeg) {
        return this.distdeg.toFixed(2);
      } else {
        return "UNDEF";
      }
    }

    get distKmFormatted() {
      if (this.distdeg) {
        return _seisplotjs.distaz.degtokm(this.distdeg).toFixed(2);
      } else {
        return "UNDEF";
      }
    }

    get azimuthFormatted() {
      if (this.azimuth) {
        return this.azimuth.toFixed(2);
      } else {
        return "UNDEF";
      }
    }

    get backazimuthFormatted() {
      if (this.backazimuth) {
        return this.backazimuth.toFixed(2);
      } else {
        return "UNDEF";
      }
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "sodStatus", [_dec], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, "distdeg", [_dec2], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor3 = _applyDecoratedDescriptor(_class.prototype, "azimuth", [_dec3], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor4 = _applyDecoratedDescriptor(_class.prototype, "backazimuth", [_dec4], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor5 = _applyDecoratedDescriptor(_class.prototype, "quake", [_dec5], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor6 = _applyDecoratedDescriptor(_class.prototype, "station", [_dec6], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor7 = _applyDecoratedDescriptor(_class.prototype, "ecps", [_dec7], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor8 = _applyDecoratedDescriptor(_class.prototype, "measurements", [_dec8], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  })), _class));
  _exports.default = QuakeStationModel;
});
;define("sodstatus/models/quake-vector", ["exports", "@ember-data/model"], function (_exports, _model) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _class, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  let QuakeVectorModel = (_dec = (0, _model.attr)('string'), _dec2 = (0, _model.attr)('number'), _dec3 = (0, _model.attr)('number'), _dec4 = (0, _model.attr)('number'), _dec5 = (0, _model.belongsTo)('quake'), _dec6 = (0, _model.hasMany)('channel'), _dec7 = (0, _model.attr)(), _dec8 = (0, _model.hasMany)('waveform'), (_class = (_temp = class QuakeVectorModel extends _model.default {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "sodStatus", _descriptor, this);

      _initializerDefineProperty(this, "distdeg", _descriptor2, this);

      _initializerDefineProperty(this, "azimuth", _descriptor3, this);

      _initializerDefineProperty(this, "backazimuth", _descriptor4, this);

      _initializerDefineProperty(this, "quake", _descriptor5, this);

      _initializerDefineProperty(this, "channels", _descriptor6, this);

      _initializerDefineProperty(this, "measurements", _descriptor7, this);

      _initializerDefineProperty(this, "waveforms", _descriptor8, this);
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "sodStatus", [_dec], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, "distdeg", [_dec2], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor3 = _applyDecoratedDescriptor(_class.prototype, "azimuth", [_dec3], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor4 = _applyDecoratedDescriptor(_class.prototype, "backazimuth", [_dec4], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor5 = _applyDecoratedDescriptor(_class.prototype, "quake", [_dec5], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor6 = _applyDecoratedDescriptor(_class.prototype, "channels", [_dec6], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor7 = _applyDecoratedDescriptor(_class.prototype, "measurements", [_dec7], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor8 = _applyDecoratedDescriptor(_class.prototype, "waveforms", [_dec8], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  })), _class));
  _exports.default = QuakeVectorModel;
});
;define("sodstatus/models/quake", ["exports", "@ember-data/model"], function (_exports, _model) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _class, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  let QuakeModel = (_dec = (0, _model.attr)('string'), _dec2 = (0, _model.attr)('string'), _dec3 = (0, _model.attr)('number'), _dec4 = (0, _model.belongsTo)('magnitude'), _dec5 = (0, _model.belongsTo)('origin'), _dec6 = (0, _model.hasMany)('quakeStation', {
    async: true
  }), (_class = (_temp = class QuakeModel extends _model.default {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "name", _descriptor, this);

      _initializerDefineProperty(this, "sodStatus", _descriptor2, this);

      _initializerDefineProperty(this, "numSuccessfulStations", _descriptor3, this);

      _initializerDefineProperty(this, "prefMagnitude", _descriptor4, this);

      _initializerDefineProperty(this, "prefOrigin", _descriptor5, this);

      _initializerDefineProperty(this, "quakeStationPairs", _descriptor6, this);
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "name", [_dec], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, "sodStatus", [_dec2], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor3 = _applyDecoratedDescriptor(_class.prototype, "numSuccessfulStations", [_dec3], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor4 = _applyDecoratedDescriptor(_class.prototype, "prefMagnitude", [_dec4], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor5 = _applyDecoratedDescriptor(_class.prototype, "prefOrigin", [_dec5], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor6 = _applyDecoratedDescriptor(_class.prototype, "quakeStationPairs", [_dec6], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  })), _class));
  _exports.default = QuakeModel;
});
;define("sodstatus/models/sod-config", ["exports", "@ember-data/model"], function (_exports, _model) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _dec, _dec2, _class, _descriptor, _descriptor2, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  let SodConfigModel = (_dec = (0, _model.attr)('date'), _dec2 = (0, _model.attr)('string'), (_class = (_temp = class SodConfigModel extends _model.default {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "timestamp", _descriptor, this);

      _initializerDefineProperty(this, "config", _descriptor2, this);
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "timestamp", [_dec], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, "config", [_dec2], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  })), _class));
  _exports.default = SodConfigModel;
});
;define("sodstatus/models/station", ["exports", "@ember-data/model"], function (_exports, _model) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _dec9, _class, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _descriptor9, _descriptor10, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  let StationModel = (_dec = (0, _model.attr)('string'), _dec2 = (0, _model.attr)('date'), _dec3 = (0, _model.attr)('date'), _dec4 = (0, _model.belongsTo)('network', {
    async: true
  }), _dec5 = (0, _model.hasMany)('channel', {
    async: true
  }), _dec6 = (0, _model.hasMany)('quakeStation', {
    async: true
  }), _dec7 = (0, _model.attr)('number'), _dec8 = (0, _model.attr)('number'), _dec9 = (0, _model.attr)('number'), (_class = (_temp = class StationModel extends _model.default {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "stationCode", _descriptor, this);

      _initializerDefineProperty(this, "startTime", _descriptor2, this);

      _initializerDefineProperty(this, "endTime", _descriptor3, this);

      _initializerDefineProperty(this, "site", _descriptor4, this);

      _initializerDefineProperty(this, "network", _descriptor5, this);

      _initializerDefineProperty(this, "channels", _descriptor6, this);

      _initializerDefineProperty(this, "quakeStationPairs", _descriptor7, this);

      _initializerDefineProperty(this, "latitude", _descriptor8, this);

      _initializerDefineProperty(this, "longitude", _descriptor9, this);

      _initializerDefineProperty(this, "elevation", _descriptor10, this);
    }

    get latitudeFormatted() {
      if (this.latitude) {
        return this.latitude.toFixed(2);
      } else {
        return "UNDEF";
      }
    }

    get longitudeFormatted() {
      if (this.longitude) {
        return this.longitude.toFixed(2);
      } else {
        return "UNDEF";
      }
    }

    get elevationFormatted() {
      if (this.longitude) {
        return this.elevation.toFixed(2);
      } else {
        return "UNDEF";
      }
    }

    get codes() {
      let nc = "UNDEF";
      let sc = "UNDEF";

      if (this.network) {
        nc = this.network.get('networkCode');
      }

      if (this.stationCode) {
        sc = this.stationCode;
      }

      return nc + "." + sc;
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "stationCode", [_dec], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, "startTime", [_dec2], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor3 = _applyDecoratedDescriptor(_class.prototype, "endTime", [_dec3], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor4 = _applyDecoratedDescriptor(_class.prototype, "site", [_model.attr], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor5 = _applyDecoratedDescriptor(_class.prototype, "network", [_dec4], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor6 = _applyDecoratedDescriptor(_class.prototype, "channels", [_dec5], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor7 = _applyDecoratedDescriptor(_class.prototype, "quakeStationPairs", [_dec6], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor8 = _applyDecoratedDescriptor(_class.prototype, "latitude", [_dec7], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor9 = _applyDecoratedDescriptor(_class.prototype, "longitude", [_dec8], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor10 = _applyDecoratedDescriptor(_class.prototype, "elevation", [_dec9], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  })), _class));
  _exports.default = StationModel;
});
;define("sodstatus/models/waveform", ["exports", "@ember-data/model", "seisplotjs"], function (_exports, _model, seisplotjs) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _dec9, _dec10, _dec11, _class, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _descriptor9, _descriptor10, _descriptor11, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  let WaveformModel = (_dec = (0, _model.attr)('string'), _dec2 = (0, _model.attr)('string'), _dec3 = (0, _model.attr)('string'), _dec4 = (0, _model.attr)('string'), _dec5 = (0, _model.attr)('date'), _dec6 = (0, _model.attr)('date'), _dec7 = (0, _model.attr)('string'), _dec8 = (0, _model.attr)('string'), _dec9 = (0, _model.attr)('string'), _dec10 = (0, _model.belongsTo)('quake'), _dec11 = (0, _model.belongsTo)('channel'), (_class = (_temp = class WaveformModel extends _model.default {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "networkCode", _descriptor, this);

      _initializerDefineProperty(this, "stationCode", _descriptor2, this);

      _initializerDefineProperty(this, "locCode", _descriptor3, this);

      _initializerDefineProperty(this, "channelCode", _descriptor4, this);

      _initializerDefineProperty(this, "startTime", _descriptor5, this);

      _initializerDefineProperty(this, "endTime", _descriptor6, this);

      _initializerDefineProperty(this, "filePath", _descriptor7, this);

      _initializerDefineProperty(this, "fileType", _descriptor8, this);

      _initializerDefineProperty(this, "dataUrl", _descriptor9, this);

      _initializerDefineProperty(this, "quake", _descriptor10, this);

      _initializerDefineProperty(this, "channel", _descriptor11, this);
    }

    loadWaveform() {
      const fetchInit = seisplotjs.util.defaultFetchInitObj(seisplotjs.miniseed.MINISEED_MIME);
      console.log(`fetch waveform: ${this.dataUrl}`);
      return seisplotjs.util.doFetchWithTimeout(this.dataUrl, fetchInit, 10).then(response => {
        if (response.status === 204) {
          // no data
          return new ArrayBuffer(0);
        } else {
          return response.arrayBuffer();
        }
      }).then(rawBuffer => {
        let dataRecords = seisplotjs.miniseed.parseDataRecords(rawBuffer);
        let seisPerChan = seisplotjs.miniseed.seismogramPerChannel(dataRecords);
        console.log(`Got ${seisPerChan.length} seismograms`);
        return seisPerChan[0];
      });
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "networkCode", [_dec], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, "stationCode", [_dec2], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor3 = _applyDecoratedDescriptor(_class.prototype, "locCode", [_dec3], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor4 = _applyDecoratedDescriptor(_class.prototype, "channelCode", [_dec4], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor5 = _applyDecoratedDescriptor(_class.prototype, "startTime", [_dec5], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor6 = _applyDecoratedDescriptor(_class.prototype, "endTime", [_dec6], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor7 = _applyDecoratedDescriptor(_class.prototype, "filePath", [_dec7], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor8 = _applyDecoratedDescriptor(_class.prototype, "fileType", [_dec8], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor9 = _applyDecoratedDescriptor(_class.prototype, "dataUrl", [_dec9], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor10 = _applyDecoratedDescriptor(_class.prototype, "quake", [_dec10], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  }), _descriptor11 = _applyDecoratedDescriptor(_class.prototype, "channel", [_dec11], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  })), _class));
  _exports.default = WaveformModel;
});
;define("sodstatus/modifiers/did-insert", ["exports", "@ember/render-modifiers/modifiers/did-insert"], function (_exports, _didInsert) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _didInsert.default;
    }
  });
});
;define("sodstatus/modifiers/did-update", ["exports", "@ember/render-modifiers/modifiers/did-update"], function (_exports, _didUpdate) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _didUpdate.default;
    }
  });
});
;define("sodstatus/modifiers/will-destroy", ["exports", "@ember/render-modifiers/modifiers/will-destroy"], function (_exports, _willDestroy) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _willDestroy.default;
    }
  });
});
;define("sodstatus/router", ["exports", "sodstatus/config/environment"], function (_exports, _environment) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  class Router extends Ember.Router {
    constructor(...args) {
      super(...args);

      _defineProperty(this, "location", _environment.default.locationType);

      _defineProperty(this, "rootURL", _environment.default.rootURL);
    }

  }

  _exports.default = Router;
  Router.map(function () {
    this.route('recipe');
    this.route('networks', function () {
      this.route('network', {
        path: '/:network_id'
      }, function () {});
    });
    this.route('quakes', function () {
      this.route('quake', {
        path: '/:quake_id'
      }, function () {
        this.route('stations');
      });
    });
    this.route('stations', function () {
      this.route('station', {
        path: '/:station_id'
      }, function () {
        this.route('quakes');
      });
    });
    this.route('quake-stations', function () {
      this.route('quake-station', {
        path: '/:quake_station_id'
      });
    });
    this.route('arms');
    this.route('perusals', function () {
      this.route('perusal', {
        path: '/:perusal_id'
      });
      this.route('new');
    });
  });
});
;define("sodstatus/routes/arms", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  class ArmsRoute extends Ember.Route {
    model() {
      return this.store.findAll('arm');
    }

  }

  _exports.default = ArmsRoute;
});
;define("sodstatus/routes/networks", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  class NetworksRoute extends Ember.Route {
    model() {
      return this.store.findAll('network');
    }

  }

  _exports.default = NetworksRoute;
});
;define("sodstatus/routes/networks/network", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  class NetworksNetworkRoute extends Ember.Route {
    model(params) {
      return this.store.findRecord('network', params.network_id);
    }

  }

  _exports.default = NetworksNetworkRoute;
});
;define("sodstatus/routes/perusals", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  class PerusalsRoute extends Ember.Route {}

  _exports.default = PerusalsRoute;
});
;define("sodstatus/routes/perusals/index", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  class PerusalsIndexRoute extends Ember.Route {
    model() {
      return this.store.findAll('perusal');
    }

  }

  _exports.default = PerusalsIndexRoute;
});
;define("sodstatus/routes/perusals/new", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  class PerusalsNewRoute extends Ember.Route {
    model() {
      let p = this.store.createRecord('perusal', {
        name: 'perusal',
        username: 'defaultuser',
        eventSort: 'time',
        stationSort: 'alpha',
        primarySort: 'quake',
        first: null,
        prev: null,
        curr: null,
        next: null,
        tools: []
      });
      return p;
    }

  }

  _exports.default = PerusalsNewRoute;
});
;define("sodstatus/routes/perusals/perusal", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _class, _descriptor, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  let PerusalsPerusalRoute = (_class = (_temp = class PerusalsPerusalRoute extends Ember.Route {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "measurementInitializer", _descriptor, this);
    }

    model(params) {
      const peekModel = this.store.peekRecord('perusal', params.perusal_id);

      if (peekModel && !peekModel.name) {
        // assume only type/id loaded
        return peekModel.reload();
      }

      return this.store.findRecord('perusal', params.perusal_id, {
        reload: true
      }).then(p => {
        return Ember.RSVP.hash({
          model: p
        });
      }).then(hash => {
        const p = hash.model;
        return Ember.RSVP.hash({
          model: p,
          curr: p.get('curr')
        });
      }).then(hash => {
        return Ember.RSVP.hash({
          model: hash.model,
          quakeHash: hash.model.curr.get('quake'),
          stationHash: hash.model.curr.get('station'),
          waveHash: hash.model.curr.get('ecps')
        });
      }).then(hash => {
        return Ember.RSVP.hash({
          model: hash.model,
          currHash: hash.model.hashQuakeStation(hash.model.get('curr')),
          ecpsHash: hash.model.curr.get('ecps')
        });
      }).then(hash => {
        return Ember.RSVP.hash({
          model: hash.model,
          channelsHash: Ember.RSVP.all(Array.from(hash.model.curr.get('ecps')))
        });
      }).then(hash => {
        return Ember.RSVP.hash({
          model: hash.model,
          channelsHash: Ember.RSVP.all(Array.from(hash.model.curr.get('ecps').map(qv => qv.get('channels')))),
          waveHash: Ember.RSVP.all(Array.from(hash.model.curr.get('ecps').map(qv => qv.get('waveforms'))))
        });
      }).then(hash => {
        return Ember.RSVP.hash({
          model: hash.model,
          waveHash: hash.waveHash,
          waveHashHash: Ember.RSVP.all(Array.from(hash.model.curr.get('ecps').map(qv => qv.get('waveforms').get('dataUrl'))))
        });
      }).then(hash => {
        return hash.model;
      });
    }

    afterModel(model, transition) {
      const measurementInitializer = this.measurementInitializer;
      return Ember.RSVP.hash({
        model: model,
        currHash: model.hashQuakeStation(model.get('curr')),
        toolHash: Ember.RSVP.all(model.get('tools').getEach('name'))
      }).then(function (hash) {
        const curr = hash.model.get('curr');
        const tools = hash.model.get('tools');
        measurementInitializer.checkNeedCreate(tools, curr);
        return hash.model;
      });
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "measurementInitializer", [Ember.inject.service], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  })), _class);
  _exports.default = PerusalsPerusalRoute;
});
;define("sodstatus/routes/quake-stations", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  class QuakeStationsRoute extends Ember.Route {}

  _exports.default = QuakeStationsRoute;
});
;define("sodstatus/routes/quake-stations/quake-station", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  class QuakeStationsQuakeStationRoute extends Ember.Route {
    model(params) {
      return this.store.findRecord('quakeStation', params.quake_station_id).then(quakeStation => {
        return Ember.RSVP.hash({
          model: quakeStation,
          quakeHash: quakeStation.get('quake'),
          qvHash: Ember.RSVP.all(Array.from(quakeStation.get('ecps'))),
          stationHash: quakeStation.get('station')
        }).then(hash => {
          return Ember.RSVP.hash({
            model: hash.model,
            waveHash: Ember.RSVP.all(Array.from(hash.model.ecps.map(qv => qv.get('waveforms')))),
            chAll: Ember.RSVP.all(Array.from(hash.model.get('station').get('channels'))),
            networkHash: hash.model.get('station').get('network'),
            magHash: hash.model.get('quake').get('prefMagnitude'),
            originHash: hash.model.get('quake').get('prefOrigin')
          });
        }).then(hash => {
          return Ember.RSVP.hash({
            model: hash.model,
            waveHash: Ember.RSVP.all(Array.from(hash.model.ecps.map(qv => Ember.RSVP.all(Array.from(qv.get('waveforms'))))))
          });
        }).then(hash => hash.model);
      });
    }

  }

  _exports.default = QuakeStationsQuakeStationRoute;
});
;define("sodstatus/routes/quakes", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  class QuakesRoute extends Ember.Route {}

  _exports.default = QuakesRoute;
});
;define("sodstatus/routes/quakes/index", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  class QuakesIndexRoute extends Ember.Route {
    model() {
      return this.store.findAll('quake', {
        backgroundReload: true
      });
    }

  }

  _exports.default = QuakesIndexRoute;
});
;define("sodstatus/routes/quakes/quake", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  class QuakesQuakeRoute extends Ember.Route {
    model(params) {
      return this.store.findRecord('quake', params.quake_id);
    }

  }

  _exports.default = QuakesQuakeRoute;
});
;define("sodstatus/routes/quakes/quake/stations", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  class QuakesQuakeStationsRoute extends Ember.Route {
    model() {
      let parentModel = this.modelFor('quakes.quake');
      return Ember.RSVP.hash({
        model: parentModel,
        quakeStationPairHash: parentModel.get('quakeStationPairs')
      }).then(hash => {
        return Ember.RSVP.hash({
          model: hash.model,
          quakeStationPairHash: hash.quakeStationPairHash,
          stAll: Ember.RSVP.all(Array.from(hash.model.quakeStationPairs.map(q => q.station)))
        });
      }).then(hash => {
        return Ember.RSVP.hash({
          model: hash.model,
          quakeStationPairHash: hash.quakeStationPairHash,
          stAll: Ember.RSVP.all(Array.from(hash.model.quakeStationPairs.map(q => q.station))),
          netAll: Ember.RSVP.all(Array.from(hash.model.quakeStationPairs.map(q => q.station.get('network'))))
        });
      }).then(hash => {
        return Ember.RSVP.hash({
          model: hash.model,
          quakeStationPairHash: hash.quakeStationPairHash,
          stAll: Ember.RSVP.all(Array.from(hash.model.quakeStationPairs.map(q => q.station))),
          netAll: Ember.RSVP.all(Array.from(hash.model.quakeStationPairs.map(q => q.station.get('network').get('networkCode'))))
        });
      }).then(hash => hash.model);
    }

  }

  _exports.default = QuakesQuakeStationsRoute;
});
;define("sodstatus/routes/recipe", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  class RecipeRoute extends Ember.Route {
    model() {
      return this.store.queryRecord('sodConfig', {
        current: true
      });
    }

  }

  _exports.default = RecipeRoute;
});
;define("sodstatus/routes/stations", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  class StationsRoute extends Ember.Route {}

  _exports.default = StationsRoute;
});
;define("sodstatus/routes/stations/index", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  class StationsIndexRoute extends Ember.Route {}

  _exports.default = StationsIndexRoute;
});
;define("sodstatus/routes/stations/station", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  class StationsStationRoute extends Ember.Route {
    model(params) {
      return this.store.findRecord('station', params.station_id).then(station => {
        return Ember.RSVP.hash({
          network: station.network,
          station: station
        }).then(hash => hash.station);
      });
    }

  }

  _exports.default = StationsStationRoute;
});
;define("sodstatus/routes/stations/station/quakes", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  class StationsStationQuakesRoute extends Ember.Route {
    model() {
      let parentModel = this.modelFor('stations.station');
      return Ember.RSVP.hash({
        model: parentModel,
        quakeStationPairHash: parentModel.get('quakeStationPairs')
      }).then(hash => {
        return Ember.RSVP.hash({
          model: hash.model,
          quakeStationPairHash: hash.quakeStationPairHash,
          qspAll: Ember.RSVP.all(Array.from(hash.quakeStationPairHash))
        });
      }).then(hash => {
        return Ember.RSVP.hash({
          model: hash.model,
          quakeStationPairHash: hash.quakeStationPairHash,
          qspAll: Ember.RSVP.all(Array.from(hash.model.quakeStationPairs.map(q => q.quake)))
        });
      }).then(hash => {
        return hash.model;
      });
    }

  }

  _exports.default = StationsStationQuakesRoute;
});
;define("sodstatus/serializers/-default", ["exports", "@ember-data/serializer/json"], function (_exports, _json) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _json.default;
    }
  });
});
;define("sodstatus/serializers/-json-api", ["exports", "@ember-data/serializer/json-api"], function (_exports, _jsonApi) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _jsonApi.default;
    }
  });
});
;define("sodstatus/serializers/-rest", ["exports", "@ember-data/serializer/rest"], function (_exports, _rest) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _rest.default;
    }
  });
});
;define("sodstatus/serializers/application", ["exports", "@ember-data/serializer/json-api"], function (_exports, _jsonApi) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  class ApplicationSerializer extends _jsonApi.default {}

  _exports.default = ApplicationSerializer;
});
;define("sodstatus/serializers/perusal", ["exports", "sodstatus/serializers/application"], function (_exports, _application) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  class PerusalSerializer extends _application.default {
    constructor(...args) {
      super(...args);

      _defineProperty(this, "attrs", {
        tools: {
          serialize: true
        }
      });
    }

  }

  _exports.default = PerusalSerializer;
});
;define("sodstatus/services/ember-leaflet", ["exports", "ember-leaflet/services/ember-leaflet"], function (_exports, _emberLeaflet) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _emberLeaflet.default;
    }
  });
});
;define("sodstatus/services/liquid-fire-transitions", ["exports", "liquid-fire/transition-map"], function (_exports, _transitionMap) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  var _default = _transitionMap.default;
  _exports.default = _default;
});
;define("sodstatus/services/measurement-initializer", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _class, _descriptor, _temp;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  let MeasurementInitializerService = (_class = (_temp = class MeasurementInitializerService extends Ember.Service {
    constructor(...args) {
      super(...args);

      _initializerDefineProperty(this, "store", _descriptor, this);
    }

    checkNeedCreate(tools, quakeStation) {
      let out = false;

      if (!quakeStation) {
        throw new Error("quakeStation is null in MeasurementInitializerService");
      }

      tools.forEach(tool => {
        if (quakeStation.get('measurements').find(m => m.get('name') === tool.get('name')) === undefined) {
          this.createMeasurement(tool, quakeStation);
          out = true;
        }
      });
      return out;
    }

    createMeasurement(tool, quakeStation) {
      let measure = this.get('store').createRecord('measurement', {
        name: tool.get('name'),
        value: null
      });
      quakeStation.get('measurements').pushObject(measure);
      measure.set('quakeStation', quakeStation);
      return measure;
    }

  }, _temp), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "store", [Ember.inject.service], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: null
  })), _class);
  _exports.default = MeasurementInitializerService;
});
;define("sodstatus/services/moment", ["exports", "ember-moment/services/moment", "sodstatus/config/environment"], function (_exports, _moment, _environment) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  const {
    get
  } = Ember;

  var _default = _moment.default.extend({
    defaultFormat: get(_environment.default, 'moment.outputFormat')
  });

  _exports.default = _default;
});
;define("sodstatus/services/store", ["exports", "ember-data/store"], function (_exports, _store) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _store.default;
    }
  });
});
;define("sodstatus/templates/application", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.HTMLBars.template({
    "id": "amfWkyB3",
    "block": "{\"symbols\":[],\"statements\":[[0,\"\\n\"],[5,\"menu-bar\",[],[[],[]]],[0,\"\\n\\n\"],[1,[22,\"outlet\"],false],[0,\"\\n\"]],\"hasEval\":false}",
    "meta": {
      "moduleName": "sodstatus/templates/application.hbs"
    }
  });

  _exports.default = _default;
});
;define("sodstatus/templates/arms", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.HTMLBars.template({
    "id": "iVjjmlCe",
    "block": "{\"symbols\":[\"a\",\"@model\"],\"statements\":[[7,\"table\",true],[8],[0,\"\\n  \"],[7,\"thead\",true],[8],[0,\"\\n    \"],[7,\"th\",true],[8],[0,\"Arm\"],[9],[0,\"\\n    \"],[7,\"th\",true],[8],[0,\"Status\"],[9],[0,\"\\n  \"],[9],[0,\"\\n  \"],[7,\"tbody\",true],[8],[0,\"\\n\"],[4,\"each\",[[23,2,[]]],null,{\"statements\":[[0,\"      \"],[7,\"tr\",true],[8],[0,\"\\n        \"],[7,\"td\",true],[8],[1,[23,1,[\"name\"]],false],[9],[0,\"\\n        \"],[7,\"td\",true],[8],[4,\"if\",[[23,1,[\"isActive\"]]],null,{\"statements\":[[0,\"Running\"]],\"parameters\":[]},{\"statements\":[[0,\"Stopped\"]],\"parameters\":[]}],[9],[0,\"\\n      \"],[9],[0,\"\\n\"]],\"parameters\":[1]},null],[0,\"  \"],[9],[0,\"\\n\"],[9],[0,\"\\n\\n\"],[1,[22,\"outlet\"],false],[0,\"\\n\"]],\"hasEval\":false}",
    "meta": {
      "moduleName": "sodstatus/templates/arms.hbs"
    }
  });

  _exports.default = _default;
});
;define("sodstatus/templates/networks", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.HTMLBars.template({
    "id": "vYZjhvQ8",
    "block": "{\"symbols\":[],\"statements\":[[0,\"\\n\\n\\n\"],[1,[22,\"outlet\"],false],[0,\"\\n\"]],\"hasEval\":false}",
    "meta": {
      "moduleName": "sodstatus/templates/networks.hbs"
    }
  });

  _exports.default = _default;
});
;define("sodstatus/templates/networks/index", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.HTMLBars.template({
    "id": "TFc3h/nf",
    "block": "{\"symbols\":[\"network\",\"@model\"],\"statements\":[[0,\"\\n\"],[7,\"div\",true],[10,\"class\",\"networkList\"],[8],[0,\"\\n\"],[7,\"h1\",true],[8],[0,\"Networks\"],[9],[0,\"\\n\"],[7,\"ul\",true],[8],[0,\"\\n\"],[4,\"each\",[[23,2,[]]],null,{\"statements\":[[0,\"    \"],[7,\"li\",true],[8],[0,\"\\n      \"],[5,\"link-to\",[],[[\"@route\",\"@model\"],[\"networks.network\",[23,1,[\"id\"]]]],{\"statements\":[[0,\"\\n        \"],[1,[23,1,[\"networkCode\"]],false],[4,\"if\",[[23,1,[\"isTempNet\"]]],null,{\"statements\":[[0,\"(\"],[1,[23,1,[\"startTimeUTC\"]],false],[0,\")\"]],\"parameters\":[]},null],[0,\" - \"],[1,[23,1,[\"description\"]],false],[0,\"\\n      \"]],\"parameters\":[]}],[0,\"\\n    \"],[9],[0,\"\\n\"]],\"parameters\":[1]},null],[9],[0,\"\\n\"],[9],[0,\"\\n\"]],\"hasEval\":false}",
    "meta": {
      "moduleName": "sodstatus/templates/networks/index.hbs"
    }
  });

  _exports.default = _default;
});
;define("sodstatus/templates/networks/network", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.HTMLBars.template({
    "id": "m265iaC+",
    "block": "{\"symbols\":[],\"statements\":[[0,\"\\n\"],[1,[22,\"outlet\"],false],[0,\"\\n\"]],\"hasEval\":false}",
    "meta": {
      "moduleName": "sodstatus/templates/networks/network.hbs"
    }
  });

  _exports.default = _default;
});
;define("sodstatus/templates/networks/network/index", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.HTMLBars.template({
    "id": "+G9e1VaM",
    "block": "{\"symbols\":[\"@model\"],\"statements\":[[7,\"div\",true],[10,\"class\",\"network\"],[8],[0,\"\\n  \"],[7,\"h3\",true],[8],[0,\"Network\"],[9],[0,\"\\n\\n  \"],[5,\"show-hide\",[],[[\"@divTitle\"],[\"Info\"]],{\"statements\":[[0,\"\\n    \"],[7,\"div\",true],[10,\"class\",\"boxRow\"],[8],[0,\"\\n      \"],[7,\"ul\",true],[8],[0,\"\\n        \"],[7,\"li\",true],[8],[0,\"Code: \"],[1,[23,1,[\"networkCode\"]],false],[9],[0,\"\\n        \"],[7,\"li\",true],[8],[0,\"Desc: \"],[1,[23,1,[\"description\"]],false],[9],[0,\"\\n        \"],[7,\"li\",true],[8],[0,\"Time Epoch:\\n          \"],[1,[28,\"format-iso-date\",[[23,1,[\"startTime\"]]],[[\"format\"],[\"YYYY-MM-DD\"]]],false],[0,\"\\n          \"],[4,\"if\",[[23,1,[\"endTime\"]]],null,{\"statements\":[[0,\" to \"],[1,[28,\"format-iso-date\",[[23,1,[\"endTime\"]]],[[\"format\"],[\"YYYY-MM-DD\"]]],false],[0,\"\\n\"]],\"parameters\":[]},{\"statements\":[[0,\"          until…\\n\"]],\"parameters\":[]}],[0,\"        \"],[9],[0,\"\\n      \"],[9],[0,\"\\n    \"],[9],[0,\"\\n  \"]],\"parameters\":[]}],[0,\"\\n\"],[9],[0,\"\\n\\n\"],[5,\"show-hide\",[],[[\"@divTitle\"],[\"Map\"]],{\"statements\":[[0,\"\\n  \"],[7,\"div\",true],[10,\"class\",\"boxRow\"],[8],[0,\"\\n    \"],[5,\"quake-station-map\",[],[[\"@stations\"],[[23,1,[\"stations\"]]]]],[0,\"\\n  \"],[9],[0,\"\\n\"]],\"parameters\":[]}],[0,\"\\n\\n\\n\"],[7,\"div\",true],[10,\"class\",\"stationList\"],[8],[0,\"\\n  \"],[5,\"show-hide\",[],[[\"@divTitle\"],[\"List\"]],{\"statements\":[[0,\"\\n    \"],[7,\"div\",true],[8],[0,\"\\n      \"],[7,\"h3\",true],[8],[0,\"Stations\"],[9],[0,\"\\n      \"],[5,\"station-list\",[],[[\"@stations\"],[[23,1,[\"stations\"]]]]],[0,\"\\n    \"],[9],[0,\"\\n  \"]],\"parameters\":[]}],[0,\"\\n\"],[9],[0,\"\\n\"]],\"hasEval\":false}",
    "meta": {
      "moduleName": "sodstatus/templates/networks/network/index.hbs"
    }
  });

  _exports.default = _default;
});
;define("sodstatus/templates/perusals", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.HTMLBars.template({
    "id": "2YLUc54J",
    "block": "{\"symbols\":[],\"statements\":[[1,[22,\"outlet\"],false]],\"hasEval\":false}",
    "meta": {
      "moduleName": "sodstatus/templates/perusals.hbs"
    }
  });

  _exports.default = _default;
});
;define("sodstatus/templates/perusals/index", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.HTMLBars.template({
    "id": "oOiWbQ3v",
    "block": "{\"symbols\":[\"perusal\",\"@model\"],\"statements\":[[7,\"h1\",true],[8],[0,\"Perusals\"],[9],[0,\"\\n\\n\"],[7,\"ul\",true],[8],[0,\"\\n\"],[4,\"each\",[[23,2,[]]],null,{\"statements\":[[0,\"    \"],[7,\"li\",true],[8],[0,\"\\n      Name: \"],[5,\"link-to\",[],[[\"@route\",\"@model\"],[\"perusals.perusal\",[23,1,[\"id\"]]]],{\"statements\":[[1,[23,1,[\"name\"]],false]],\"parameters\":[]}],[0,\"\\n      ID: \"],[5,\"link-to\",[],[[\"@route\",\"@model\"],[\"perusals.perusal\",[23,1,[\"id\"]]]],{\"statements\":[[7,\"span\",true],[10,\"class\",\"small\"],[8],[1,[23,1,[\"id\"]],false],[9]],\"parameters\":[]}],[0,\"\\n    \"],[9],[0,\"\\n\"]],\"parameters\":[1]},null],[9],[0,\"\\n\\n\"],[5,\"link-to\",[],[[\"@route\"],[\"perusals.new\"]],{\"statements\":[[0,\"Create New Perusal\"]],\"parameters\":[]}],[0,\"\\n\\n\"],[1,[22,\"outlet\"],false],[0,\"\\n\"]],\"hasEval\":false}",
    "meta": {
      "moduleName": "sodstatus/templates/perusals/index.hbs"
    }
  });

  _exports.default = _default;
});
;define("sodstatus/templates/perusals/new", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.HTMLBars.template({
    "id": "jxS3snXw",
    "block": "{\"symbols\":[\"@model\"],\"statements\":[[7,\"h1\",true],[8],[0,\"Create a New Perusal\"],[9],[0,\"\\n\"],[5,\"perusals/edit-form\",[],[[\"@perusal\"],[[23,1,[]]]]],[0,\"\\n\"],[1,[22,\"outlet\"],false],[0,\"\\n\"]],\"hasEval\":false}",
    "meta": {
      "moduleName": "sodstatus/templates/perusals/new.hbs"
    }
  });

  _exports.default = _default;
});
;define("sodstatus/templates/perusals/perusal", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.HTMLBars.template({
    "id": "4HQMDnu+",
    "block": "{\"symbols\":[\"tool\",\"qv\",\"tool\",\"@model\"],\"statements\":[[0,\"\\n\\n\\n\"],[7,\"button\",false],[12,\"type\",\"button\"],[3,\"on\",[\"click\",[23,4,[\"goToFirst\"]]]],[8],[0,\"First\"],[9],[0,\"\\n\"],[7,\"button\",false],[12,\"type\",\"button\"],[3,\"on\",[\"click\",[23,4,[\"goToPrev\"]]]],[8],[0,\"Previous\"],[9],[0,\"\\n\"],[7,\"button\",false],[12,\"type\",\"button\"],[3,\"on\",[\"click\",[23,4,[\"doSave\"]]]],[8],[0,\"Save\"],[9],[0,\"\\n\"],[7,\"button\",false],[12,\"type\",\"button\"],[3,\"on\",[\"click\",[23,4,[\"goToNext\"]]]],[8],[0,\"Next\"],[9],[0,\"\\nPrev is \"],[5,\"perusals/quake-or-station-link\",[],[[\"@quakeStation\",\"@primarySort\",\"@current\"],[[23,4,[\"prev\"]],[23,4,[\"primarySort\"]],[23,4,[\"curr\"]]]]],[0,\"\\nCurr is \"],[5,\"perusals/quake-or-station-link\",[],[[\"@quakeStation\",\"@primarySort\",\"@current\"],[[23,4,[\"curr\"]],[23,4,[\"primarySort\"]],[23,4,[\"curr\"]]]]],[0,\"\\nNext is \"],[5,\"perusals/quake-or-station-link\",[],[[\"@quakeStation\",\"@primarySort\",\"@current\"],[[23,4,[\"next\"]],[23,4,[\"primarySort\"]],[23,4,[\"curr\"]]]]],[0,\"\\n\\n\"],[7,\"div\",true],[10,\"class\",\"small-map\"],[8],[0,\"\\n\"],[5,\"quake-station-map\",[],[[\"@quakes\",\"@stations\"],[[23,4,[\"curr\",\"quake\"]],[23,4,[\"curr\",\"station\"]]]]],[0,\"\\n\"],[9],[0,\"\\n\\n\\n\"],[7,\"h5\",true],[8],[0,\"Found \"],[1,[23,4,[\"tools\",\"length\"]],false],[0,\" tools:\"],[9],[0,\"\\n\"],[7,\"ul\",true],[8],[0,\"\\n\"],[4,\"each\",[[23,4,[\"tools\"]]],null,{\"statements\":[[0,\"  \"],[7,\"li\",true],[8],[0,\"\\n\"],[4,\"if\",[[23,3,[\"toolType\"]]],null,{\"statements\":[[0,\"    \"],[1,[28,\"component\",[[28,\"concat\",[\"measurements/\",[23,3,[\"toolType\"]]],null]],[[\"perusal\",\"tool\",\"curr\"],[[23,4,[]],[23,3,[]],[23,4,[\"curr\"]]]]],false],[0,\"\\n\"]],\"parameters\":[]},{\"statements\":[[0,\"    \"],[7,\"span\",true],[8],[0,\"Loading tool: \"],[1,[23,3,[\"name\"]],false],[0,\" \"],[1,[23,3,[\"toolType\"]],false],[9],[0,\"\\n\"]],\"parameters\":[]}],[0,\"  \"],[9],[0,\"\\n\"]],\"parameters\":[3]},null],[9],[0,\"\\n\\n\"],[7,\"h5\",true],[8],[0,\"Current:\"],[9],[0,\"\\n\"],[7,\"ul\",true],[8],[0,\"\\n\"],[7,\"li\",true],[8],[0,\"Perusal: \"],[1,[23,4,[\"name\"]],false],[0,\" \"],[7,\"span\",true],[10,\"class\",\"small\"],[8],[1,[23,4,[\"id\"]],false],[9],[9],[0,\"\\n\"],[7,\"li\",true],[8],[0,\"Quake: \"],[1,[23,4,[\"curr\",\"quake\",\"name\"]],false],[0,\" \"],[1,[28,\"format-iso-date\",[[23,4,[\"curr\",\"quake\",\"prefOrigin\",\"time\"]]],null],false],[0,\" (\"],[1,[28,\"format-number\",[[23,4,[\"curr\",\"quake\",\"prefOrigin\",\"latitude\"]]],null],false],[0,\", \"],[1,[28,\"format-number\",[[23,4,[\"curr\",\"quake\",\"prefOrigin\",\"longitude\"]]],null],false],[0,\")\"],[9],[0,\"\\n\"],[7,\"li\",true],[8],[0,\"Station: \"],[1,[23,4,[\"curr\",\"station\",\"codes\"]],false],[0,\" (\"],[1,[28,\"format-number\",[[23,4,[\"curr\",\"station\",\"latitude\"]]],null],false],[0,\", \"],[1,[28,\"format-number\",[[23,4,[\"curr\",\"station\",\"longitude\"]]],null],false],[0,\")\"],[9],[0,\"\\n\"],[7,\"li\",true],[8],[0,\"Num Ecps: \"],[1,[23,4,[\"curr\",\"ecps\",\"length\"]],false],[9],[0,\"\\n\"],[9],[0,\"\\n\\n  \"],[7,\"h3\",true],[8],[1,[23,4,[\"curr\",\"station\",\"codes\"]],false],[0,\" - \"],[1,[23,4,[\"curr\",\"quake\",\"name\"]],false],[0,\" \"],[1,[28,\"format-iso-date\",[[23,4,[\"curr\",\"quake\",\"prefOrigin\",\"time\"]]],null],false],[9],[0,\"\\n  \"],[7,\"div\",true],[10,\"class\",\"ecp\"],[8],[0,\"\\n\"],[4,\"each\",[[23,4,[\"curr\",\"sortedQuakeVectors\"]]],null,{\"statements\":[[0,\"      \"],[5,\"seismogram-display\",[],[[\"@isOverlay\",\"@quakeVector\"],[\"false\",[23,2,[]]]]],[0,\"\\n\"]],\"parameters\":[2]},null],[0,\"  \"],[9],[0,\"\\n\\n\"],[7,\"h3\",true],[8],[0,\"Debugging/extra below here:\"],[9],[0,\"\\n\\n\"],[5,\"link-to\",[],[[\"@route\"],[\"perusals\"]],{\"statements\":[[0,\"\\nAll Perusals\\n\"]],\"parameters\":[]}],[0,\"\\n\\n\"],[7,\"ul\",true],[8],[0,\"\\n  \"],[7,\"li\",true],[8],[0,\"ID: \"],[1,[23,4,[\"id\"]],false],[9],[0,\"\\n  \"],[7,\"li\",true],[8],[0,\"Name: \"],[1,[23,4,[\"name\"]],false],[9],[0,\"\\n  \"],[7,\"li\",true],[8],[0,\"User: \"],[1,[23,4,[\"username\"]],false],[9],[0,\"\\n  \"],[7,\"li\",true],[8],[0,\"Primary Sort: \"],[1,[23,4,[\"primarySort\"]],false],[9],[0,\"\\n  \"],[7,\"li\",true],[8],[0,\"Event Sort: \"],[1,[23,4,[\"eventSort\"]],false],[9],[0,\"\\n  \"],[7,\"li\",true],[8],[0,\"Station Sort: \"],[1,[23,4,[\"stationSort\"]],false],[9],[0,\"\\n  \"],[7,\"li\",true],[8],[0,\"Current Event: \"],[1,[28,\"format-iso-date\",[[23,4,[\"curr\",\"quake\",\"prefOrigin\",\"time\"]]],null],false],[0,\" \"],[1,[23,4,[\"curr\",\"quake\",\"name\"]],false],[9],[0,\"\\n  \"],[7,\"li\",true],[8],[0,\"Current Station: \"],[1,[23,4,[\"curr\",\"station\",\"codes\"]],false],[9],[0,\"\\n  \"],[7,\"li\",true],[8],[0,\"\\n    First: \"],[5,\"perusals/quake-or-station-link\",[],[[\"@quakeStation\",\"@primarySort\",\"@current\"],[[23,4,[\"first\"]],[23,4,[\"primarySort\"]],[23,4,[\"curr\"]]]]],[0,\"\\n  \"],[9],[0,\"\\n  \"],[7,\"li\",true],[8],[0,\"\\n    Prev: \"],[5,\"perusals/quake-or-station-link\",[],[[\"@quakeStation\",\"@primarySort\",\"@current\"],[[23,4,[\"prev\"]],[23,4,[\"primarySort\"]],[23,4,[\"curr\"]]]]],[0,\"\\n  \"],[9],[0,\"\\n  \"],[7,\"li\",true],[8],[0,\"\\n    Curr: \"],[5,\"perusals/quake-or-station-link\",[],[[\"@quakeStation\",\"@primarySort\",\"@current\"],[[23,4,[\"curr\"]],[23,4,[\"primarySort\"]],[23,4,[\"curr\"]]]]],[0,\"\\n  \"],[9],[0,\"\\n  \"],[7,\"li\",true],[8],[0,\"\\n    Next: \"],[5,\"perusals/quake-or-station-link\",[],[[\"@quakeStation\",\"@primarySort\",\"@current\"],[[23,4,[\"next\"]],[23,4,[\"primarySort\"]],[23,4,[\"curr\"]]]]],[0,\"\\n  \"],[9],[0,\"\\n  \"],[7,\"li\",true],[8],[0,\"Tools:\\n    \"],[7,\"ul\",true],[8],[0,\"\\n\"],[4,\"each\",[[23,4,[\"tools\"]]],null,{\"statements\":[[0,\"        \"],[7,\"li\",true],[8],[1,[23,1,[\"name\"]],false],[0,\" \"],[1,[23,1,[\"toolType\"]],false],[9],[0,\"\\n\"]],\"parameters\":[1]},null],[0,\"   \"],[9],[0,\"\\n  \"],[9],[0,\"\\n\"],[9],[0,\"\\n\"],[7,\"button\",false],[12,\"type\",\"button\"],[3,\"on\",[\"click\",[23,4,[\"delete\"]]]],[8],[0,\"Delete\"],[9],[0,\"\\n\\n\"],[1,[22,\"outlet\"],false],[0,\"\\n\"]],\"hasEval\":false}",
    "meta": {
      "moduleName": "sodstatus/templates/perusals/perusal.hbs"
    }
  });

  _exports.default = _default;
});
;define("sodstatus/templates/quake-stations", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.HTMLBars.template({
    "id": "2GAD0dTG",
    "block": "{\"symbols\":[],\"statements\":[[1,[22,\"outlet\"],false]],\"hasEval\":false}",
    "meta": {
      "moduleName": "sodstatus/templates/quake-stations.hbs"
    }
  });

  _exports.default = _default;
});
;define("sodstatus/templates/quake-stations/quake-station", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.HTMLBars.template({
    "id": "h99Wc+bQ",
    "block": "{\"symbols\":[\"qv\",\"@model\"],\"statements\":[[0,\"\\n\"],[7,\"h3\",true],[8],[0,\"Quake-Station Pair\"],[9],[0,\"\\n\\n\"],[5,\"show-hide\",[],[[\"@divTitle\"],[\"Map\"]],{\"statements\":[[0,\"\\n  \"],[7,\"div\",true],[10,\"class\",\"boxRow\"],[8],[0,\"\\n    \"],[5,\"quake-station-map\",[],[[\"@quakeStations\"],[[28,\"array\",[[23,2,[]]],null]]]],[0,\"\\n  \"],[9],[0,\"\\n\"]],\"parameters\":[]}],[0,\"\\n\"],[5,\"show-hide\",[],[[\"@divTitle\"],[\"Info\"]],{\"statements\":[[0,\"\\n  \"],[7,\"div\",true],[10,\"class\",\"boxRow\"],[8],[0,\"\\n    \"],[7,\"div\",true],[8],[0,\"\\n      \"],[7,\"h3\",true],[8],[0,\"Station: \"],[9],[0,\"\\n      \"],[5,\"station-info\",[],[[\"@station\"],[[23,2,[\"station\"]]]],{\"statements\":[[0,\"\\n      \"]],\"parameters\":[]}],[0,\"\\n    \"],[9],[0,\"\\n    \"],[7,\"div\",true],[8],[0,\"\\n      \"],[7,\"h3\",true],[8],[0,\"Quake: \"],[9],[0,\"\\n      \"],[5,\"quake-info\",[],[[\"@quake\"],[[23,2,[\"quake\"]]]]],[0,\"\\n    \"],[9],[0,\"\\n    \"],[7,\"div\",true],[8],[0,\"\\n      \"],[7,\"h3\",true],[8],[0,\"Quake-Station\"],[9],[0,\"\\n      \"],[5,\"quake-station-info\",[],[[\"@quakeStation\"],[[23,2,[]]]],{\"statements\":[],\"parameters\":[]}],[0,\"\\n    \"],[9],[0,\"\\n  \"],[9],[0,\"\\n\"]],\"parameters\":[]}],[0,\"\\n\\n\"],[5,\"show-hide\",[],[[\"@divTitle\"],[\"Seismograms\"]],{\"statements\":[[0,\"\\n\"],[4,\"each\",[[23,2,[\"ecps\"]]],null,{\"statements\":[[5,\"seismogram-display\",[],[[\"@quakeVector\"],[[23,1,[]]]],{\"statements\":[],\"parameters\":[]}],[0,\"\\n\"]],\"parameters\":[1]},null]],\"parameters\":[]}],[0,\"\\n\\n\"],[1,[22,\"outlet\"],false],[0,\"\\n\"]],\"hasEval\":false}",
    "meta": {
      "moduleName": "sodstatus/templates/quake-stations/quake-station.hbs"
    }
  });

  _exports.default = _default;
});
;define("sodstatus/templates/quakes", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.HTMLBars.template({
    "id": "4V7wrWmA",
    "block": "{\"symbols\":[],\"statements\":[[1,[22,\"outlet\"],false]],\"hasEval\":false}",
    "meta": {
      "moduleName": "sodstatus/templates/quakes.hbs"
    }
  });

  _exports.default = _default;
});
;define("sodstatus/templates/quakes/index", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.HTMLBars.template({
    "id": "QJeDQYk0",
    "block": "{\"symbols\":[\"@model\",\"@sortedQuakes\"],\"statements\":[[0,\"\\n\"],[7,\"div\",true],[10,\"class\",\"quakeList\"],[8],[0,\"\\n  \"],[7,\"h1\",true],[8],[0,\"Quakes\"],[9],[0,\"\\n  \"],[7,\"h5\",true],[8],[0,\"Found \"],[1,[23,1,[\"length\"]],false],[0,\" \"],[1,[23,2,[\"length\"]],false],[9],[0,\"\\n\\n  \"],[5,\"show-hide\",[],[[\"@divTitle\"],[\"Map\"]],{\"statements\":[[0,\"\\n    \"],[5,\"quake-station-map\",[],[[\"@quakes\"],[[23,1,[]]]]],[0,\"\\n  \"]],\"parameters\":[]}],[0,\"\\n  \"],[5,\"show-hide\",[],[[\"@divTitle\"],[\"List\"]],{\"statements\":[[0,\"\\n    \"],[5,\"quake-list\",[],[[\"@quakes\"],[[23,1,[]]]],{\"statements\":[],\"parameters\":[]}],[0,\"\\n  \"]],\"parameters\":[]}],[0,\"\\n\"],[9],[0,\"\\n\\n\"],[1,[22,\"outlet\"],false],[0,\"\\n\"]],\"hasEval\":false}",
    "meta": {
      "moduleName": "sodstatus/templates/quakes/index.hbs"
    }
  });

  _exports.default = _default;
});
;define("sodstatus/templates/quakes/quake", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.HTMLBars.template({
    "id": "3+wxKTLI",
    "block": "{\"symbols\":[\"@model\"],\"statements\":[[0,\"\\n\"],[7,\"h3\",true],[8],[0,\"Quake\"],[9],[0,\"\\n\\n\"],[7,\"div\",true],[10,\"class\",\"quake\"],[8],[0,\"\\n\\n\\n  \"],[5,\"show-hide\",[],[[\"@divTitle\"],[\"Info\"]],{\"statements\":[[0,\"\\n    \"],[5,\"quake-info\",[],[[\"@quake\"],[[23,1,[]]]]],[0,\"\\n  \"]],\"parameters\":[]}],[0,\"\\n\\n\\n  \"],[1,[22,\"outlet\"],false],[0,\"\\n\"],[9],[0,\"\\n\"]],\"hasEval\":false}",
    "meta": {
      "moduleName": "sodstatus/templates/quakes/quake.hbs"
    }
  });

  _exports.default = _default;
});
;define("sodstatus/templates/quakes/quake/index", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.HTMLBars.template({
    "id": "xBV1s/Rb",
    "block": "{\"symbols\":[\"@model\"],\"statements\":[[0,\"\\n  \"],[5,\"show-hide\",[],[[\"@divTitle\"],[\"Map\"]],{\"statements\":[[0,\"\\n    \"],[5,\"quake-station-map\",[],[[\"@quakes\"],[[28,\"array\",[[23,1,[]]],null]]]],[0,\"\\n  \"]],\"parameters\":[]}],[0,\"\\n\\n    \"],[5,\"link-to\",[],[[\"@route\",\"@model\"],[\"quakes.quake.stations\",[23,1,[\"id\"]]]],{\"statements\":[[0,\"Stations\"]],\"parameters\":[]}],[0,\"\\n\"]],\"hasEval\":false}",
    "meta": {
      "moduleName": "sodstatus/templates/quakes/quake/index.hbs"
    }
  });

  _exports.default = _default;
});
;define("sodstatus/templates/quakes/quake/stations", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.HTMLBars.template({
    "id": "XP4MHovR",
    "block": "{\"symbols\":[\"@model\"],\"statements\":[[0,\"\\n\\n  \"],[5,\"show-hide\",[],[[\"@divTitle\"],[\"Map\"]],{\"statements\":[[0,\"\\n    \"],[5,\"quake-station-map\",[],[[\"@quakes\",\"@quakeStations\"],[[28,\"array\",[[23,1,[]]],null],[23,1,[\"quakeStationPairs\"]]]]],[0,\"\\n  \"]],\"parameters\":[]}],[0,\"\\n\\n\"],[7,\"h3\",true],[8],[0,\"Quake-Station Pairs (\"],[1,[23,1,[\"quakeStationPairs\",\"length\"]],false],[0,\")\"],[9],[0,\"\\n\\n  \"],[5,\"show-hide\",[],[[\"@divTitle\"],[\"List\"]],{\"statements\":[[0,\"\\n    \"],[5,\"quake-stations-list\",[],[[\"@quakeStationPairs\"],[[23,1,[\"quakeStationPairs\"]]]],{\"statements\":[],\"parameters\":[]}],[0,\"\\n  \"]],\"parameters\":[]}],[0,\"\\n\\n\"],[1,[22,\"outlet\"],false],[0,\"\\n\"]],\"hasEval\":false}",
    "meta": {
      "moduleName": "sodstatus/templates/quakes/quake/stations.hbs"
    }
  });

  _exports.default = _default;
});
;define("sodstatus/templates/recipe", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.HTMLBars.template({
    "id": "+QQDRGrH",
    "block": "{\"symbols\":[\"@model\"],\"statements\":[[0,\"\\n\"],[7,\"p\",true],[8],[0,\"Timestamp: \"],[1,[28,\"format-iso-date\",[[23,1,[\"timestamp\"]]],null],false],[9],[0,\"\\n\\n\"],[7,\"h3\",true],[8],[0,\"Recipe\"],[9],[0,\"\\n\\n\"],[7,\"span\",true],[10,\"class\",\"download\"],[8],[7,\"a\",true],[10,\"href\",\"/api/sod-configs?current=true&format=xml\"],[10,\"download\",\"\"],[8],[0,\"Download\"],[9],[9],[0,\"\\n\"],[7,\"pre\",true],[8],[7,\"code\",true],[8],[0,\"\\n\"],[1,[28,\"format-xml\",[[23,1,[\"config\"]]],null],false],[0,\"\\n\"],[9],[9],[0,\"\\n\\n\"],[1,[22,\"outlet\"],false],[0,\"\\n\"]],\"hasEval\":false}",
    "meta": {
      "moduleName": "sodstatus/templates/recipe.hbs"
    }
  });

  _exports.default = _default;
});
;define("sodstatus/templates/stations", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.HTMLBars.template({
    "id": "4d5G/xe/",
    "block": "{\"symbols\":[],\"statements\":[[1,[22,\"outlet\"],false]],\"hasEval\":false}",
    "meta": {
      "moduleName": "sodstatus/templates/stations.hbs"
    }
  });

  _exports.default = _default;
});
;define("sodstatus/templates/stations/index", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.HTMLBars.template({
    "id": "r3v4IhpJ",
    "block": "{\"symbols\":[],\"statements\":[[0,\"\\n\"],[7,\"h3\",true],[8],[0,\"Stations\"],[9],[0,\"\\n\\n\"],[7,\"p\",true],[8],[0,\"...list here...\"],[9],[0,\"\\n\\n\"],[1,[22,\"outlet\"],false],[0,\"\\n\"]],\"hasEval\":false}",
    "meta": {
      "moduleName": "sodstatus/templates/stations/index.hbs"
    }
  });

  _exports.default = _default;
});
;define("sodstatus/templates/stations/station", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.HTMLBars.template({
    "id": "zVAi7VJT",
    "block": "{\"symbols\":[],\"statements\":[[0,\"\\n\"],[7,\"h3\",true],[8],[0,\"Station\"],[9],[0,\"\\n\\n\"],[1,[22,\"outlet\"],false],[0,\"\\n\"]],\"hasEval\":false}",
    "meta": {
      "moduleName": "sodstatus/templates/stations/station.hbs"
    }
  });

  _exports.default = _default;
});
;define("sodstatus/templates/stations/station/index", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.HTMLBars.template({
    "id": "/MPhme7f",
    "block": "{\"symbols\":[\"@model\"],\"statements\":[[0,\"\\n  \"],[5,\"quake-station-map\",[],[[\"@stations\"],[[28,\"array\",[[23,1,[]]],null]]]],[0,\"\\n\\n\"],[5,\"station-info\",[],[[\"@station\"],[[23,1,[]]]],{\"statements\":[[0,\"\\n\"]],\"parameters\":[]}],[0,\"\\n\\n\"],[5,\"link-to\",[],[[\"@route\",\"@model\"],[\"stations.station.quakes\",[23,1,[\"id\"]]]],{\"statements\":[[0,\"Quakes\"]],\"parameters\":[]}],[0,\"\\n\"]],\"hasEval\":false}",
    "meta": {
      "moduleName": "sodstatus/templates/stations/station/index.hbs"
    }
  });

  _exports.default = _default;
});
;define("sodstatus/templates/stations/station/quakes", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;

  var _default = Ember.HTMLBars.template({
    "id": "0cQt6Bbh",
    "block": "{\"symbols\":[\"@model\"],\"statements\":[[0,\"\\n\\n\\n\"],[7,\"h3\",true],[8],[0,\"Station-Quakes (\"],[1,[23,1,[\"quakeStationPairs\",\"length\"]],false],[0,\")\"],[9],[0,\"\\n\\n\\n\"],[5,\"quake-station-map\",[],[[\"@stations\",\"@quakeStations\"],[[28,\"array\",[[23,1,[]]],null],[23,1,[\"quakeStationPairs\"]]]]],[0,\"\\n\\n\\n\"],[5,\"station-quakes-list\",[],[[\"@quakeStationPairs\"],[[23,1,[\"quakeStationPairs\"]]]],{\"statements\":[],\"parameters\":[]}],[0,\"\\n\\n\\n\"],[1,[22,\"outlet\"],false],[0,\"\\n\"]],\"hasEval\":false}",
    "meta": {
      "moduleName": "sodstatus/templates/stations/station/quakes.hbs"
    }
  });

  _exports.default = _default;
});
;define("sodstatus/transforms/boolean", ["exports", "@ember-data/serializer/-private"], function (_exports, _private) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _private.BooleanTransform;
    }
  });
});
;define("sodstatus/transforms/date", ["exports", "@ember-data/serializer/-private"], function (_exports, _private) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _private.DateTransform;
    }
  });
});
;define("sodstatus/transforms/number", ["exports", "@ember-data/serializer/-private"], function (_exports, _private) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _private.NumberTransform;
    }
  });
});
;define("sodstatus/transforms/string", ["exports", "@ember-data/serializer/-private"], function (_exports, _private) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _private.StringTransform;
    }
  });
});
;define("sodstatus/transitions", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = _default;

  function _default() {// Add your transitions here, like:
    //   this.transition(
    //     this.fromRoute('people.index'),
    //     this.toRoute('people.detail'),
    //     this.use('toLeft'),
    //     this.reverse('toRight')
    //   );
  }
});
;define("sodstatus/transitions/cross-fade", ["exports", "liquid-fire/transitions/cross-fade"], function (_exports, _crossFade) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _crossFade.default;
    }
  });
});
;define("sodstatus/transitions/default", ["exports", "liquid-fire/transitions/default"], function (_exports, _default) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _default.default;
    }
  });
});
;define("sodstatus/transitions/explode", ["exports", "liquid-fire/transitions/explode"], function (_exports, _explode) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _explode.default;
    }
  });
});
;define("sodstatus/transitions/fade", ["exports", "liquid-fire/transitions/fade"], function (_exports, _fade) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _fade.default;
    }
  });
});
;define("sodstatus/transitions/flex-grow", ["exports", "liquid-fire/transitions/flex-grow"], function (_exports, _flexGrow) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _flexGrow.default;
    }
  });
});
;define("sodstatus/transitions/fly-to", ["exports", "liquid-fire/transitions/fly-to"], function (_exports, _flyTo) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _flyTo.default;
    }
  });
});
;define("sodstatus/transitions/move-over", ["exports", "liquid-fire/transitions/move-over"], function (_exports, _moveOver) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _moveOver.default;
    }
  });
});
;define("sodstatus/transitions/scale", ["exports", "liquid-fire/transitions/scale"], function (_exports, _scale) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _scale.default;
    }
  });
});
;define("sodstatus/transitions/scroll-then", ["exports", "liquid-fire/transitions/scroll-then"], function (_exports, _scrollThen) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _scrollThen.default;
    }
  });
});
;define("sodstatus/transitions/to-down", ["exports", "liquid-fire/transitions/to-down"], function (_exports, _toDown) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _toDown.default;
    }
  });
});
;define("sodstatus/transitions/to-left", ["exports", "liquid-fire/transitions/to-left"], function (_exports, _toLeft) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _toLeft.default;
    }
  });
});
;define("sodstatus/transitions/to-right", ["exports", "liquid-fire/transitions/to-right"], function (_exports, _toRight) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _toRight.default;
    }
  });
});
;define("sodstatus/transitions/to-up", ["exports", "liquid-fire/transitions/to-up"], function (_exports, _toUp) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _toUp.default;
    }
  });
});
;define("sodstatus/transitions/wait", ["exports", "liquid-fire/transitions/wait"], function (_exports, _wait) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "default", {
    enumerable: true,
    get: function () {
      return _wait.default;
    }
  });
});
;

;define('sodstatus/config/environment', [], function() {
  var prefix = 'sodstatus';
try {
  var metaName = prefix + '/config/environment';
  var rawConfig = document.querySelector('meta[name="' + metaName + '"]').getAttribute('content');
  var config = JSON.parse(decodeURIComponent(rawConfig));

  var exports = { 'default': config };

  Object.defineProperty(exports, '__esModule', { value: true });

  return exports;
}
catch(err) {
  throw new Error('Could not read config from meta tag with name "' + metaName + '".');
}

});

;
          if (!runningTests) {
            require("sodstatus/app")["default"].create({"name":"sodstatus","version":"0.0.0+06f7e7d5"});
          }
        
//# sourceMappingURL=sodstatus.map
