/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web.jsonapi.stationxml;

import edu.sc.seis.seisFile.fdsnws.stationxml.BaseNodeType;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Equipment;
import edu.sc.seis.seisFile.fdsnws.stationxml.ExternalReference;
import edu.sc.seis.seisFile.fdsnws.stationxml.Operator;
import edu.sc.seis.seisFile.fdsnws.stationxml.Site;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.web.jsonapi.AbstractJsonApiData;
import edu.sc.seis.sod.web.jsonapi.JsonApi;
import edu.sc.seis.sod.web.jsonapi.JsonApiData;
import edu.sc.seis.sod.web.jsonapi.JsonApiResource;
import edu.sc.seis.sod.web.jsonapi.stationxml.ChannelJson;
import edu.sc.seis.sod.web.jsonapi.stationxml.EquipmentJson;
import edu.sc.seis.sod.web.jsonapi.stationxml.ExternalReferenceJson;
import edu.sc.seis.sod.web.jsonapi.stationxml.NetworkJson;
import edu.sc.seis.sod.web.jsonapi.stationxml.OperatorJson;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;

public class StationJson
extends AbstractJsonApiData {
    public static final String TYPE = "Station";
    Station sta;
    List<Channel> chanList;

    public static Station decode(JsonApiResource res) {
        Station sta = new Station();
        NetworkJson.decodeBaseNodeAttributes(res, (BaseNodeType)sta);
        sta.setLatitude(res.getAttributeDouble("Latitude").floatValue());
        sta.setLongitude(res.getAttributeDouble("Longitude").floatValue());
        sta.setElevation(res.getAttributeDouble("Elevation").floatValue());
        Object o = res.getAttribute("Site");
        if (o != null && o instanceof JSONObject) {
            JSONObject jo = (JSONObject)o;
            Site site = new Site(jo.getString("Name"), jo.getString("Description"), jo.getString("Town"), jo.getString("County"), jo.getString("Region"), jo.getString("Country"));
            sta.setSite(site);
        }
        sta.setWaterlevel(res.getAttributeDouble("WaterLevel").floatValue());
        sta.setVault(res.getAttributeString("Vault"));
        sta.setGeology(res.getAttributeString("Geology"));
        for (Object e : res.getAttributeArray("Equipment")) {
            if (!(e instanceof JSONObject)) continue;
            sta.appendEquipment(EquipmentJson.decode((JSONObject)e));
        }
        for (Object e : res.getAttributeArray("Operator")) {
            if (!(e instanceof JSONObject)) continue;
            sta.appendOperator(OperatorJson.decode((JSONObject)e));
        }
        for (Object e : res.getAttributeArray("ExternalReference")) {
            if (!(e instanceof JSONObject)) continue;
            sta.appendExternalReference(ExternalReferenceJson.decode((JSONObject)e));
        }
        return sta;
    }

    public StationJson(Station sta, String baseUrl) {
        this(sta, null, baseUrl);
    }

    public StationJson(Station sta, List<Channel> chanList, String baseUrl) {
        super(baseUrl);
        this.sta = sta;
        this.chanList = chanList;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getId() {
        return new NetworkJson(this.sta.getNetwork(), this.baseUrl).getId() + "_" + this.sta.getStationCode();
    }

    @Override
    public void encodeAttributes(JSONWriter out) throws JSONException {
        NetworkJson.encodeBaseNodeAttributes(out, (BaseNodeType)this.sta);
        out.key("Latitude").value((Object)this.sta.getLatitude()).key("Longitude").value((Object)this.sta.getLongitude()).key("Elevation").value((double)this.sta.getElevation().getValue());
        if (this.sta.getSite() != null) {
            out.key("Site").object();
            JsonApi.doKeyValue(out, "Name", this.sta.getSite().getName());
            JsonApi.doKeyValue(out, "Description", this.sta.getSite().getDescription());
            out.endObject();
        }
        JsonApi.doKeyValue(out, "WaterLevel", Float.valueOf(this.sta.getWaterlevel().getValue()));
        JsonApi.doKeyValue(out, "Value", this.sta.getVault());
        JsonApi.doKeyValue(out, "Geology", this.sta.getGeology());
        if (this.sta.getEquipmentList().size() != 0) {
            out.key("Equipment").array();
            for (Equipment c : this.sta.getEquipmentList()) {
                out.object();
                new EquipmentJson(c).encodeAttributes(out);
                out.endObject();
            }
            out.endArray();
        }
        if (this.sta.getOperatorList().size() != 0) {
            out.key("Operator").array();
            for (Equipment c : this.sta.getOperatorList()) {
                out.object();
                new OperatorJson((Operator)c).encodeAttributes(out);
                out.endObject();
            }
            out.endArray();
        }
        if (this.sta.getExternalReferenceList().size() != 0) {
            out.key("ExternalReference").array();
            for (Equipment c : this.sta.getExternalReferenceList()) {
                out.object();
                new ExternalReferenceJson((ExternalReference)c).encodeAttributes(out);
                out.endObject();
            }
            out.endArray();
        }
    }

    @Override
    public boolean hasRelationships() {
        return true;
    }

    @Override
    public void encodeRelationships(JSONWriter out) throws JSONException {
        out.key("Network").object();
        out.key("data").object();
        out.key("id").value((Object)new NetworkJson(this.sta.getNetwork(), this.baseUrl).getId());
        out.key("type").value((Object)"networks");
        out.endObject();
        out.endObject();
        out.key("quake-station-pairs").object().key("links").object().key("related").value((Object)this.formEventRelationshipURL(this.sta));
        out.endObject();
        out.endObject();
        out.key("channels").object();
        out.key("links").object();
        out.key("related").value((Object)this.formChannelRelationshipURL(this.sta));
        out.endObject();
        if (this.chanList.size() != 0) {
            out.key("data").array();
            for (Channel c : this.chanList) {
                out.object();
                ChannelJson cj = new ChannelJson(c, this.baseUrl);
                out.key("type").value((Object)cj.getType());
                out.key("id").value((Object)cj.getId());
                out.endObject();
            }
            out.endArray();
        }
        out.endObject();
    }

    @Override
    public boolean hasLinks() {
        return true;
    }

    @Override
    public void encodeLinks(JSONWriter out) throws JSONException {
        out.key("self").value((Object)this.formStationURL(this.sta));
    }

    public static List<JsonApiData> toJsonList(List<Station> staList, String baseUrl) {
        ArrayList<JsonApiData> out = new ArrayList<JsonApiData>(staList.size());
        for (Station stationImpl : staList) {
            out.add(new StationJson(stationImpl, baseUrl));
        }
        return out;
    }

    public String formStationURL(Station sta) {
        NetworkJson netJson = new NetworkJson(sta.getNetwork(), this.baseUrl);
        String out = this.baseUrl + "/networks/" + netJson.getId() + "/stations/" + this.getId();
        return out;
    }

    public String formEventRelationshipURL(Station sta) {
        String out = this.baseUrl + "/stations/" + this.getId() + "/quakes";
        return out;
    }

    public String formChannelRelationshipURL(Station sta) {
        String out = this.baseUrl + "/stations/" + this.getId() + "/channels";
        return out;
    }
}

