/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web.jsonapi.stationxml;

import edu.sc.seis.seisFile.fdsnws.stationxml.Person;
import edu.sc.seis.sod.web.jsonapi.ComplexAttributeJson;
import edu.sc.seis.sod.web.jsonapi.JsonApi;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;

public class PersonJson
implements ComplexAttributeJson {
    Person person;

    public static Person decode(JSONObject json) {
        Person p = new Person();
        p.setName(json.getString("Name"));
        if (json.optJSONArray("Agency") != null) {
            for (Object o : json.optJSONArray("Agency")) {
                p.appendAgency((String)o);
            }
        }
        if (json.optJSONArray("Phone") != null) {
            for (Object o : json.optJSONArray("Phone")) {
                p.appendPhone((String)o);
            }
        }
        if (json.optJSONArray("Email") != null) {
            for (Object o : json.optJSONArray("Email")) {
                p.appendEmail((String)o);
            }
        }
        return p;
    }

    public PersonJson(Person person) {
        this.person = person;
    }

    @Override
    public String getType() {
        return "person";
    }

    @Override
    public void encodeAttributes(JSONWriter out) throws JSONException {
        JsonApi.doKeyValue(out, "Name", this.person.getName());
        if (this.person.getAgencyList().size() != 0) {
            out.key("Agency").array();
            for (String s : this.person.getAgencyList()) {
                out.value((Object)s);
            }
            out.endArray();
        }
        if (this.person.getPhoneList().size() != 0) {
            out.key("Phone").array();
            for (String s : this.person.getPhoneList()) {
                out.value((Object)s);
            }
            out.endArray();
        }
        if (this.person.getEmailList().size() != 0) {
            out.key("Email").array();
            for (String s : this.person.getEmailList()) {
                out.value((Object)s);
            }
            out.endArray();
        }
    }
}

