/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web.jsonapi.stationxml;

import edu.sc.seis.seisFile.fdsnws.stationxml.Operator;
import edu.sc.seis.seisFile.fdsnws.stationxml.Person;
import edu.sc.seis.sod.web.jsonapi.ComplexAttributeJson;
import edu.sc.seis.sod.web.jsonapi.JsonApi;
import edu.sc.seis.sod.web.jsonapi.stationxml.PersonJson;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;

public class OperatorJson
implements ComplexAttributeJson {
    Operator operator;

    public static Operator decode(JSONObject res) {
        Operator operator = new Operator(res.optString("Agency"));
        for (Object o : res.getJSONArray("Contact")) {
            if (o == null || !(o instanceof JSONObject)) continue;
            operator.appendContact(PersonJson.decode((JSONObject)o));
        }
        operator.setWebsite(res.optString("WebSite"));
        return operator;
    }

    public OperatorJson(Operator operator) {
        this.operator = operator;
    }

    @Override
    public String getType() {
        return "operator";
    }

    @Override
    public void encodeAttributes(JSONWriter out) throws JSONException {
        JsonApi.doKeyValue(out, "Agency", this.operator.getAgency());
        out.key("Contact").array();
        for (Person p : this.operator.getContactList()) {
            out.object();
            new PersonJson(p).encodeAttributes(out);
            out.endObject();
        }
        out.endArray();
    }
}

