/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web.jsonapi.stationxml;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.BaseNodeType;
import edu.sc.seis.seisFile.fdsnws.stationxml.Comment;
import edu.sc.seis.seisFile.fdsnws.stationxml.Identifier;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.model.station.NetworkIdUtil;
import edu.sc.seis.sod.util.time.ClockUtil;
import edu.sc.seis.sod.web.jsonapi.AbstractJsonApiData;
import edu.sc.seis.sod.web.jsonapi.JsonApiResource;
import edu.sc.seis.sod.web.jsonapi.stationxml.CommentJson;
import edu.sc.seis.sod.web.jsonapi.stationxml.StationJson;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;

public class NetworkJson
extends AbstractJsonApiData {
    public static final String CODE = "code";
    public static final String STARTTIME = "starttime";
    public static final String ENDTIME = "endtime";
    public static final String DESCRIPTION = "description";
    public static final String TYPE = "networks";
    Network net;
    List<Station> stationList;

    public static Network decode(JsonApiResource res) {
        Network net = new Network();
        NetworkJson.decodeBaseNodeAttributes(res, (BaseNodeType)net);
        return net;
    }

    public NetworkJson(Network net, String baseUrl) {
        this(net, new ArrayList<Station>(), baseUrl);
    }

    public NetworkJson(Network net, List<Station> stationList, String baseUrl) {
        super(baseUrl);
        this.net = net;
        this.stationList = stationList;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getId() {
        Object s = this.net.getCode();
        if (NetworkIdUtil.isTemporary(this.net)) {
            s = (String)s + this.net.getStartYearString();
        }
        return s;
    }

    @Override
    public void encodeAttributes(JSONWriter out) throws JSONException {
        NetworkJson.encodeBaseNodeAttributes(out, (BaseNodeType)this.net);
    }

    public static void encodeBaseNodeAttributes(JSONWriter out, BaseNodeType b) {
        out.key(CODE).value((Object)b.getCode()).key(STARTTIME).value((Object)TimeUtils.toISOString((Instant)b.getStartDateTime())).key(ENDTIME).value(NetworkJson.encodeEndTime(b.getEndDateTime())).key(DESCRIPTION).value((Object)b.getDescription());
        out.key("Identifier").array();
        for (Identifier ident : b.getIdentifierList()) {
            out.object();
            out.key("Type").value((Object)ident.getType());
            out.key("Value").value((Object)ident.getValue());
            out.endObject();
        }
        out.endArray();
        out.key("Comment").array();
        for (Comment comment : b.getCommentList()) {
            out.object();
            new CommentJson(comment).encodeAttributes(out);
            out.endObject();
        }
        out.endArray();
    }

    public static BaseNodeType decodeBaseNodeAttributes(JsonApiResource res, BaseNodeType b) {
        b.setCode(res.getAttributeString(CODE));
        b.setStartDate(res.getAttributeString(STARTTIME));
        b.setEndDate(res.getAttributeString(ENDTIME));
        b.setDescription(res.getAttributeString(DESCRIPTION));
        for (Object o : res.getAttributeArray("Identifier")) {
            if (!(o instanceof JSONObject)) continue;
            JSONObject jo = (JSONObject)o;
            Identifier identifier = new Identifier(jo.getString("Value"), jo.getString("Type"));
        }
        for (Object o : res.getAttributeArray("Comment")) {
            if (!(o instanceof JSONObject)) continue;
            b.addComment(CommentJson.decode((JSONObject)o));
        }
        return b;
    }

    @Override
    public boolean hasRelationships() {
        return true;
    }

    @Override
    public void encodeRelationships(JSONWriter out) throws JSONException {
        out.key("stations").object().key("links").object().key("self").value((Object)this.formStationRelationshipURL(this.net)).key("related").value((Object)this.formStationListURL(this.net));
        out.endObject();
        if (this.stationList.size() != 0) {
            out.key("data").array();
            for (Station s : this.stationList) {
                out.object();
                StationJson sj = new StationJson(s, this.baseUrl);
                out.key("id").value((Object)sj.getId());
                out.key("type").value((Object)sj.getType());
                out.endObject();
            }
            out.endArray();
        }
        out.endObject();
    }

    @Override
    public boolean hasLinks() {
        return true;
    }

    @Override
    public void encodeLinks(JSONWriter out) throws JSONException {
        out.key("self").value((Object)this.formNetworkURL(this.net));
    }

    public String formStationRelationshipURL(Network net) {
        String out = this.baseUrl + "/networks/" + this.getId() + "/relationships/stations";
        return out;
    }

    public String formNetworkURL(Network net) {
        String out = this.baseUrl + "/networks/" + this.getId();
        return out;
    }

    public String formStationListURL(Network net) {
        String out = this.baseUrl + "/networks/" + this.getId() + "/stations";
        return out;
    }

    public static Object encodeEndTime(Instant endDate) {
        if (endDate != null && endDate.isBefore(ClockUtil.now())) {
            return TimeUtils.toISOString((Instant)endDate);
        }
        return null;
    }
}

