/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web.jsonapi.stationxml;

import edu.sc.seis.seisFile.fdsnws.stationxml.Equipment;
import edu.sc.seis.sod.web.jsonapi.ComplexAttributeJson;
import edu.sc.seis.sod.web.jsonapi.JsonApi;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;

public class EquipmentJson
implements ComplexAttributeJson {
    Equipment equip;

    public static Equipment decode(JSONObject res) {
        Equipment equip = new Equipment();
        equip.setType(res.optString("Type"));
        equip.setResourceId(res.optString("resourceId"));
        equip.setDescription(res.optString("Description"));
        equip.setManufacturer(res.optString("Manufacturer"));
        equip.setVendor(res.optString("Vendor"));
        equip.setModel(res.optString("Model"));
        equip.setSerialNumber(res.optString("SerialNumber"));
        equip.setInstallationDate(res.optString("InstallationDate"));
        equip.setRemovalDate(res.optString("RemovalDate"));
        for (Object o : res.getJSONArray("CalibrationDate")) {
            if (o == null || !(o instanceof String)) continue;
            equip.appendCalibrationDate((String)o);
        }
        return equip;
    }

    public EquipmentJson(Equipment equip) {
        this.equip = equip;
    }

    @Override
    public String getType() {
        return "equipment";
    }

    @Override
    public void encodeAttributes(JSONWriter out) throws JSONException {
        JsonApi.doKeyValue(out, "Type", this.equip.getType());
        JsonApi.doKeyValue(out, "resourceId", this.equip.getResourceId());
        JsonApi.doKeyValue(out, "Description", this.equip.getDescription());
        JsonApi.doKeyValue(out, "Manufacturer", this.equip.getManufacturer());
        JsonApi.doKeyValue(out, "Vendor", this.equip.getVendor());
        JsonApi.doKeyValue(out, "Model", this.equip.getModel());
        JsonApi.doKeyValue(out, "SerialNumber", this.equip.getSerialNumber());
        JsonApi.doKeyValue(out, "InstallationDate", this.equip.getInstallationDate());
        JsonApi.doKeyValue(out, "RemovalDate", this.equip.getRemovalDate());
        if (this.equip.getCalibrationDate().size() != 0) {
            out.key("CalibrationDate").array();
            for (String c : this.equip.getCalibrationDate()) {
                out.value((Object)c);
            }
            out.endArray();
        }
    }
}

