/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web.jsonapi.stationxml;

import edu.sc.seis.seisFile.fdsnws.stationxml.Comment;
import edu.sc.seis.seisFile.fdsnws.stationxml.Person;
import edu.sc.seis.sod.web.jsonapi.ComplexAttributeJson;
import edu.sc.seis.sod.web.jsonapi.JsonApi;
import edu.sc.seis.sod.web.jsonapi.stationxml.PersonJson;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;

public class CommentJson
implements ComplexAttributeJson {
    Comment comment;

    public static Comment decode(JSONObject res) {
        Comment c = new Comment(res.getString("Value"));
        c.setSubject(res.optString("subject", null));
        c.setBeginEffectiveTime(res.optString("BeginEffectiveTime", null));
        c.setEndEffectiveTime(res.optString("EndEffectiveTime", null));
        if (res.optJSONArray("Author") != null) {
            for (Object o : res.optJSONArray("Author")) {
                if (!(o instanceof JSONObject)) continue;
                c.appendAuthor(PersonJson.decode((JSONObject)o));
            }
        }
        return c;
    }

    public CommentJson(Comment comment) {
        this.comment = comment;
    }

    @Override
    public String getType() {
        return "Comment";
    }

    @Override
    public void encodeAttributes(JSONWriter out) throws JSONException {
        JsonApi.doKeyValue(out, "subject", this.comment.getSubject());
        JsonApi.doKeyValue(out, "Value", this.comment.getValue());
        JsonApi.doKeyValue(out, "BeginEffectiveTime", this.comment.getBeginEffectiveTime());
        JsonApi.doKeyValue(out, "EndEffectiveTime", this.comment.getEndEffectiveTime());
        out.key("Author").array();
        for (Person p : this.comment.getAuthorList()) {
            out.object();
            new PersonJson(p).encodeAttributes(out);
            out.endObject();
        }
        out.endArray();
    }
}

