/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web.jsonapi.stationxml;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.BaseNodeType;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Equipment;
import edu.sc.seis.seisFile.fdsnws.stationxml.ExternalReference;
import edu.sc.seis.seisFile.fdsnws.stationxml.Unit;
import edu.sc.seis.sod.web.jsonapi.AbstractJsonApiData;
import edu.sc.seis.sod.web.jsonapi.JsonApi;
import edu.sc.seis.sod.web.jsonapi.JsonApiResource;
import edu.sc.seis.sod.web.jsonapi.stationxml.EquipmentJson;
import edu.sc.seis.sod.web.jsonapi.stationxml.ExternalReferenceJson;
import edu.sc.seis.sod.web.jsonapi.stationxml.NetworkJson;
import edu.sc.seis.sod.web.jsonapi.stationxml.StationJson;
import java.time.Instant;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;

public class ChannelJson
extends AbstractJsonApiData {
    Channel chan;

    public static Channel decode(JsonApiResource res) {
        Channel chan = new Channel();
        NetworkJson.decodeBaseNodeAttributes(res, (BaseNodeType)chan);
        chan.setLocCode(res.getAttributeString("locationCode"));
        chan.setSampleRate(res.getAttributeDouble("SampleRate").floatValue());
        chan.setLatitude(res.getAttributeDouble("Latitude").floatValue());
        chan.setLongitude(res.getAttributeDouble("Longitude").floatValue());
        chan.setElevation(res.getAttributeDouble("Elevation").floatValue());
        chan.setDepth(res.getAttributeDouble("Depth").floatValue());
        chan.setAzimuth(res.getAttributeDouble("Azimuth").floatValue());
        chan.setDip(res.getAttributeDouble("Dip").floatValue());
        chan.setWaterlevel(res.getAttributeDouble("WaterLevel").floatValue());
        if (res.hasAttribute("Sensor")) {
            chan.setSensor(EquipmentJson.decode(res.getAttributeJsonObject("Sensor")));
        }
        if (res.hasAttribute("preAmplifier")) {
            chan.setPreAmplifier(EquipmentJson.decode(res.getAttributeJsonObject("preAmplifier")));
        }
        if (res.hasAttribute("DataLogger")) {
            chan.setDataLogger(EquipmentJson.decode(res.getAttributeJsonObject("DataLogger")));
        }
        for (Object e : res.getAttributeArray("Equipment")) {
            if (!(e instanceof JSONObject)) continue;
            chan.appendEquipment(EquipmentJson.decode((JSONObject)e));
        }
        chan.setClockDrift(res.getAttributeDouble("ClockDrift").floatValue());
        chan.setCalibrationUnits(new Unit(res.getAttributeString("CalibrationUnits")));
        return chan;
    }

    public ChannelJson(Channel chan, String baseUrl) {
        super(baseUrl);
        this.chan = chan;
        if (chan.getDbid() == 0) {
            // empty if block
        }
    }

    @Override
    public String getType() {
        return "channels";
    }

    @Override
    public String getId() {
        if (this.chan.getDbid() == 0) {
            StationJson staJson = new StationJson(this.chan.getStation(), this.baseUrl);
            return staJson.getId() + "_" + this.chan.getLocCode() + "_" + this.chan.getCode() + "_" + TimeUtils.toCompactISOString((Instant)this.chan.getStartDateTime());
        }
        return "" + this.chan.getDbid();
    }

    @Override
    public void encodeAttributes(JSONWriter out) throws JSONException {
        JsonApi.doKeyValue(out, "locationCode", this.chan.getLocCode());
        NetworkJson.encodeBaseNodeAttributes(out, (BaseNodeType)this.chan);
        JsonApi.doKeyValue(out, "SampleRate", Float.valueOf(this.chan.getSampleRate().getValue()));
        JsonApi.doKeyValue(out, "Latitude", Float.valueOf(this.chan.getLatitude().getValue()));
        JsonApi.doKeyValue(out, "Longitude", Float.valueOf(this.chan.getLongitude().getValue()));
        JsonApi.doKeyValue(out, "Elevation", Float.valueOf(this.chan.getElevation().getValue()));
        JsonApi.doKeyValue(out, "Depth", Float.valueOf(this.chan.getDepth().getValue()));
        JsonApi.doKeyValue(out, "Azimuth", Float.valueOf(this.chan.getAzimuth().getValue()));
        JsonApi.doKeyValue(out, "Dip", Float.valueOf(this.chan.getDip().getValue()));
        JsonApi.doKeyValue(out, "WaterLevel", Float.valueOf(this.chan.getWaterlevel().getValue()));
        if (this.chan.getTypeList().size() != 0) {
            out.key("Type").array();
            for (String t : this.chan.getTypeList()) {
                out.value((Object)t);
            }
            out.endArray();
        }
        JsonApi.doKeyValue(out, "ClockDrift", Float.valueOf(this.chan.getClockDrift().getValue()));
        JsonApi.doKeyValue(out, "CalibrationUnits", this.chan.getCalibrationUnits());
        if (this.chan.getExternalReferenceList().size() != 0) {
            out.key("ExternalReference").array();
            for (ExternalReference c : this.chan.getExternalReferenceList()) {
                out.object();
                new ExternalReferenceJson(c).encodeAttributes(out);
                out.endObject();
            }
            out.endArray();
        }
        if (this.chan.getSensor() != null) {
            out.key("Sensor").object();
            new EquipmentJson(this.chan.getSensor()).encodeAttributes(out);
            out.endObject();
        }
        if (this.chan.getPreAmplifier() != null) {
            out.key("preAmplifier").object();
            new EquipmentJson(this.chan.getPreAmplifier()).encodeAttributes(out);
            out.endObject();
        }
        if (this.chan.getDataLogger() != null) {
            out.key("DataLogger").object();
            new EquipmentJson(this.chan.getDataLogger()).encodeAttributes(out);
            out.endObject();
        }
        if (this.chan.getEquipmentList().size() != 0) {
            out.key("Equipment").array();
            for (ExternalReference c : this.chan.getEquipmentList()) {
                out.object();
                new EquipmentJson((Equipment)c).encodeAttributes(out);
                out.endObject();
            }
            out.endArray();
        }
    }

    @Override
    public boolean hasRelationships() {
        return true;
    }

    @Override
    public void encodeRelationships(JSONWriter out) throws JSONException {
        StationJson staJson = new StationJson(this.chan.getStation(), this.getBaseUrl());
        out.key("station").object();
        out.key("id").value((Object)staJson.getId());
        out.key("type").value((Object)staJson.getType());
        out.endObject();
    }

    @Override
    public boolean hasLinks() {
        return false;
    }

    @Override
    public void encodeLinks(JSONWriter out) throws JSONException {
    }
}

