/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web.jsonapi;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.sod.hibernate.EventSeismogramFileReference;
import edu.sc.seis.sod.hibernate.SeismogramFileTypes;
import edu.sc.seis.sod.hibernate.UnsupportedFileTypeException;
import edu.sc.seis.sod.web.jsonapi.AbstractJsonApiData;
import edu.sc.seis.sod.web.jsonapi.JsonApiData;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONWriter;

public class WaveformJson
extends AbstractJsonApiData {
    EventSeismogramFileReference ref;

    public WaveformJson(EventSeismogramFileReference ref, String baseUrl) {
        super(baseUrl);
        this.ref = ref;
    }

    @Override
    public String getType() {
        return "waveforms";
    }

    @Override
    public String getId() {
        return "" + this.ref.getDbid();
    }

    @Override
    public void encodeAttributes(JSONWriter out) throws JSONException {
        out.key("network-code").value((Object)this.ref.getNetworkCode());
        out.key("station-code").value((Object)this.ref.getStationCode());
        out.key("loc-code").value((Object)this.ref.getLocCode());
        out.key("channel-code").value((Object)this.ref.getChannelCode());
        out.key("start-time").value((Object)TimeUtils.toISOString((Instant)this.ref.getBeginTime()));
        out.key("end-time").value((Object)TimeUtils.toISOString((Instant)this.ref.getEndTime()));
        out.key("file-path").value((Object)this.ref.getFilePath());
        out.key("data-url").value((Object)this.formDataURL(this.ref));
        try {
            out.key("file-type").value((Object)SeismogramFileTypes.fromInt(this.ref.getFileType()).getName());
        }
        catch (UnsupportedFileTypeException e) {
            out.key("file-type").value((Object)("" + this.ref.getFileType()));
        }
    }

    @Override
    public void encodeRelationships(JSONWriter out) throws JSONException {
        out.key("quake").object();
        out.key("data").object();
        out.key("id").value((Object)("" + this.ref.getEvent().getDbid()));
        out.key("type").value((Object)"quake");
        out.endObject();
        out.endObject();
    }

    public String formDataURL(EventSeismogramFileReference ref) {
        String out = this.baseUrl + "/waveforms/" + ref.getDbid() + "/mseed";
        return out;
    }

    public static List<JsonApiData> toJsonList(List<EventSeismogramFileReference> refList, String baseUrl) {
        ArrayList<JsonApiData> out = new ArrayList<JsonApiData>(refList.size());
        for (EventSeismogramFileReference ref : refList) {
            out.add(new WaveformJson(ref, baseUrl));
        }
        return out;
    }
}

