/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web.jsonapi;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.BuildVersion;
import edu.sc.seis.sod.web.jsonapi.AbstractJsonApiData;
import java.util.List;
import org.json.JSONException;
import org.json.JSONWriter;

public class TauPJson
extends AbstractJsonApiData {
    Arrival arrival;

    public TauPJson(Arrival arrival, String baseUrl) {
        super(baseUrl);
        this.arrival = arrival;
    }

    @Override
    public String getType() {
        return "arrivals";
    }

    @Override
    public String getId() {
        String s = this.arrival.getPhase().getTauModel().getModelName() + "-" + this.arrival.getSourceDepth() + "-" + this.arrival.getName() + "-" + this.arrival.getDistDeg();
        return s;
    }

    @Override
    public void encodeAttributes(JSONWriter out) throws JSONException {
        out.key("phasename").value((Object)this.arrival.getPhase().getName());
        out.key("puristname").value((Object)this.arrival.getPhase().getPuristName());
        out.key("traveltime").value(this.arrival.getTime());
        out.key("distdeg").value(this.arrival.getDistDeg());
        out.key("distrad").value(this.arrival.getDist());
        out.key("sourcedepth").value(this.arrival.getSourceDepth());
        out.key("incidentangle").value(this.arrival.getIncidentAngle());
        out.key("takeoffangle").value(this.arrival.getTakeoffAngle());
        out.key("rayparamrad").value(this.arrival.getRayParam());
        out.key("rayparamdeg").value(this.arrival.getRayParamDeg());
        out.key("model").value((Object)this.arrival.getPhase().getTauModel().getModelName());
    }

    public void encodeLikeIrisService(List<Arrival> arrivalList, JSONWriter out) {
        out.object();
        out.key("arrivals").array();
        for (Arrival arrival : arrivalList) {
            out.object();
            out.key("phasename").value((Object)arrival.getPhase().getName());
            out.key("puristname").value((Object)arrival.getPhase().getPuristName());
            out.key("traveltime").value(arrival.getTime());
            out.key("distdeg").value(arrival.getDistDeg());
            out.key("distrad").value(arrival.getDist());
            out.key("sourcedepth").value(arrival.getSourceDepth());
            out.key("incidentangle").value(arrival.getIncidentAngle());
            out.key("takeoffangle").value(arrival.getTakeoffAngle());
            out.key("rayparamrad").value(arrival.getRayParam());
            out.key("rayparamdeg").value(arrival.getRayParamDeg());
            out.key("model").value((Object)arrival.getPhase().getTauModel().getModelName());
            out.endObject();
        }
        out.endArray();
        out.key("serviceurl").value((Object)this.baseUrl);
        out.key("version").value((Object)BuildVersion.getDetailedVersion());
        out.endObject();
    }
}

