/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web.jsonapi;

import edu.sc.seis.sod.web.jsonapi.JsonApiDocument;
import edu.sc.seis.sod.web.jsonapi.JsonApiException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonApiResource {
    JSONObject wrapped;
    private static final Logger logger = LoggerFactory.getLogger(JsonApiResource.class);

    public static List<JsonApiResource> parseArray(String json) throws JSONException, JsonApiException {
        ArrayList<JsonApiResource> out = new ArrayList<JsonApiResource>();
        JSONArray jsonArr = new JSONArray(json);
        for (Object obj : jsonArr) {
            if (!(obj instanceof JSONObject)) continue;
            JsonApiResource res = new JsonApiResource((JSONObject)obj);
            out.add(res);
        }
        return out;
    }

    public static JsonApiResource parse(String json) throws JSONException, JsonApiException {
        JsonApiResource doc = new JsonApiResource(new JSONObject(json));
        return doc;
    }

    public JsonApiResource(JSONObject jsonObject) throws JsonApiException {
        this.wrapped = jsonObject;
        if (this.getType() == null) {
            throw new JsonApiException("type missing in resource");
        }
    }

    public JsonApiResource(String id, String type) throws JsonApiException {
        this(new JSONObject().put("id", (Object)id).put("type", (Object)type));
    }

    public String createId() {
        this.wrapped.put("id", (Object)UUID.randomUUID().toString());
        logger.info("Create id: " + this.getId());
        return this.getId();
    }

    public JSONObject rawAttributeObject() {
        JSONObject attr = this.wrapped.optJSONObject("attributes");
        return attr;
    }

    public Iterator<String> attributeKeys() {
        JSONObject obj = this.rawAttributeObject();
        if (obj == null) {
            return new JSONObject().keys();
        }
        return obj.keys();
    }

    public boolean hasAttribute(String key) {
        return this.getAttribute(key) != null;
    }

    public Object getAttribute(String key) {
        JSONObject attr = this.rawAttributeObject();
        Object out = null;
        if (attr != null) {
            out = attr.opt(key);
        }
        return out;
    }

    public String getAttributeString(String key) {
        JSONObject attr = this.rawAttributeObject();
        String out = null;
        if (attr != null) {
            out = attr.optString(key);
        }
        return out;
    }

    public String getAttributeString(String key, String defaultValue) {
        String out = this.getAttributeString(key);
        return out != null ? out : defaultValue;
    }

    public Integer getAttributeInt(String key) {
        JSONObject attr = this.rawAttributeObject();
        Integer out = null;
        if (attr != null) {
            out = attr.optInt(key);
        }
        return out;
    }

    public Integer getAttributeInt(String key, Integer defaultValue) {
        Integer out = this.getAttributeInt(key);
        return out != null ? out : defaultValue;
    }

    public Double getAttributeDouble(String key) {
        JSONObject attr = this.rawAttributeObject();
        Double out = null;
        if (attr != null) {
            out = attr.optDouble(key);
        }
        return out;
    }

    public Double getAttributeDouble(String key, Double defaultValue) {
        Double out = this.getAttributeDouble(key);
        return out != null ? out : defaultValue;
    }

    public JSONObject getAttributeJsonObject(String key) {
        JSONObject attr = this.rawAttributeObject();
        JSONObject out = null;
        if (attr != null) {
            out = attr.optJSONObject(key);
        }
        return out;
    }

    public JSONArray getAttributeArray(String key) {
        JSONObject attr = this.rawAttributeObject();
        JSONArray out = null;
        if (attr != null) {
            out = attr.optJSONArray(key);
        }
        return out;
    }

    public void setAttribute(String key, Object value) {
        if (this.rawAttributeObject() == null) {
            this.wrapped.put("attributes", (Object)new JSONObject());
        }
        this.wrapped.getJSONObject("attributes").put(key, value);
    }

    public JSONObject rawRelationshipObject() {
        JSONObject rel = this.wrapped.optJSONObject("relationships");
        return rel;
    }

    public Iterator<String> relationshipKeys() {
        JSONObject obj = this.rawRelationshipObject();
        if (obj == null) {
            return new JSONObject().keys();
        }
        return obj.keys();
    }

    public boolean hasRelationship(String key) {
        boolean out = this.rawRelationshipObject().has(key);
        if (out) {
            Object obj = this.rawRelationshipObject().get(key);
            if (obj instanceof JSONObject) {
                out = !this.rawRelationshipObject().getJSONObject(key).isNull("data");
            } else {
                JSONArray arr = this.rawRelationshipObject().getJSONArray(key);
                out = true;
            }
        }
        return out;
    }

    public JsonApiDocument getRelationship(String key) throws JsonApiException {
        JSONObject rel = this.rawRelationshipObject();
        JsonApiDocument out = null;
        if (this.hasRelationship(key)) {
            logger.debug("getRelationship(" + key + ")  " + String.valueOf(rel.optJSONObject(key)));
            if (rel.optJSONObject(key) != null) {
                out = new JsonApiDocument(rel.optJSONObject(key));
            } else if (rel.optJSONArray(key) != null) {
                out = JsonApiDocument.createForArray(rel.optJSONArray(key));
            } else {
                throw new JsonApiException("Relationship must be either JSONObject or JSONArray: " + String.valueOf(rel.opt(key)));
            }
        }
        return out;
    }

    public void setRelationshipNull(String key) {
        JSONObject related = new JSONObject();
        related.put("data", JSONObject.NULL);
        this.setRelationshipRaw(key, related);
    }

    public void setRelationship(String key, String id, String type) {
        JSONObject related = new JSONObject();
        JSONObject data = new JSONObject();
        data.put("id", (Object)id);
        data.put("type", (Object)type);
        related.put("data", (Object)data);
        this.setRelationshipRaw(key, related);
    }

    public void appendRelationship(String key, String id, String type) throws JSONException, JsonApiException {
        JSONArray relArr;
        if (!this.hasRelationship(key)) {
            JSONObject related = new JSONObject();
            JSONArray data = new JSONArray();
            related.put("data", (Object)data);
            this.setRelationshipRaw(key, related);
        }
        if ((relArr = this.getRelationshipArrayRaw(key)) == null) {
            throw new JsonApiException("Attempt to append to " + key + " but related is not array");
        }
        relArr.put((Object)new JsonApiResource(id, type).getWrapped());
    }

    public void setRelationshipLink(String key, String relatedUrl, String selfUrl) {
        JSONObject related = new JSONObject();
        JSONObject links = new JSONObject();
        if (selfUrl != null) {
            links.put("self", (Object)selfUrl);
        }
        if (relatedUrl != null) {
            links.put("related", (Object)relatedUrl);
        }
        related.put("links", (Object)links);
        this.setRelationshipRaw(key, related);
    }

    public JSONObject getRelationshipRaw(String key) {
        if (this.rawRelationshipObject() == null) {
            return null;
        }
        return this.wrapped.getJSONObject("relationships").optJSONObject(key);
    }

    public JSONArray getRelationshipArrayRaw(String key) {
        JSONObject rel = this.getRelationshipRaw(key);
        if (rel == null) {
            return null;
        }
        return rel.optJSONArray("data");
    }

    public void setRelationshipRaw(String key, Object value) {
        if (this.rawRelationshipObject() == null) {
            this.wrapped.put("relationships", (Object)new JSONObject());
        }
        this.wrapped.getJSONObject("relationships").put(key, value);
    }

    public void deleteRelationship(String key) {
        if (this.rawRelationshipObject() == null) {
            return;
        }
        this.wrapped.getJSONObject("relationships").remove(key);
    }

    public JSONObject getLinks() {
        JSONObject rel = this.wrapped.optJSONObject("links");
        return rel;
    }

    public JSONObject getLink(String key) {
        JSONObject rel = this.getLinks();
        JSONObject out = null;
        if (rel != null) {
            out = rel.optJSONObject(key);
        }
        return out;
    }

    public void setLink(String key, String value) {
        if (this.getLinks() == null) {
            this.wrapped.put("links", (Object)new JSONObject());
        }
        this.wrapped.getJSONObject("links").put(key, (Object)value);
    }

    public JSONObject getMetaObj() {
        JSONObject rel = this.wrapped.optJSONObject("links");
        return rel;
    }

    public JSONObject getMeta(String key) {
        JSONObject rel = this.getMetaObj();
        JSONObject out = null;
        if (rel != null) {
            out = rel.optJSONObject(key);
        }
        return out;
    }

    public void setMeta(String key, JSONObject value) {
        if (this.getMetaObj() == null) {
            this.wrapped.put("meta", (Object)new JSONObject());
        }
        this.wrapped.getJSONObject("meta").put(key, (Object)value);
    }

    public boolean needIdCreated() {
        return this.wrapped.optString("id").length() == 0;
    }

    public String optId() {
        return this.wrapped.optString("id");
    }

    public String getId() {
        return this.wrapped.getString("id");
    }

    public String getType() {
        return this.wrapped.getString("type");
    }

    public JSONObject getWrapped() {
        return this.wrapped;
    }

    public String toString(int i) {
        return this.wrapped.toString(i);
    }
}

