/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web.jsonapi;

import edu.sc.seis.sod.web.jsonapi.JsonApiException;
import edu.sc.seis.sod.web.jsonapi.JsonApiResource;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonApiDocument {
    JSONObject wrapped;
    private static final Logger logger = LoggerFactory.getLogger(JsonApiDocument.class);

    public static JsonApiDocument parse(String json) throws JSONException, JsonApiException {
        JsonApiDocument doc = new JsonApiDocument(new JSONObject(json.toString()));
        if (!doc.hasData()) {
            throw new JsonApiException("data missing in document: " + json);
        }
        return doc;
    }

    public static JsonApiDocument createEmpty() {
        JsonApiDocument out;
        JSONObject obj = new JSONObject();
        try {
            out = new JsonApiDocument(obj);
        }
        catch (JsonApiException e) {
            throw new RuntimeException("can't happen, but it did", e);
        }
        return out;
    }

    public static JsonApiDocument createEmptyArray() {
        JsonApiDocument out = JsonApiDocument.createEmpty();
        out.setDataArray(new ArrayList<JsonApiResource>());
        return out;
    }

    public static JsonApiDocument createForResource(JsonApiResource res) {
        JsonApiDocument doc = JsonApiDocument.createEmpty();
        doc.setData(res);
        return doc;
    }

    public static JsonApiDocument createForArray(JSONArray arr) throws JSONException, JsonApiException {
        JsonApiDocument doc = JsonApiDocument.createEmptyArray();
        for (Object object : arr) {
            if (object instanceof JSONObject) {
                doc.append(new JsonApiResource((JSONObject)object));
                continue;
            }
            throw new JsonApiException("Expected JSONObject but found " + object.getClass().getName());
        }
        return doc;
    }

    JsonApiDocument(JSONObject jsonObject) throws JsonApiException {
        if (jsonObject == null) {
            throw new JsonApiException("jsonObject cannot be null");
        }
        this.wrapped = jsonObject;
        if (this.hasData() && !this.isDataArray()) {
            JsonApiResource data = this.getData();
            if (data.needIdCreated()) {
                data.createId();
            } else {
                logger.debug("Id already there, not created: " + data.getId());
            }
        } else {
            logger.debug("no data or array, so skip id check");
        }
    }

    public boolean hasData() throws JsonApiException {
        boolean out;
        boolean bl = out = this.wrapped.optJSONArray("data") != null;
        if (!out && this.wrapped.optJSONObject("data") != null) {
            out = !this.wrapped.isNull("data");
        }
        return out;
    }

    public boolean isDataArray() {
        return this.wrapped.opt("data") instanceof JSONArray;
    }

    public JsonApiResource getData() throws JsonApiException {
        Object obj = this.wrapped.opt("data");
        if (obj != null && !this.wrapped.isNull("data") && obj instanceof JSONObject) {
            return new JsonApiResource((JSONObject)obj);
        }
        return null;
    }

    public void setData(JsonApiResource value) {
        this.wrapped.put("data", (Object)value.getWrapped());
    }

    public List<JsonApiResource> getDataArray() throws JsonApiException {
        Object obj = this.wrapped.opt("data");
        if (obj != null && obj instanceof JSONArray) {
            JSONArray arr = (JSONArray)obj;
            ArrayList<JsonApiResource> out = new ArrayList<JsonApiResource>();
            for (Object o : arr) {
                out.add(new JsonApiResource((JSONObject)o));
            }
            return out;
        }
        return null;
    }

    public void setDataArray(List<JsonApiResource> value) {
        JSONArray arr = new JSONArray();
        for (JsonApiResource res : value) {
            arr.put((Object)res.getWrapped());
        }
        this.wrapped.put("data", (Object)arr);
    }

    public void append(JsonApiResource value) throws JSONException, JsonApiException {
        if (!this.hasData()) {
            this.wrapped.put("data", (Object)new JSONArray());
        }
        if (!this.isDataArray()) {
            throw new JsonApiException("data is not array");
        }
        ((JSONArray)this.wrapped.get("data")).put((Object)value.wrapped);
    }

    public boolean hasIncluded() throws JsonApiException {
        return this.wrapped.optJSONArray("included") != null;
    }

    public void include(JsonApiResource value) throws JSONException, JsonApiException {
        if (!this.hasIncluded()) {
            this.wrapped.put("included", (Object)new JSONArray());
        }
        ((JSONArray)this.wrapped.get("included")).put((Object)value.getWrapped());
    }

    public String toString(int i) {
        return this.wrapped.toString(i);
    }

    public String toString() {
        return this.wrapped.toString();
    }
}

