/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web.jsonapi;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.hibernate.eventpair.AbstractEventChannelPair;
import edu.sc.seis.sod.hibernate.eventpair.EventChannelPair;
import edu.sc.seis.sod.hibernate.eventpair.EventVectorPair;
import edu.sc.seis.sod.model.common.DistAz;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.web.jsonapi.AbstractJsonApiData;
import edu.sc.seis.sod.web.jsonapi.stationxml.ChannelJson;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;

public class EventVectorJson
extends AbstractJsonApiData {
    AbstractEventChannelPair ecp;

    public EventVectorJson(AbstractEventChannelPair ecp, String baseUrl) {
        super(baseUrl);
        if (ecp == null) {
            throw new IllegalArgumentException("ECP can't be null");
        }
        this.ecp = ecp;
    }

    @Override
    public String getType() {
        return "quake-vectors";
    }

    @Override
    public String getId() {
        return "" + this.ecp.getDbid();
    }

    @Override
    public void encodeAttributes(JSONWriter out) throws JSONException {
        out.key("sod-status").value((Object)this.ecp.getStatus());
        JSONObject measurements = new JSONObject();
        for (String key : this.ecp.getCookieJar().getAll().keySet()) {
            if (key.startsWith("SeisFile_")) continue;
            String jsonFriendlyKey = key.replaceAll("\\W", "-");
            measurements.put(jsonFriendlyKey, this.ecp.getCookieJar().getRaw(key));
        }
        out.key("measurements").value((Object)measurements);
        DistAz distaz = new DistAz(this.ecp.getEsp().getStation(), (CacheEvent)this.ecp.getEsp().getEvent());
        out.key("distdeg").value(distaz.getDelta());
        out.key("azimuth").value(distaz.getAz());
        out.key("backazimuth").value(distaz.getBaz());
        super.encodeAttributes(out);
    }

    @Override
    public boolean hasRelationships() {
        return true;
    }

    @Override
    public void encodeRelationships(JSONWriter out) throws JSONException {
        out.key("quake").object();
        out.key("data").object();
        out.key("id").value((Object)("" + this.ecp.getEventDbId()));
        out.key("type").value((Object)"quake");
        out.endObject();
        out.endObject();
        out.key("channels").object();
        out.key("data").array();
        if (this.ecp instanceof EventChannelPair) {
            out.object();
            ChannelJson chanJson = new ChannelJson(((EventChannelPair)this.ecp).getChannel(), this.getBaseUrl());
            out.key("id").value((Object)chanJson.getId());
            out.key("type").value((Object)chanJson.getType());
            out.key("links").object();
            out.key("self").value((Object)(this.baseUrl + "/channels/" + chanJson.getId()));
            out.endObject();
            out.endObject();
        } else {
            EventVectorPair evp = (EventVectorPair)this.ecp;
            Channel[] chans = evp.getChannelGroup().getChannels();
            for (int i = 0; i < chans.length; ++i) {
                out.object();
                ChannelJson chanJson = new ChannelJson(chans[i], this.getBaseUrl());
                out.key("id").value((Object)chanJson.getId());
                out.key("type").value((Object)chanJson.getType());
                out.key("links").object();
                out.key("self").value((Object)(this.baseUrl + "/channels/" + chanJson.getId()));
                out.endObject();
                out.endObject();
            }
        }
        out.endArray();
        out.endObject();
        out.key("waveforms").object();
        out.key("links").object();
        out.key("related").value((Object)(this.baseUrl + "/quake-vectors/" + this.getId() + "/waveforms"));
        out.endObject();
        out.endObject();
    }
}

