/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web.jsonapi;

import edu.sc.seis.sod.hibernate.eventpair.AbstractEventChannelPair;
import edu.sc.seis.sod.hibernate.eventpair.EventStationPair;
import edu.sc.seis.sod.model.common.DistAz;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.web.jsonapi.AbstractJsonApiData;
import edu.sc.seis.sod.web.jsonapi.EventVectorJson;
import edu.sc.seis.sod.web.jsonapi.JsonApiData;
import edu.sc.seis.sod.web.jsonapi.stationxml.StationJson;
import java.util.List;
import org.json.JSONException;
import org.json.JSONWriter;

public class EventStationJson
extends AbstractJsonApiData {
    EventStationPair esp;
    List<AbstractEventChannelPair> ecpList;

    public EventStationJson(EventStationPair esp, String baseUrl) {
        this(esp, null, baseUrl);
    }

    public EventStationJson(EventStationPair esp, List<AbstractEventChannelPair> ecpList, String baseUrl) {
        super(baseUrl);
        this.esp = esp;
        this.ecpList = ecpList;
    }

    @Override
    public String getId() {
        return "" + this.esp.getDbid();
    }

    @Override
    public String getType() {
        return "quake-stations";
    }

    @Override
    public void encodeAttributes(JSONWriter out) throws JSONException {
        out.key("sod-status").value((Object)this.esp.getStatus().toString());
        DistAz distaz = new DistAz(this.esp.getStation(), (CacheEvent)this.esp.getEvent());
        out.key("distdeg").value(distaz.getDelta());
        out.key("azimuth").value(distaz.getAz());
        out.key("backazimuth").value(distaz.getBaz());
    }

    @Override
    public boolean hasRelationships() {
        return true;
    }

    @Override
    public void encodeRelationships(JSONWriter out) throws JSONException {
        out.key("quake").object();
        out.key("data").object();
        out.key("id").value((Object)("" + this.esp.getEventDbId()));
        out.key("type").value((Object)"quake");
        out.key("links").object();
        out.key("self").value((Object)(this.baseUrl + "/quakes/" + this.esp.getEventDbId()));
        out.endObject();
        out.endObject();
        out.endObject();
        out.key("station").object();
        out.key("data").object();
        StationJson staJson = new StationJson(this.esp.getStation(), this.getBaseUrl());
        out.key("id").value((Object)staJson.getId());
        out.key("type").value((Object)"station");
        out.key("links").object();
        out.key("self").value((Object)(this.baseUrl + "/stations/" + staJson.getId()));
        out.endObject();
        out.endObject();
        out.endObject();
        if (this.ecpList != null) {
            out.key("ecps");
            out.object();
            out.key("data").array();
            for (AbstractEventChannelPair ecp : this.ecpList) {
                out.object();
                out.key("id").value(ecp.getDbid());
                out.key("type").value((Object)"quake-vector");
                out.endObject();
            }
            out.endArray();
            out.endObject();
        } else {
            out.key("ecps").object();
            out.key("links").object();
            out.key("related").value((Object)(this.baseUrl + "/quake-stations/" + this.getId() + "/quake-vectors"));
            out.endObject();
            out.endObject();
        }
        out.key("measurements");
        out.object();
        out.key("links").object();
        out.key("self").value((Object)(this.baseUrl + "/quake-stations/" + this.getId() + "/relationships/measurements"));
        out.key("related").value((Object)(this.baseUrl + "/quake-stations/" + this.getId() + "/measurements"));
        out.endObject();
        out.endObject();
    }

    @Override
    public List<JsonApiData> included() {
        List<JsonApiData> out = super.included();
        if (this.ecpList != null) {
            for (AbstractEventChannelPair ecp : this.ecpList) {
                out.add(new EventVectorJson(ecp, this.getBaseUrl()));
            }
        }
        return out;
    }
}

