/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web;

import edu.sc.seis.sod.Arm;
import edu.sc.seis.sod.ArmListener;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.web.AlwaysEmberIndexHandler;
import edu.sc.seis.sod.web.ArmStatusServlet;
import edu.sc.seis.sod.web.ChannelServlet;
import edu.sc.seis.sod.web.EventServlet;
import edu.sc.seis.sod.web.EventStationServlet;
import edu.sc.seis.sod.web.EventVectorServlet;
import edu.sc.seis.sod.web.MeasurementTextServlet;
import edu.sc.seis.sod.web.MeasurementToolServlet;
import edu.sc.seis.sod.web.NetworkServlet;
import edu.sc.seis.sod.web.PerusalServlet;
import edu.sc.seis.sod.web.SodConfigServlet;
import edu.sc.seis.sod.web.StationsServlet;
import edu.sc.seis.sod.web.SuccessfulEventCache;
import edu.sc.seis.sod.web.TauPServlet;
import edu.sc.seis.sod.web.WaveformServlet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.BindException;
import java.util.Collections;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.DigestAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAdmin
implements ArmListener {
    public static final String SITE = "site";
    public static final String API = "api";
    public static final String JSON_DATA_DIR = "jsonData";
    Thread keepAliveThread;
    Server server;
    private static final Logger logger = LoggerFactory.getLogger(WebAdmin.class);
    static SuccessfulEventCache eventCache = new SuccessfulEventCache();

    public void start() throws Exception {
        int initialPort;
        File realmProps;
        ResourceHandler resource_handler = new ResourceHandler();
        resource_handler.setDirectoriesListed(true);
        resource_handler.setWelcomeFiles(new String[]{"index.html"});
        resource_handler.setBaseResource(Resource.newResource((File)new File(SITE)));
        ServletHandler servlets = new ServletHandler();
        servlets.setEnsureDefaultServlet(false);
        servlets.addServletWithMapping(ArmStatusServlet.class, "/api/arms");
        this.addServlets(servlets, EventServlet.class, "quakes");
        this.addServlets(servlets, NetworkServlet.class, "networks");
        this.addServlets(servlets, StationsServlet.class, "stations");
        this.addServlets(servlets, ChannelServlet.class, "channels");
        this.addServlets(servlets, EventStationServlet.class, "quake-stations");
        this.addServlets(servlets, EventVectorServlet.class, "quake-vectors");
        this.addServlets(servlets, WaveformServlet.class, "waveform");
        this.addServlets(servlets, WaveformServlet.class, "waveforms");
        this.addServlets(servlets, TauPServlet.class, "taup");
        this.addServlets(servlets, SodConfigServlet.class, "sod-configs");
        this.addServlets(servlets, PerusalServlet.class, "perusals");
        this.addServlets(servlets, MeasurementToolServlet.class, "measurement-tools");
        this.addServlets(servlets, MeasurementTextServlet.class, "measurements");
        this.addServlets(servlets, MeasurementTextServlet.class, "measurement-texts");
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{servlets, new AlwaysEmberIndexHandler(), resource_handler, new DefaultHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                logger.warn("missed get: " + String.valueOf(request.getRequestURL()));
                super.handle(target, baseRequest, request, response);
            }
        }, new DefaultHandler()});
        HashLoginService loginService = new HashLoginService("MyRealm", WebAdmin.getJsonDataDir() + "/realm.properties");
        File jsonDataDir = new File(WebAdmin.getJsonDataDir());
        if (!jsonDataDir.exists()) {
            jsonDataDir.mkdirs();
        }
        if (!(realmProps = new File(jsonDataDir, "realm.properties")).exists()) {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(realmProps)));
            out.println("# This file defines the password for the SOD status pages.");
            out.println("# Format is username: password[,rolename ...]");
            out.println("# Roles can be user or admin");
            out.println("# Default is user 'sod' and password 'sod':");
            out.println("#   sod: sod,user");
            out.println("sod: sod,user");
            out.close();
        }
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        security.setHandler((Handler)handlers);
        Constraint constraint = new Constraint();
        constraint.setName("auth");
        constraint.setAuthenticate(true);
        constraint.setRoles(new String[]{"user", "admin"});
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setPathSpec("/*");
        mapping.setConstraint(constraint);
        security.setConstraintMappings(Collections.singletonList(mapping));
        security.setAuthenticator((Authenticator)new DigestAuthenticator());
        security.setLoginService((LoginService)loginService);
        int port = initialPort = 8080;
        int maxPortTries = 10;
        while (this.server == null) {
            try {
                this.server = new Server(port);
                if (Start.getRunProps().isStatusUnsecure()) {
                    System.out.println("Warning: running status in unsecure mode, no password protection. This is dangerous. You have been warned!!!");
                    this.server.setHandler((Handler)handlers);
                } else {
                    this.server.addBean((Object)loginService);
                    this.server.setHandler((Handler)security);
                }
                this.server.start();
            }
            catch (BindException e) {
                if (port - initialPort < maxPortTries) {
                    logger.info("port " + port + " in use, trying next in line.", (Object)e.getMessage());
                    ++port;
                    continue;
                }
                throw e;
            }
        }
        final Server serverInContext = this.server;
        logger.info("Web Admin started at " + String.valueOf(this.server.getURI()) + " port:" + port);
        System.out.println("Web Admin started at " + String.valueOf(this.server.getURI()) + " port:" + port);
        if (Start.getArgs().isStatus() || Start.getRunProps().isStatusWebKeepAlive()) {
            this.keepAliveThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        System.err.println("Before join jetty");
                        serverInContext.join();
                        System.err.println("After join, guess jetty quit");
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }, "JettyKeepAlive");
            this.keepAliveThread.start();
        }
    }

    void addServlets(ServletHandler servlets, Class<? extends Servlet> servletClass, String partialUrl) {
        servlets.addServletWithMapping(servletClass, "/api/" + partialUrl);
        servlets.addServletWithMapping(servletClass, "/api/" + partialUrl + "/");
        servlets.addServletWithMapping(servletClass, "/api/" + partialUrl + "/*");
    }

    @Override
    public void finished(Arm arm) {
        this.checkIfStayAlive();
    }

    @Override
    public void starting(Arm arm) throws ConfigurationException {
    }

    @Override
    public void started() throws ConfigurationException {
        this.checkIfStayAlive();
    }

    void checkIfStayAlive() {
        System.err.println("check if stay alive");
        if (!Start.isAnyWaveformArmActive()) {
            if (Start.getRunProps().isStatusWebKeepAlive()) {
                System.err.println("--status to keep SOD alive true, so control-c to quit SOD.");
            } else {
                try {
                    System.err.println("All finished, stopping web admin");
                    this.server.stop();
                }
                catch (Exception e) {
                    logger.error("Unable to stop jetty web server", (Throwable)e);
                }
            }
        }
    }

    public void join() throws InterruptedException {
        System.err.println("Before Join");
        this.server.join();
        System.err.println("After Join");
    }

    public static SuccessfulEventCache getSuccessfulEventCache() {
        return eventCache;
    }

    public static String getApiBaseUrl() {
        return "/api";
    }

    public static String getJsonDataDir() {
        return JSON_DATA_DIR;
    }

    public static void setJsonHeader(HttpServletRequest req, HttpServletResponse resp) {
        if (req.getHeader("accept") != null && req.getHeader("accept").contains("application/vnd.api+json")) {
            resp.setContentType("application/vnd.api+json");
            logger.info("      contentType: application/vnd.api+json");
        } else {
            resp.setContentType("application/json");
            logger.info("      contentType: application/json");
        }
    }
}

