/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web;

import edu.sc.seis.sod.hibernate.AbstractHibernateDB;
import edu.sc.seis.sod.hibernate.EventSeismogramFileReference;
import edu.sc.seis.sod.hibernate.SeismogramFileTypes;
import edu.sc.seis.sod.hibernate.UnsupportedFileTypeException;
import edu.sc.seis.sod.web.WebAdmin;
import edu.sc.seis.sod.web.jsonapi.JsonApi;
import edu.sc.seis.sod.web.jsonapi.WaveformJson;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hibernate.query.Query;
import org.json.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaveformServlet
extends HttpServlet {
    Pattern waveformPattern = Pattern.compile(".*/waveforms?/([0-9]+)");
    Pattern mseedPattern = Pattern.compile(".*/waveforms?/([0-9]+)/mseed");
    private static final Logger logger = LoggerFactory.getLogger(WaveformServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String URL2 = req.getRequestURL().toString();
        logger.info("GET: " + URL2);
        Matcher waveformMatcher = this.waveformPattern.matcher(URL2);
        Matcher m = this.mseedPattern.matcher(URL2);
        if (m.matches()) {
            EventSeismogramFileReference ref = this.getSeisRef(m.group(1));
            resp.setContentType("application/vnd.fdsn.mseed");
            ServletOutputStream outBinary = resp.getOutputStream();
            logger.info("FileRef: " + ref.getFilePath());
            try {
                if (SeismogramFileTypes.fromInt(ref.getFileType()).equals(SeismogramFileTypes.MSEED)) {
                    File seisFile = new File(ref.getFilePath());
                    resp.setHeader("content-disposition", "attachment; filename=" + seisFile.getName());
                    BufferedInputStream bufIn = new BufferedInputStream(ref.getFilePathAsURL().openStream());
                    byte[] buf = new byte[1024];
                    int bufNum = 0;
                    while ((bufNum = bufIn.read(buf)) != -1) {
                        outBinary.write(buf, 0, bufNum);
                    }
                    bufIn.close();
                } else {
                    logger.warn("Not miniseed: " + ref.getFileType());
                    PrintWriter writer = resp.getWriter();
                    JSONWriter out = new JSONWriter((Appendable)writer);
                    JsonApi.encodeError(out, "Waveform data not miniseed: " + ref.getFileType());
                    resp.sendError(500);
                    writer.close();
                }
            }
            catch (UnsupportedFileTypeException e) {
                throw new RuntimeException("Should never happen", e);
            }
            outBinary.flush();
        } else if (waveformMatcher.matches()) {
            WebAdmin.setJsonHeader(req, resp);
            PrintWriter writer = resp.getWriter();
            JSONWriter out = new JSONWriter((Appendable)writer);
            EventSeismogramFileReference ref = this.getSeisRef(waveformMatcher.group(1));
            WaveformJson jsonData = new WaveformJson(ref, WebAdmin.getApiBaseUrl());
            JsonApi.encodeJson(out, jsonData);
            writer.close();
        } else {
            PrintWriter writer = resp.getWriter();
            JSONWriter out = new JSONWriter((Appendable)writer);
            JsonApi.encodeError(out, "url does not match " + this.mseedPattern.pattern());
            resp.sendError(500);
            writer.close();
        }
        AbstractHibernateDB.rollback();
    }

    EventSeismogramFileReference getSeisRef(String dbid) {
        Query q = AbstractHibernateDB.getSession().createQuery("from " + EventSeismogramFileReference.class.getName() + " where dbid = " + dbid);
        EventSeismogramFileReference ref = (EventSeismogramFileReference)q.uniqueResult();
        return ref;
    }
}

