/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.BaseNodeType;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.bag.TauPUtil;
import edu.sc.seis.sod.hibernate.EventDB;
import edu.sc.seis.sod.hibernate.NetworkDB;
import edu.sc.seis.sod.hibernate.NotFound;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.NoPreferredOrigin;
import edu.sc.seis.sod.model.station.NetworkIdUtil;
import edu.sc.seis.sod.web.NetworkServlet;
import edu.sc.seis.sod.web.WebAdmin;
import edu.sc.seis.sod.web.jsonapi.JsonApi;
import edu.sc.seis.sod.web.jsonapi.JsonApiData;
import edu.sc.seis.sod.web.jsonapi.TauPJson;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TauPServlet
extends HttpServlet {
    Pattern netStaCodePattern = Pattern.compile(NetworkServlet.networkIdStationCodeStr);
    public static final String MODEL = "model";
    public static final String EVDEPTH = "evdepth";
    public static final String PHASES = "phases";
    public static final String[] DEFAULT_PHASES = new String[]{"p", "s", "P", "S"};
    public static final String DISTDEG = "distdeg";
    public static final String STATION = "station";
    public static final String EVENT = "event";
    private static final Logger logger = LoggerFactory.getLogger(TauPServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String URL2 = req.getRequestURL().toString();
            logger.info("GET: " + URL2);
            WebAdmin.setJsonHeader(req, resp);
            PrintWriter writer = resp.getWriter();
            JSONWriter out = new JSONWriter((Appendable)writer);
            Map params = req.getParameterMap();
            TauPUtil taup = params.containsKey(MODEL) ? TauPUtil.getTauPUtil(((String[])params.get(MODEL))[0]) : TauPUtil.getTauPUtil();
            double depth = 0.0;
            if (params.containsKey(EVDEPTH)) {
                depth = Double.parseDouble(((String[])params.get(EVDEPTH))[0]);
            }
            String[] phases = DEFAULT_PHASES;
            if (params.containsKey(PHASES)) {
                phases = ((String[])params.get(PHASES))[0].split(",");
            }
            if (params.containsKey(DISTDEG)) {
                double distDeg = Double.parseDouble(((String[])params.get(DISTDEG))[0]);
                List<Arrival> arrivalList = taup.calcTravelTimes(distDeg, depth, phases);
                this.encodeArrivalsList(out, arrivalList);
            } else if (params.containsKey(STATION) && params.containsKey(EVENT)) {
                Station sta = null;
                Matcher staMatcher = this.netStaCodePattern.matcher(((String[])params.get(STATION))[0]);
                if (staMatcher.matches()) {
                    String netCode = staMatcher.group(1);
                    String year = staMatcher.group(2);
                    String staCode = staMatcher.group(3);
                    List<Station> staList = NetworkDB.getSingleton().getStationByCodes(netCode, staCode);
                    if (year == null && !NetworkIdUtil.isTemporary(netCode)) {
                        sta = staList.get(0);
                    } else if (year == null) {
                        JsonApi.encodeError(out, "temp netcode requires code_year: " + URL2);
                        writer.close();
                        resp.sendError(500);
                    } else {
                        Instant netBegin = TimeUtils.parseISOString((String)(year + "1231T23:59:59.000Z"));
                        for (Station stationImpl : staList) {
                            TimeRange staTR = new TimeRange((BaseNodeType)stationImpl);
                            if (!staTR.contains(netBegin)) continue;
                            sta = stationImpl;
                        }
                    }
                    if (sta == null) {
                        JsonApi.encodeError(out, "station not found: " + URL2);
                        writer.close();
                        resp.sendError(500);
                    }
                } else {
                    int stationDbid = Integer.parseInt(((String[])params.get(STATION))[0]);
                    sta = NetworkDB.getSingleton().getStation(stationDbid);
                }
                int eventDbid = Integer.parseInt(((String[])params.get(EVENT))[0]);
                CacheEvent evt = EventDB.getSingleton().getEvent(eventDbid);
                List<Arrival> arrivalList = taup.calcTravelTimes(sta, evt.getPreferred(), phases);
                this.encodeArrivalsList(out, arrivalList);
            } else {
                logger.warn("Bad URL for servlet: " + URL2);
                JsonApi.encodeError(out, "bad url for servlet: " + URL2);
                writer.close();
                resp.sendError(500);
            }
            writer.close();
        }
        catch (TauPException e) {
            throw new ServletException((Throwable)e);
        }
        catch (JSONException e) {
            throw new ServletException((Throwable)e);
        }
        catch (NumberFormatException e) {
            throw new ServletException((Throwable)e);
        }
        catch (NotFound e) {
            throw new ServletException((Throwable)e);
        }
        catch (NoPreferredOrigin e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            NetworkDB.rollback();
        }
    }

    private void encodeArrivalsList(JSONWriter out, List<Arrival> arrivalList) {
        ArrayList<JsonApiData> jsonList = new ArrayList<JsonApiData>();
        for (Arrival arrival : arrivalList) {
            jsonList.add(new TauPJson(arrival, WebAdmin.getApiBaseUrl()));
        }
        JsonApi.encodeJson(out, jsonList);
    }
}

