/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web;

import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.StatefulEventDB;
import edu.sc.seis.sod.hibernate.eventpair.EventChannelPair;
import edu.sc.seis.sod.hibernate.eventpair.EventNetworkPair;
import edu.sc.seis.sod.hibernate.eventpair.EventStationPair;
import edu.sc.seis.sod.hibernate.eventpair.EventVectorPair;
import edu.sc.seis.sod.model.event.StatefulEvent;
import edu.sc.seis.sod.model.status.Stage;
import edu.sc.seis.sod.model.status.Standing;
import edu.sc.seis.sod.status.eventArm.EventMonitor;
import edu.sc.seis.sod.status.waveformArm.WaveformMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuccessfulEventCache {
    List<StatefulEvent> eventWithSuccessfulCache = new ArrayList<StatefulEvent>();
    HashMap<StatefulEvent, Integer> numSuccessful = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(SuccessfulEventCache.class);

    public SuccessfulEventCache() {
        Timer t = new Timer("SuccessfulEventCache updater", true);
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    SuccessfulEventCache.this.updateSuccessfulEvents();
                }
                catch (Throwable t) {
                    logger.error("SuccessfulEventCache Trying to update seccessful events", t);
                }
            }
        }, 1000L, 90000L);
        if (Start.getEventArm() != null) {
            Start.getEventArm().add(new EventMonitor(){

                @Override
                public void setArmStatus(String status) throws Exception {
                }

                @Override
                public void change(StatefulEvent event) {
                    if (event.getStatus().getStanding().equals(Standing.SUCCESS) && event.getStatus().getStage().equals(Stage.EVENT_CHANNEL_POPULATION)) {
                        SuccessfulEventCache.this.updateInCache(event);
                    }
                }
            });
        }
        if (Start.getWaveformRecipe() != null) {
            Start.getWaveformRecipe().addStatusMonitor(new WaveformMonitor(){

                @Override
                public void update(EventVectorPair evp) {
                    logger.info("SuccessfulEventCache update: " + String.valueOf(evp.getStatus()) + " ");
                    if (evp.getStatus().getStanding().equals(Standing.SUCCESS)) {
                        if (!SuccessfulEventCache.this.eventInList(evp.getEvent())) {
                            SuccessfulEventCache.this.eventWithSuccessfulCache.add(evp.getEvent());
                        } else {
                            logger.info("SuccessfulEventCache Not adding as already added: " + String.valueOf(evp));
                        }
                    } else {
                        logger.info("SuccessfulEventCache Not adding as not SUCCESS: " + String.valueOf(evp));
                    }
                }

                @Override
                public void update(EventChannelPair ecp) {
                    logger.info("SuccessfulEventCache update: " + String.valueOf(ecp.getStatus()) + " ");
                    if (ecp.getStatus().getStanding().equals(Standing.SUCCESS)) {
                        if (!SuccessfulEventCache.this.eventInList(ecp.getEvent())) {
                            SuccessfulEventCache.this.eventWithSuccessfulCache.add(ecp.getEvent());
                        } else {
                            logger.info("SuccessfulEventCache Not adding as already added: " + String.valueOf(ecp));
                        }
                    } else {
                        logger.info("SuccessfulEventCache Not adding as not SUCCESS: " + String.valueOf(ecp));
                    }
                }

                @Override
                public void update(EventStationPair ecp) {
                    logger.info("SuccessfulEventCache EventStationPair update: " + String.valueOf(ecp));
                }

                @Override
                public void update(EventNetworkPair ecp) {
                    logger.info("SuccessfulEventCache EventNetworkPair update: " + String.valueOf(ecp));
                }
            });
        }
    }

    public List<StatefulEvent> getEventWithSuccessful() {
        return this.eventWithSuccessfulCache;
    }

    public int getNumSuccessful(StatefulEvent statefulEvent) {
        if (statefulEvent == null) {
            throw new RuntimeException("statefulEvent should not be null");
        }
        Integer out = this.numSuccessful.get(statefulEvent);
        if (out == null) {
            return 0;
        }
        return out;
    }

    void updateSuccessfulEvents() {
        logger.info("SuccessfulEventCache.updateSuccessfulEvents()");
        StatefulEventDB db = StatefulEventDB.getSingleton();
        List<StatefulEvent> events = db.getAll();
        Iterator<StatefulEvent> iterator = events.iterator();
        while (iterator.hasNext()) {
            StatefulEvent statefulEvent = iterator.next();
            int numSuccess = SodDB.getSingleton().getNumSuccessful(statefulEvent);
            if (numSuccess == 0) {
                iterator.remove();
                continue;
            }
            this.numSuccessful.put(statefulEvent, numSuccess);
        }
        this.eventWithSuccessfulCache = events;
    }

    void updateInCache(StatefulEvent statefulEvent) {
        logger.info("SuccessfulEventCache.updateInCache(" + String.valueOf(statefulEvent));
        int numSuccess = SodDB.getSingleton().getNumSuccessful(statefulEvent);
        if (numSuccess > 0) {
            logger.info("SuccessfulEventCache.updateInCache(" + String.valueOf(statefulEvent) + " " + numSuccess + " successful");
            this.eventWithSuccessfulCache.add(statefulEvent);
        } else {
            logger.info("SuccessfulEventCache.updateInCache(" + String.valueOf(statefulEvent) + " none successful");
        }
    }

    boolean eventInList(StatefulEvent e) {
        for (StatefulEvent statefulEvent : this.eventWithSuccessfulCache) {
            if (statefulEvent.getDbid() != e.getDbid()) continue;
            return true;
        }
        return false;
    }
}

