/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.hibernate.NetworkDB;
import edu.sc.seis.sod.hibernate.NotFound;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.eventpair.AbstractEventChannelPair;
import edu.sc.seis.sod.hibernate.eventpair.EventStationPair;
import edu.sc.seis.sod.web.NetworkServlet;
import edu.sc.seis.sod.web.WebAdmin;
import edu.sc.seis.sod.web.jsonapi.EventStationJson;
import edu.sc.seis.sod.web.jsonapi.JsonApi;
import edu.sc.seis.sod.web.jsonapi.JsonApiData;
import edu.sc.seis.sod.web.jsonapi.stationxml.ChannelJson;
import edu.sc.seis.sod.web.jsonapi.stationxml.StationJson;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StationsServlet
extends HttpServlet {
    Pattern stationDbidPattern = Pattern.compile(".*/stations/([0-9]+)");
    Pattern stationPattern = Pattern.compile(".*" + NetworkServlet.stationIdPatternStr);
    Pattern stationEventsPattern = Pattern.compile(".*" + NetworkServlet.stationIdPatternStr + "/quakes");
    Pattern stationChannelsPattern = Pattern.compile(".*" + NetworkServlet.stationIdPatternStr + "/channels");
    private static final Logger logger = LoggerFactory.getLogger(StationsServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block18: {
            String URL2 = req.getRequestURL().toString();
            logger.info("GET: " + URL2);
            WebAdmin.setJsonHeader(req, resp);
            PrintWriter writer = resp.getWriter();
            JSONWriter out = new JSONWriter((Appendable)writer);
            try {
                NetworkDB netdb = NetworkDB.getSingleton();
                Matcher matcher = this.stationPattern.matcher(URL2);
                if (matcher.matches()) {
                    String netCode = matcher.group(1);
                    String year = matcher.group(2);
                    String staCode = matcher.group(3);
                    logger.info("before db get " + netCode + "." + staCode);
                    List<Station> staList = netdb.getStationByCodes(netCode, staCode);
                    logger.info("after db get " + netCode + "." + staCode);
                    if (staList.size() > 0) {
                        Station sta = staList.get(0);
                        JsonApi.encodeJson(out, new StationJson(sta, WebAdmin.getApiBaseUrl()));
                        resp.setStatus(200);
                    } else {
                        resp.setStatus(404);
                        writer.println("No station with code " + netCode + "." + staCode + " found");
                    }
                    break block18;
                }
                matcher = this.stationDbidPattern.matcher(URL2);
                if (matcher.matches()) {
                    String dbid = matcher.group(1);
                    Station sta = null;
                    try {
                        sta = netdb.getStation(Integer.parseInt(dbid));
                        List<Channel> chans = netdb.getChannelsForStation(sta);
                        if (sta != null) {
                            JsonApi.encodeJson(out, new StationJson(sta, chans, WebAdmin.getApiBaseUrl()));
                            resp.setStatus(200);
                            break block18;
                        }
                        JsonApi.encodeError(out, "Station is null for dbid " + dbid);
                    }
                    catch (NumberFormatException e) {
                        JsonApi.encodeError(out, "NumberFormatException " + e.getMessage());
                    }
                    catch (NotFound e) {
                        JsonApi.encodeError(out, "NotFound " + e.getMessage());
                    }
                    break block18;
                }
                matcher = this.stationEventsPattern.matcher(URL2);
                if (matcher.matches()) {
                    String netCode = matcher.group(1);
                    String year = matcher.group(2);
                    String staCode = matcher.group(3);
                    Station sta = netdb.getStationByCodes(netCode, staCode).get(0);
                    List<AbstractEventChannelPair> ecpList = SodDB.getSingleton().getSuccessful(sta);
                    ArrayList<EventStationPair> eventList = new ArrayList<EventStationPair>();
                    for (AbstractEventChannelPair abstractEventChannelPair : ecpList) {
                        if (eventList.contains(abstractEventChannelPair.getEsp())) continue;
                        eventList.add(abstractEventChannelPair.getEsp());
                    }
                    ArrayList<JsonApiData> jsonData = new ArrayList<JsonApiData>(eventList.size());
                    for (EventStationPair esp : eventList) {
                        jsonData.add(new EventStationJson(esp, WebAdmin.getApiBaseUrl()));
                    }
                    JsonApi.encodeJson(out, jsonData);
                    resp.setStatus(200);
                } else {
                    matcher = this.stationChannelsPattern.matcher(URL2);
                    if (matcher.matches()) {
                        String netCode = matcher.group(1);
                        String year = matcher.group(2);
                        String staCode = matcher.group(3);
                        Station sta = netdb.getStationByCodes(netCode, staCode).get(0);
                        List<Channel> chans = netdb.getChannelsForStation(sta);
                        ArrayList<JsonApiData> jsonData = new ArrayList<JsonApiData>(chans.size());
                        for (Channel channel : chans) {
                            jsonData.add(new ChannelJson(channel, WebAdmin.getApiBaseUrl()));
                        }
                        JsonApi.encodeJson(out, jsonData);
                        resp.setStatus(200);
                    } else {
                        logger.warn("bad url for servlet: regex=" + this.stationPattern.toString());
                        JsonApi.encodeError(out, "bad url for servlet: regex=" + this.stationPattern.toString());
                        resp.sendError(500);
                    }
                }
            }
            finally {
                logger.info("Done.");
                NetworkDB.rollback();
                writer.close();
            }
        }
    }
}

