/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web;

import edu.sc.seis.sod.SodConfig;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.web.WebAdmin;
import edu.sc.seis.sod.web.jsonapi.JsonApi;
import edu.sc.seis.sod.web.jsonapi.SodConfigJson;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SodConfigServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(SodConfigServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        SodConfig config = SodDB.getSingleton().getCurrentConfig();
        String URL2 = req.getRequestURL().toString();
        logger.info("GET: " + URL2);
        WebAdmin.setJsonHeader(req, resp);
        PrintWriter writer = resp.getWriter();
        JSONWriter out = new JSONWriter((Appendable)writer);
        JsonApi.encodeJson(out, new SodConfigJson(config, WebAdmin.getApiBaseUrl()));
        resp.setStatus(200);
        writer.close();
    }
}

