/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web;

import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.hibernate.NetworkDB;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.eventpair.EventStationPair;
import edu.sc.seis.sod.model.event.StatefulEvent;
import edu.sc.seis.sod.web.JsonToFileServlet;
import edu.sc.seis.sod.web.MeasurementToolServlet;
import edu.sc.seis.sod.web.SuccessfulEventCache;
import edu.sc.seis.sod.web.WebAdmin;
import edu.sc.seis.sod.web.jsonapi.EventStationJson;
import edu.sc.seis.sod.web.jsonapi.JsonApiDocument;
import edu.sc.seis.sod.web.jsonapi.JsonApiException;
import edu.sc.seis.sod.web.jsonapi.JsonApiResource;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import org.hibernate.query.Query;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerusalServlet
extends JsonToFileServlet {
    private static final String FIRST_ESP = "first";
    private static final String PREV_ESP = "prev";
    public static final String CURR_ESP = "curr";
    public static final String NEXT_ESP = "next";
    Pattern allPattern = Pattern.compile(".*/perusals");
    Pattern idPattern = Pattern.compile(".*/perusals/([-_a-zA-Z0-9]+)");
    Pattern filenamePattern = Pattern.compile("[-_a-zA-Z0-9]+");
    private String baseUrl;
    private File perusalDir;
    private static final JSONObject EMPTY_JSON = new JSONObject();
    public static final String KEY_PRIMARY_SORT = "primary-sort";
    public static final String KEY_STATION_SORT = "station-sort";
    public static final String KEY_EVENT_SORT = "quake-sort";
    public static final String KEY_SORT_BY_QUAKE = "quake";
    public static final String KEY_SORT_BY_STATION = "station";
    public static final String KEY_SORT_BY_TIME = "time";
    public static final String KEY_SORT_BY_DISTANCE = "distance";
    private static final Logger logger = LoggerFactory.getLogger(PerusalServlet.class);

    public PerusalServlet() {
        super(WebAdmin.getApiBaseUrl(), new File("jsonData"), "perusals");
    }

    protected int extractESP_dbid(JsonApiDocument jsonApiDocument) throws JsonApiException {
        if (jsonApiDocument == null) {
            return -1;
        }
        if (!jsonApiDocument.hasData()) {
            return -1;
        }
        JsonApiResource data = jsonApiDocument.getData();
        if (data == null) {
            return -1;
        }
        if (data.optId() == null) {
            return -1;
        }
        return Integer.parseInt(data.getId());
    }

    @Override
    protected void updateBeforeSave(JsonApiResource p) throws IOException, JsonApiException {
        try {
            this.updateNext(p);
            this.updateMeasurementPerusalLink(p);
        }
        catch (JSONException e) {
            System.err.println((Object)e);
            System.err.println(p.toString(2));
            logger.error("Error in updateBeforeSave: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    protected void updateAfterLoad(JsonApiDocument p) throws IOException, JsonApiException {
        JsonApiResource res = p.getData();
        JsonApiDocument curr = res.getRelationship(CURR_ESP);
        int currDbId = this.extractESP_dbid(curr);
        if (currDbId < 0) {
            this.updateNext(res);
        }
    }

    protected void updateMeasurementPerusalLink(JsonApiResource p) throws IOException, JSONException, JsonApiException {
        logger.info("updateMeasurementPerusalLink " + p.toString(2));
        String pId = p.getId();
        if (p.hasRelationship("tools")) {
            JsonApiDocument tools = p.getRelationship("tools");
            MeasurementToolServlet mtServlet = new MeasurementToolServlet();
            for (JsonApiResource mt : tools.getDataArray()) {
                logger.debug("Try to update perusal on " + mt.toString(2));
                String mId = mt.getId();
                logger.debug("Got mId: " + mId);
                JsonApiResource mObj = mtServlet.load(mId);
                logger.debug("Load MT " + mObj.toString(2));
                mObj.setRelationship("perusal", pId, "perusal");
                mtServlet.save(mObj);
            }
        }
    }

    protected void updateNext(JsonApiResource res) throws JsonApiException {
        System.out.println("updateNext: " + res.toString(2));
        JsonApiDocument first = res.getRelationship(FIRST_ESP);
        JsonApiDocument curr = res.getRelationship(CURR_ESP);
        JsonApiDocument prev = res.getRelationship(PREV_ESP);
        JsonApiDocument next = res.getRelationship(NEXT_ESP);
        System.err.println("curr data: " + String.valueOf(curr == null ? "null" : curr.getData()));
        int firstDbId = this.extractESP_dbid(first);
        int currDbId = this.extractESP_dbid(curr);
        int prevDbId = this.extractESP_dbid(prev);
        int nextDbId = this.extractESP_dbid(next);
        String primarySort = res.getAttributeString(KEY_PRIMARY_SORT, KEY_SORT_BY_QUAKE);
        String quakeSort = res.getAttributeString(KEY_EVENT_SORT, KEY_SORT_BY_TIME);
        String stationSort = res.getAttributeString(KEY_STATION_SORT, KEY_SORT_BY_DISTANCE);
        if (firstDbId > 0 && currDbId < 0 && prevDbId < 0 && nextDbId < 0) {
            prevDbId = firstDbId;
        }
        if (currDbId < 0) {
            if (prevDbId > 0) {
                EventStationPair currESP = this.findNext(prevDbId, primarySort, quakeSort, stationSort);
                if (currESP != null) {
                    EventStationJson esJson = new EventStationJson(currESP, this.baseUrl);
                    res.setRelationship(CURR_ESP, esJson.getId(), esJson.getType());
                    EventStationPair nextESP = this.findNext(currESP.getDbid(), primarySort, quakeSort, stationSort);
                    esJson = new EventStationJson(nextESP, this.baseUrl);
                    res.setRelationship(NEXT_ESP, esJson.getId(), esJson.getType());
                }
            } else if (nextDbId > 0) {
                EventStationPair currESP = this.findPrev(nextDbId, primarySort, quakeSort, stationSort);
                if (currESP != null) {
                    EventStationJson esJson = new EventStationJson(currESP, this.baseUrl);
                    res.setRelationship(CURR_ESP, esJson.getId(), esJson.getType());
                    EventStationPair prevESP = this.findPrev(currESP.getDbid(), primarySort, quakeSort, stationSort);
                    esJson = new EventStationJson(prevESP, this.baseUrl);
                    res.setRelationship(PREV_ESP, esJson.getId(), esJson.getType());
                }
            } else {
                EventStationPair currESP = this.findNext(-1L, primarySort, quakeSort, stationSort);
                if (currESP != null) {
                    EventStationJson esJson = new EventStationJson(currESP, this.baseUrl);
                    res.setRelationship(CURR_ESP, esJson.getId(), esJson.getType());
                    res.setRelationship(FIRST_ESP, esJson.getId(), esJson.getType());
                    EventStationPair nextESP = this.findNext(currESP.getDbid(), primarySort, quakeSort, stationSort);
                    esJson = new EventStationJson(nextESP, this.baseUrl);
                    res.setRelationship(NEXT_ESP, esJson.getId(), esJson.getType());
                } else {
                    logger.warn("Perusal is empty, can't find first " + res.getId());
                }
            }
        } else {
            EventStationPair prevESP;
            EventStationPair nextESP = this.findNext(currDbId, primarySort, quakeSort, stationSort);
            if (nextESP != null) {
                EventStationJson esJson = new EventStationJson(nextESP, this.baseUrl);
                res.setRelationship(NEXT_ESP, esJson.getId(), esJson.getType());
            }
            if ((prevESP = this.findPrev(currDbId, primarySort, quakeSort, stationSort)) != null) {
                EventStationJson esJson = new EventStationJson(prevESP, this.baseUrl);
                res.setRelationship(PREV_ESP, esJson.getId(), esJson.getType());
            }
        }
        System.out.println("Done updateNext: " + res.toString(2));
    }

    private JSONObject formJsonRelatedFromESP(EventStationJson esJson) {
        JSONObject currJSON = new JSONObject();
        JSONObject dataJSON = new JSONObject();
        dataJSON.put("type", (Object)esJson.getType());
        dataJSON.put("id", (Object)esJson.getId());
        currJSON.put("data", (Object)dataJSON);
        return currJSON;
    }

    private EventStationPair findPrev(long currDbId, String primarySort, String quakeSort, String stationSort) {
        EventStationPair prev = null;
        if (currDbId <= 0L) {
            prev = null;
        } else {
            String q = "from EventStationPair where dbid = " + currDbId;
            Query query = SodDB.getSession().createQuery(q);
            EventStationPair esp = (EventStationPair)query.uniqueResult();
            StatefulEvent currEvent = esp.getEvent();
            Station currStation = esp.getStation();
            List<EventStationPair> prevESPList = primarySort.equalsIgnoreCase(KEY_SORT_BY_QUAKE) ? SodDB.getSingleton().getSuccessfulESPForEvent(currEvent) : SodDB.getSingleton().getSuccessfulESPForStation(currStation);
            ListIterator<EventStationPair> iterator = prevESPList.listIterator(prevESPList.size());
            EventStationPair eventStationPair = null;
            while (iterator.hasPrevious() && (eventStationPair = iterator.previous()).getDbid() != currDbId) {
            }
            while (iterator.hasPrevious()) {
                prev = iterator.previous();
                if (SodDB.getSingleton().getNumSuccessful(prev.getEvent(), prev.getStation()) <= 0) continue;
                return prev;
            }
            prev = primarySort.equalsIgnoreCase(KEY_SORT_BY_QUAKE) ? this.getPrevPrimaryEvent(currEvent, quakeSort) : this.getPrevPrimaryStation(currStation, stationSort);
        }
        return prev;
    }

    private EventStationPair getPrevPrimaryEvent(StatefulEvent currEvent, String quakeSort) {
        if (currEvent == null) {
            return null;
        }
        SuccessfulEventCache cache = WebAdmin.getSuccessfulEventCache();
        List<StatefulEvent> events = cache.getEventWithSuccessful();
        ListIterator<StatefulEvent> staIt = events.listIterator(events.size());
        while (staIt.hasPrevious()) {
            StatefulEvent currS = null;
            currS = staIt.previous();
            if (currS.getDbid() != currEvent.getDbid()) continue;
            break;
        }
        while (staIt.hasPrevious()) {
            StatefulEvent s = staIt.previous();
            List<EventStationPair> prevESPList = SodDB.getSingleton().getSuccessfulESPForEvent(s);
            ListIterator<EventStationPair> espIt = prevESPList.listIterator(prevESPList.size());
            while (espIt.hasPrevious()) {
                EventStationPair nEsp = espIt.previous();
                if (SodDB.getSingleton().getNumSuccessful(nEsp.getEvent(), nEsp.getStation()) <= 0) continue;
                return nEsp;
            }
        }
        return null;
    }

    private EventStationPair getPrevPrimaryStation(Station currStation, String stationSort) {
        List<Station> allStationList = Arrays.asList(NetworkDB.getSingleton().getAllStations());
        if (currStation == null) {
            return null;
        }
        ListIterator<Station> staIt = allStationList.listIterator(allStationList.size());
        while (staIt.hasPrevious()) {
            Station currS = null;
            currS = staIt.previous();
            if (currS.getDbid() != currStation.getDbid()) continue;
            break;
        }
        while (staIt.hasPrevious()) {
            Station s = staIt.previous();
            List<EventStationPair> prevESPList = SodDB.getSingleton().getSuccessfulESPForStation(s);
            ListIterator<EventStationPair> espIt = prevESPList.listIterator(prevESPList.size());
            while (espIt.hasPrevious()) {
                EventStationPair nEsp = espIt.previous();
                if (SodDB.getSingleton().getNumSuccessful(nEsp.getEvent(), nEsp.getStation()) <= 0) continue;
                return nEsp;
            }
        }
        return null;
    }

    private EventStationPair findNext(long prevDbId, String primarySort, String quakeSort, String stationSort) {
        EventStationPair next = null;
        if (prevDbId <= 0L) {
            next = primarySort.equalsIgnoreCase(KEY_SORT_BY_QUAKE) ? this.getNextPrimaryEvent(null) : this.getNextPrimaryStation(null);
        } else {
            EventStationPair eventStationPair;
            String q = "from EventStationPair where dbid = " + prevDbId;
            Query query = SodDB.getSession().createQuery(q);
            EventStationPair esp = (EventStationPair)query.uniqueResult();
            StatefulEvent currEvent = esp.getEvent();
            Station currStation = esp.getStation();
            List<EventStationPair> nextESPList = primarySort.equalsIgnoreCase(KEY_SORT_BY_QUAKE) ? SodDB.getSingleton().getSuccessfulESPForEvent(currEvent) : SodDB.getSingleton().getSuccessfulESPForStation(currStation);
            Iterator<EventStationPair> iterator = nextESPList.iterator();
            while (iterator.hasNext() && (eventStationPair = iterator.next()).getDbid() != prevDbId) {
            }
            while (iterator.hasNext()) {
                next = iterator.next();
                if (SodDB.getSingleton().getNumSuccessful(next.getEvent(), next.getStation()) <= 0) continue;
                return next;
            }
            next = primarySort.equalsIgnoreCase(KEY_SORT_BY_QUAKE) ? this.getNextPrimaryEvent(currEvent) : this.getNextPrimaryStation(currStation);
        }
        return next;
    }

    private EventStationPair getNextPrimaryStation(Station currStation) {
        List<Station> allStationList = Arrays.asList(NetworkDB.getSingleton().getAllStations());
        Iterator<Station> staIt = allStationList.iterator();
        Station currS = null;
        while (currStation != null && staIt.hasNext() && (currS = staIt.next()).getDbid() != currStation.getDbid()) {
        }
        while (staIt.hasNext()) {
            Station s = staIt.next();
            List<EventStationPair> nextESPList = SodDB.getSingleton().getSuccessfulESPForStation(s);
            for (EventStationPair nEsp : nextESPList) {
                if (SodDB.getSingleton().getNumSuccessful(nEsp.getEvent(), nEsp.getStation()) <= 0) continue;
                return nEsp;
            }
        }
        return null;
    }

    private EventStationPair getNextPrimaryEvent(StatefulEvent currEvent) {
        StatefulEvent e;
        SuccessfulEventCache cache = WebAdmin.getSuccessfulEventCache();
        List<StatefulEvent> events = cache.getEventWithSuccessful();
        Iterator<StatefulEvent> eventIt = events.iterator();
        while (currEvent != null && eventIt.hasNext() && (e = eventIt.next()).getDbid() != currEvent.getDbid()) {
        }
        while (eventIt.hasNext()) {
            e = eventIt.next();
            List<EventStationPair> nextESPList = SodDB.getSingleton().getSuccessfulESPForEvent(e);
            for (EventStationPair nEsp : nextESPList) {
                if (SodDB.getSingleton().getNumSuccessful(nEsp.getEvent(), nEsp.getStation()) <= 0) continue;
                return nEsp;
            }
        }
        return null;
    }
}

