/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web;

import edu.sc.seis.sod.web.JsonToFileServlet;
import edu.sc.seis.sod.web.QuakeStationMeasurementsServlet;
import edu.sc.seis.sod.web.WebAdmin;
import edu.sc.seis.sod.web.jsonapi.JsonApiException;
import edu.sc.seis.sod.web.jsonapi.JsonApiResource;
import java.io.File;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasurementTextServlet
extends JsonToFileServlet {
    QuakeStationMeasurementsServlet qsMeasurement = new QuakeStationMeasurementsServlet();
    private static final Logger logger = LoggerFactory.getLogger(MeasurementTextServlet.class);

    public MeasurementTextServlet() {
        super(WebAdmin.getApiBaseUrl(), new File("jsonData"), "measurements");
    }

    @Override
    protected void save(JsonApiResource inJson) throws IOException {
        try {
            JSONArray knownMeas;
            String qsId;
            super.save(inJson);
            if (inJson.hasRelationship("quake-station")) {
                qsId = inJson.getRelationship("quake-station").getData().getId();
                knownMeas = this.qsMeasurement.loadArray(qsId);
                boolean found = false;
                for (Object subObj : knownMeas) {
                    if (subObj instanceof JSONObject) {
                        JsonApiResource res = new JsonApiResource((JSONObject)subObj);
                        if (!res.getId().equals(inJson.getId())) continue;
                        found = true;
                        break;
                    }
                    throw new JsonApiException("Array contains non-resource object: " + String.valueOf(subObj));
                }
                if (!found) {
                    JsonApiResource res = new JsonApiResource(inJson.getId(), this.jsonType);
                    knownMeas.put((Object)res.getWrapped());
                    this.qsMeasurement.save(qsId, knownMeas);
                }
            } else {
                throw new JSONException("relationship missing " + inJson.toString(2));
            }
            logger.debug("after save knownMeas from qs=" + qsId + "  len=" + knownMeas.length());
        }
        catch (JsonApiException e) {
            throw new IOException(e);
        }
    }
}

