/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web;

import edu.sc.seis.sod.hibernate.NetworkDB;
import edu.sc.seis.sod.web.WebAdmin;
import edu.sc.seis.sod.web.jsonapi.JsonApi;
import edu.sc.seis.sod.web.jsonapi.JsonApiDocument;
import edu.sc.seis.sod.web.jsonapi.JsonApiException;
import edu.sc.seis.sod.web.jsonapi.JsonApiResource;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonToFileServlet
extends HttpServlet {
    String jsonType;
    Pattern allPattern;
    Pattern idPattern;
    Pattern filenamePattern = Pattern.compile("[-_a-zA-Z0-9]+");
    private String baseUrl;
    private File baseDir;
    private File jsonDir;
    boolean isArrayType;
    private static final JSONObject EMPTY_JSON = new JSONObject();
    private static final Logger logger = LoggerFactory.getLogger(JsonToFileServlet.class);

    public JsonToFileServlet(String baseUrl, File baseDir, String jsonType) {
        this.baseUrl = baseUrl;
        this.baseDir = baseDir;
        this.jsonType = jsonType;
        this.allPattern = Pattern.compile(".*/" + jsonType);
        this.idPattern = Pattern.compile(".*/" + jsonType + "/([-_a-zA-Z0-9]+)");
        this.jsonDir = new File(baseDir, jsonType);
        if (!this.jsonDir.exists()) {
            this.jsonDir.mkdirs();
            logger.info("Create json Dir: " + this.jsonDir.getAbsolutePath());
        }
        this.isArrayType = false;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            PrintWriter writer;
            block18: {
                String URL2 = req.getRequestURL().toString();
                System.out.println("GET: " + URL2);
                logger.info("GET: " + URL2);
                WebAdmin.setJsonHeader(req, resp);
                writer = resp.getWriter();
                JSONWriter out = new JSONWriter((Appendable)writer);
                Matcher matcher = this.allPattern.matcher(URL2);
                if (matcher.matches()) {
                    List<String> jsonlIds = this.getAllJsonIds();
                    JsonApiDocument doc = JsonApiDocument.createEmptyArray();
                    for (String pId : jsonlIds) {
                        try {
                            JsonApiResource res = new JsonApiResource(pId, this.jsonType);
                            doc.append(res);
                        }
                        catch (JsonApiException e) {
                            JsonApi.encodeError(out, "Error in saved document: id=" + pId + " type=" + this.jsonType + " url:" + URL2);
                            writer.close();
                            resp.sendError(204);
                        }
                    }
                    writer.write(doc.toString(2));
                } else {
                    matcher = this.idPattern.matcher(URL2);
                    if (matcher.matches()) {
                        String pId = matcher.group(1);
                        try {
                            if (this.isArrayType && !this.exists(pId)) {
                                JsonApiDocument p = JsonApiDocument.createEmptyArray();
                                this.updateAfterLoad(p);
                                writer.print(p.toString(2));
                                break block18;
                            }
                            if (this.isArrayType) {
                                JSONArray jsonArr = this.loadArray(pId);
                                JsonApiDocument p = JsonApiDocument.createForArray(jsonArr);
                                this.updateAfterLoad(p);
                                writer.print(p.toString(2));
                                break block18;
                            }
                            JsonApiResource res = this.load(pId);
                            JsonApiDocument p = JsonApiDocument.createForResource(res);
                            this.updateAfterLoad(p);
                            writer.print(p.toString(2));
                        }
                        catch (FileNotFoundException e) {
                            JsonApi.encodeError(out, "Not Found: id=" + pId + " type=" + this.jsonType + " url:" + URL2);
                            writer.close();
                            resp.sendError(204);
                        }
                        catch (JsonApiException e) {
                            logger.warn("Error in saved document: id=" + pId + " type=" + this.jsonType + " url:" + URL2);
                            JsonApi.encodeError(out, "Error in saved document: id=" + pId + " type=" + this.jsonType + " url:" + URL2);
                            writer.close();
                            resp.sendError(204);
                        }
                    } else {
                        logger.warn("Bad URL for servlet: type=" + this.jsonType + " url:" + URL2);
                        JsonApi.encodeError(out, "bad url for servlet: type=" + this.jsonType + " url:" + URL2);
                        writer.close();
                        resp.sendError(500);
                    }
                }
            }
            writer.close();
        }
        catch (JSONException e) {
            throw new ServletException((Throwable)e);
        }
        catch (NumberFormatException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            NetworkDB.rollback();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String rawJson = null;
        try {
            JsonApiResource apiObj;
            WebAdmin.setJsonHeader(req, resp);
            String URL2 = req.getRequestURL().toString();
            rawJson = JsonApi.loadFromReader(req.getReader());
            JsonApiDocument jsonApiDoc = JsonApiDocument.parse(rawJson);
            logger.debug("POST: " + URL2 + "  " + jsonApiDoc.toString(2));
            if (!jsonApiDoc.hasData()) {
                logger.warn("Unable to parse JSON: " + rawJson);
                resp.sendError(400, "Unable to parse JSON");
                return;
            }
            if (jsonApiDoc.isDataArray()) {
                logger.error("Not yet impl save jsonApiDoc dataArray: " + jsonApiDoc.toString(2));
                resp.sendError(400, "Not yet impl save jsonApiDoc dataArray: ");
            }
            if (!(apiObj = jsonApiDoc.getData()).getType().equals(this.jsonType)) {
                resp.sendError(400, "type  wrong/missing: " + apiObj.getType() + " != " + this.jsonType);
                return;
            }
            logger.debug("POST: " + URL2 + "  type: " + apiObj.getType() + "  id: " + apiObj.optId());
            Matcher m = this.filenamePattern.matcher(apiObj.getId());
            if (!m.matches()) {
                resp.sendError(400, "Bad id: " + apiObj.getId());
                return;
            }
            this.updateBeforeSave(apiObj);
            this.save(apiObj);
            PrintWriter w = resp.getWriter();
            w.print(jsonApiDoc.toString(2));
            w.close();
            logger.debug("POST: " + URL2 + "  Done");
            return;
        }
        catch (JSONException e) {
            logger.warn("JSONException with: " + rawJson, (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (RuntimeException e) {
            logger.error("doPost ", (Throwable)e);
            throw e;
        }
        catch (JsonApiException e) {
            logger.warn("JsonApiException with: " + rawJson + " ", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPut(req, resp);
    }

    protected void doPatch(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block15: {
            WebAdmin.setJsonHeader(req, resp);
            String URL2 = req.getRequestURL().toString();
            System.out.println("JsonToFileServlet doPatch " + URL2);
            logger.debug("JsonToFileServlet doPatch " + URL2);
            Matcher matcher = this.idPattern.matcher(URL2);
            PrintWriter writer = resp.getWriter();
            JSONWriter out = new JSONWriter((Appendable)writer);
            try {
                if (matcher.matches()) {
                    String key;
                    String id = matcher.group(1);
                    JsonApiResource res = this.load(id);
                    JsonApiDocument inJson = JsonApiDocument.parse(JsonApi.loadFromReader(req.getReader()));
                    logger.info("patch: " + inJson.toString(2));
                    if (inJson.isDataArray()) {
                        JsonApi.encodeError(out, "can't PATCH data array: " + URL2);
                        writer.close();
                        resp.sendError(500);
                        return;
                    }
                    Iterator<String> iter = inJson.getData().attributeKeys();
                    while (iter.hasNext()) {
                        key = iter.next();
                        res.setAttribute(key, inJson.getData().getAttribute(key));
                    }
                    iter = inJson.getData().relationshipKeys();
                    while (iter.hasNext()) {
                        key = iter.next();
                        JsonApiDocument rel = inJson.getData().getRelationship(key);
                        logger.warn("doPatch Rel " + key + "  " + String.valueOf(rel));
                        if (rel == null) {
                            logger.info("doPatch rel is null");
                            res.setRelationshipNull(key);
                            continue;
                        }
                        if (rel.isDataArray()) {
                            res.deleteRelationship(key);
                            for (JsonApiResource relRes : rel.getDataArray()) {
                                String relId = relRes.getId();
                                String relType = relRes.getType();
                                res.appendRelationship(key, relId, relType);
                            }
                            continue;
                        }
                        if (rel.hasData()) {
                            String relId = rel.getData().getId();
                            String relType = rel.getData().getType();
                            res.setRelationship(key, relId, relType);
                            continue;
                        }
                        throw new RuntimeException("Shouldn't happen but did...");
                    }
                    logger.info("doPath after Rel: " + res.toString(2));
                    this.updateBeforeSave(res);
                    logger.info("doPath after updateBeforeSave: " + res.toString(2));
                    this.save(res);
                    writer.print(JsonApiDocument.createForResource(res).toString(2));
                    break block15;
                }
                logger.warn("Bad URL for servlet: " + URL2);
                JsonApi.encodeError(out, "bad url for servlet: " + URL2);
                writer.close();
                resp.sendError(500);
            }
            catch (JSONException e) {
                throw new ServletException((Throwable)e);
            }
            catch (JsonApiException e) {
                throw new ServletException((Throwable)e);
            }
            finally {
                writer.close();
                logger.debug("PATCH: " + URL2 + "  Done");
            }
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String URL2 = req.getRequestURL().toString();
            System.out.println("DELETE: " + URL2);
            logger.info("DELETE: " + URL2);
            Matcher matcher = this.idPattern.matcher(URL2);
            if (matcher.matches()) {
                String pId = matcher.group(1);
                File f = new File(this.jsonDir, pId);
                f.delete();
            }
            resp.setStatus(204);
            resp.getWriter().close();
            logger.info("DELETE: " + URL2 + " Done");
        }
        catch (JSONException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            if (req.getMethod().equals("PATCH")) {
                logger.debug("JsonToFileServlet.service PATCH");
                this.doPatch(req, resp);
            } else {
                super.service(req, resp);
            }
        }
        catch (ServletException e) {
            logger.error("problem ", (Throwable)e);
        }
    }

    protected List<String> getAllJsonIds() {
        return Arrays.asList(this.jsonDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                Matcher matcher = JsonToFileServlet.this.filenamePattern.matcher(name);
                return matcher.matches();
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(JsonApiResource inJson) throws IOException {
        try (BufferedWriter out = null;){
            File pFile = new File(this.jsonDir, inJson.getId());
            logger.debug("Save to " + pFile.getAbsolutePath());
            if (pFile.getAbsolutePath().contains("quakeStationMeasurements")) {
                logger.debug("json: " + inJson.toString(2));
            }
            if (pFile.exists()) {
                Files.move(pFile.toPath(), new File(this.jsonDir, inJson.getId() + ".old").toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            out = new BufferedWriter(new FileWriter(pFile));
            out.write(inJson.toString(2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(String id, JSONArray inJson) throws IOException {
        try (BufferedWriter out = null;){
            File pFile = new File(this.jsonDir, id);
            logger.debug("Save to " + pFile.getAbsolutePath());
            if (pFile.exists()) {
                Files.move(pFile.toPath(), new File(this.jsonDir, id + ".old").toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            out = new BufferedWriter(new FileWriter(pFile));
            out.write(inJson.toString(2));
        }
    }

    protected boolean exists(String id) {
        Matcher m = this.filenamePattern.matcher(id);
        if (m.matches()) {
            File f = new File(this.jsonDir, id);
            return f.exists();
        }
        throw new RuntimeException("json id does not match pattern: " + id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonApiResource load(String id) throws IOException, JSONException, JsonApiException {
        Matcher m = this.filenamePattern.matcher(id);
        if (m.matches()) {
            BufferedReader in = null;
            File f = new File(this.jsonDir, id);
            if (f.exists()) {
                logger.debug("Load from " + f.getAbsolutePath());
                in = new BufferedReader(new FileReader(f));
                JsonApiResource jsonApiResource = JsonApiResource.parse(JsonApi.loadFromReader(in));
                return jsonApiResource;
            }
            logger.debug("no file, createEmpty");
            JsonApiResource jsonApiResource = this.createEmpty(id);
            return jsonApiResource;
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        throw new RuntimeException("json id does not match pattern: " + id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSONArray loadArray(String id) throws IOException, JSONException, JsonApiException {
        Matcher m = this.filenamePattern.matcher(id);
        if (m.matches()) {
            BufferedReader in = null;
            File f = new File(this.jsonDir, id);
            if (f.exists()) {
                JSONArray out;
                logger.debug("Load from " + f.getAbsolutePath());
                in = new BufferedReader(new FileReader(f));
                JSONArray jSONArray = out = new JSONArray(JsonApi.loadFromReader(in));
                return jSONArray;
            }
            logger.debug("no file, createEmpty");
            JSONArray jSONArray = new JSONArray();
            return jSONArray;
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        throw new RuntimeException("json id does not match pattern: " + id);
    }

    protected JsonApiResource createEmpty(String id) throws FileNotFoundException {
        throw new FileNotFoundException("No data for id: " + id);
    }

    protected List<JsonApiResource> createEmptyArray(String id) {
        return new ArrayList<JsonApiResource>();
    }

    protected void updateBeforeSave(JsonApiResource jsonApiResource) throws IOException, JsonApiException {
    }

    protected void updateAfterLoad(JsonApiDocument jsonApiDocument) throws IOException, JsonApiException {
    }

    File getDirectory(JSONObject in) {
        return this.jsonDir;
    }
}

