/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.hibernate.AbstractHibernateDB;
import edu.sc.seis.sod.hibernate.EventSeismogramFileReference;
import edu.sc.seis.sod.hibernate.SeismogramFileRefDB;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.eventpair.AbstractEventChannelPair;
import edu.sc.seis.sod.hibernate.eventpair.EventChannelPair;
import edu.sc.seis.sod.hibernate.eventpair.EventVectorPair;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.web.WebAdmin;
import edu.sc.seis.sod.web.jsonapi.EventVectorJson;
import edu.sc.seis.sod.web.jsonapi.JsonApi;
import edu.sc.seis.sod.web.jsonapi.WaveformJson;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hibernate.query.Query;
import org.json.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventVectorServlet
extends HttpServlet {
    Pattern eventStationPattern = Pattern.compile(".*/quake-vectors/([0-9]+)");
    Pattern waveformPattern = Pattern.compile(".*/quake-vectors/([0-9]+)/waveforms");
    private static final Logger logger = LoggerFactory.getLogger(EventVectorServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String URL2 = req.getRequestURL().toString();
        logger.info("GET: " + URL2);
        PrintWriter writer = resp.getWriter();
        JSONWriter out = new JSONWriter((Appendable)writer);
        Matcher m = this.eventStationPattern.matcher(URL2);
        Matcher waveformMatcher = this.waveformPattern.matcher(URL2);
        if (waveformMatcher.matches()) {
            WebAdmin.setJsonHeader(req, resp);
            AbstractEventChannelPair ecp = this.getECP(waveformMatcher.group(1));
            Channel[] chans = ecp instanceof EventVectorPair ? ((EventVectorPair)ecp).getChannelGroup().getChannels() : new Channel[]{((EventChannelPair)ecp).getChannel()};
            ArrayList<EventSeismogramFileReference> seisRefList = new ArrayList<EventSeismogramFileReference>();
            for (int j = 0; j < chans.length; ++j) {
                seisRefList.addAll(SeismogramFileRefDB.getSingleton().getSeismogramsForEventForChannel((CacheEvent)ecp.getEvent(), chans[j]));
            }
            JsonApi.encodeJson(out, WaveformJson.toJsonList(seisRefList, WebAdmin.getApiBaseUrl()));
        } else if (m.matches()) {
            WebAdmin.setJsonHeader(req, resp);
            AbstractEventChannelPair ecp = this.getECP(m.group(1));
            EventVectorJson jsonData = new EventVectorJson(ecp, WebAdmin.getApiBaseUrl());
            JsonApi.encodeJson(out, jsonData);
        } else {
            logger.warn("Bad URL for servlet: " + URL2);
            JsonApi.encodeError(out, "bad url for servlet: " + URL2);
            resp.sendError(500);
        }
        writer.close();
        AbstractHibernateDB.rollback();
    }

    AbstractEventChannelPair getECP(String dbid) {
        Query q = AbstractHibernateDB.getSession().createQuery("from " + SodDB.getSingleton().getEcpClass().getName() + " where dbid = " + dbid);
        AbstractEventChannelPair esp = (AbstractEventChannelPair)q.uniqueResult();
        return esp;
    }
}

