/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web;

import edu.sc.seis.sod.hibernate.AbstractHibernateDB;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.eventpair.AbstractEventChannelPair;
import edu.sc.seis.sod.hibernate.eventpair.EventStationPair;
import edu.sc.seis.sod.model.status.Stage;
import edu.sc.seis.sod.model.status.Standing;
import edu.sc.seis.sod.web.QuakeStationMeasurementsServlet;
import edu.sc.seis.sod.web.WebAdmin;
import edu.sc.seis.sod.web.jsonapi.EventStationJson;
import edu.sc.seis.sod.web.jsonapi.EventVectorJson;
import edu.sc.seis.sod.web.jsonapi.JsonApi;
import edu.sc.seis.sod.web.jsonapi.JsonApiData;
import edu.sc.seis.sod.web.jsonapi.JsonApiDocument;
import edu.sc.seis.sod.web.jsonapi.JsonApiException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hibernate.query.Query;
import org.json.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventStationServlet
extends HttpServlet {
    Pattern eventStationPattern = Pattern.compile(".*/quake-stations/([0-9]+)");
    Pattern eventVectorPattern = Pattern.compile(".*/quake-stations/([0-9]+)/quake-vectors");
    Pattern measurementsPattern = Pattern.compile(".*/quake-stations/([0-9]+)/measurements");
    QuakeStationMeasurementsServlet measurementServlet = new QuakeStationMeasurementsServlet();
    private static final Logger logger = LoggerFactory.getLogger(EventStationServlet.class);

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getMethod().equals("PATCH")) {
            this.doPatch(req, resp);
        } else {
            super.service(req, resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String URL2 = req.getRequestURL().toString();
        logger.info("GET: " + URL2);
        WebAdmin.setJsonHeader(req, resp);
        PrintWriter writer = resp.getWriter();
        JSONWriter out = new JSONWriter((Appendable)writer);
        Matcher m = this.eventStationPattern.matcher(URL2);
        try {
            if (m.matches()) {
                Query q = AbstractHibernateDB.getSession().createQuery("from " + EventStationPair.class.getName() + " where dbid = " + m.group(1));
                EventStationPair esp = (EventStationPair)q.uniqueResult();
                if (esp == null) {
                    JsonApi.encodeError(out, "esp not found " + m.group(1));
                    writer.close();
                    resp.sendError(500);
                }
                q = AbstractHibernateDB.getSession().createQuery("from " + SodDB.getSingleton().getEcpClass().getName() + " where esp = " + esp.getDbid() + "  and status.stageInt = " + Stage.PROCESSOR.getVal() + " and status.standingInt = " + Standing.SUCCESS.getVal());
                ArrayList<AbstractEventChannelPair> ecpList = new ArrayList<AbstractEventChannelPair>();
                List tmp = q.list();
                for (Object obj : tmp) {
                    if (obj == null) {
                        throw new RuntimeException("obj from hibernate is null");
                    }
                    ecpList.add((AbstractEventChannelPair)obj);
                }
                EventStationJson jsonData = new EventStationJson(esp, ecpList, WebAdmin.getApiBaseUrl());
                JsonApi.encodeJson(out, jsonData);
            } else {
                m = this.eventVectorPattern.matcher(URL2);
                if (m.matches()) {
                    Query q = AbstractHibernateDB.getSession().createQuery("from " + SodDB.getSingleton().getEcpClass().getName() + " where esp = " + m.group(1) + "  and status.stageInt = " + Stage.PROCESSOR.getVal() + " and status.standingInt = " + Standing.SUCCESS.getVal());
                    ArrayList<JsonApiData> jsonData = new ArrayList<JsonApiData>();
                    List tmp = q.list();
                    for (Object obj : tmp) {
                        if (obj == null) {
                            throw new RuntimeException("obj from hibernate is null");
                        }
                        jsonData.add(new EventVectorJson((AbstractEventChannelPair)obj, WebAdmin.getApiBaseUrl()));
                    }
                    JsonApi.encodeJson(out, jsonData);
                } else {
                    m = this.measurementsPattern.matcher(URL2);
                    if (m.matches()) {
                        this.measurementServlet.doGet(req, resp);
                    } else {
                        logger.warn("url does not match " + this.eventStationPattern.pattern());
                        JsonApi.encodeError(out, "url does not match " + this.eventStationPattern.pattern());
                        writer.close();
                        resp.sendError(500);
                    }
                }
            }
        }
        finally {
            logger.info("Done.");
            writer.close();
            AbstractHibernateDB.rollback();
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String URL2 = req.getRequestURL().toString();
        System.out.println("doPost " + URL2);
        Matcher matcher = this.measurementsPattern.matcher(URL2);
        if (matcher.matches()) {
            logger.debug("EventStationServlet, measurements pattern matches, pass on to measurements servlet doPost: " + URL2);
            this.measurementServlet.doPost(req, resp);
        } else {
            logger.warn("url does not match " + this.measurementsPattern.pattern());
            PrintWriter writer = resp.getWriter();
            JSONWriter out = new JSONWriter((Appendable)writer);
            JsonApi.encodeError(out, "EventStationServlet: url does not match " + this.measurementsPattern.pattern());
            writer.close();
            resp.sendError(500);
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String URL2 = req.getRequestURL().toString();
        System.out.println("doPut " + URL2);
        Matcher matcher = this.measurementsPattern.matcher(URL2);
        if (matcher.matches()) {
            logger.debug("EventStationServlet, measurements pattern matches, pass on to measurements servlet doPut: " + URL2);
            this.measurementServlet.doPut(req, resp);
        } else {
            logger.warn("url does not match " + this.measurementsPattern.pattern());
            PrintWriter writer = resp.getWriter();
            JSONWriter out = new JSONWriter((Appendable)writer);
            JsonApi.encodeError(out, "EventStationServlet: url does not match " + this.measurementsPattern.pattern());
            writer.close();
            resp.sendError(500);
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String URL2 = req.getRequestURL().toString();
        System.out.println("doDelete " + URL2);
        Matcher matcher = this.measurementsPattern.matcher(URL2);
        if (matcher.matches()) {
            logger.debug("EventStationServlet, measurements pattern matches, pass on to measurements servlet doDelete: " + URL2);
            this.measurementServlet.doDelete(req, resp);
        } else {
            logger.warn("url does not match " + this.measurementsPattern.pattern());
            PrintWriter writer = resp.getWriter();
            JSONWriter out = new JSONWriter((Appendable)writer);
            JsonApi.encodeError(out, "EventStationServlet: url does not match " + this.measurementsPattern.pattern());
            writer.close();
            resp.sendError(500);
        }
    }

    protected void doPatch(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        WebAdmin.setJsonHeader(req, resp);
        String URL2 = req.getRequestURL().toString();
        System.out.println("doPatch " + URL2);
        logger.debug("doPatch " + URL2);
        Matcher matcher = this.eventStationPattern.matcher(URL2);
        PrintWriter writer = resp.getWriter();
        JSONWriter out = new JSONWriter((Appendable)writer);
        try {
            if (matcher.matches()) {
                String id = matcher.group(1);
                logger.debug("eventStationPattern match: " + URL2 + " id: " + id);
                Query q = AbstractHibernateDB.getSession().createQuery("from " + EventStationPair.class.getName() + " where dbid = " + matcher.group(1));
                EventStationPair esp = (EventStationPair)q.uniqueResult();
                if (esp == null) {
                    logger.debug("Can't find ESP for id " + id);
                    JsonApi.encodeError(out, "esp not found " + matcher.group(1));
                    writer.close();
                    resp.sendError(500);
                }
                JsonApiDocument inJson = JsonApiDocument.parse(JsonApi.loadFromReader(req.getReader()));
                writer.print(inJson.toString(2));
            } else {
                matcher = this.measurementsPattern.matcher(URL2);
                if (matcher.matches()) {
                    logger.debug("EventStationServlet, measurements pattern matches, pass on to measurements servlet doPatch: " + URL2);
                    this.measurementServlet.doPatch(req, resp);
                } else {
                    logger.warn("url does not match " + this.eventStationPattern.pattern());
                    JsonApi.encodeError(out, "EventStationServlet: url does not match " + this.eventStationPattern.pattern());
                    writer.close();
                    resp.sendError(500);
                }
            }
        }
        catch (JsonApiException e) {
            logger.error("doPatch: ", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (Throwable t) {
            logger.error("doPatch: ", t);
            throw t;
        }
        finally {
            writer.close();
        }
    }
}

