/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web;

import edu.sc.seis.sod.hibernate.NotFound;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.StatefulEventDB;
import edu.sc.seis.sod.hibernate.eventpair.AbstractEventChannelPair;
import edu.sc.seis.sod.hibernate.eventpair.EventStationPair;
import edu.sc.seis.sod.model.event.StatefulEvent;
import edu.sc.seis.sod.web.SuccessfulEventCache;
import edu.sc.seis.sod.web.WebAdmin;
import edu.sc.seis.sod.web.jsonapi.EventJson;
import edu.sc.seis.sod.web.jsonapi.EventStationJson;
import edu.sc.seis.sod.web.jsonapi.JsonApi;
import edu.sc.seis.sod.web.jsonapi.JsonApiData;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventServlet
extends HttpServlet {
    Pattern allEvents = Pattern.compile(".*/quakes");
    Pattern singleEvent = Pattern.compile(".*/quakes/([0-9]+)");
    Pattern eventStations = Pattern.compile(".*/quakes/([0-9]+)/stations");
    private static final Logger logger = LoggerFactory.getLogger(EventServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block17: {
            String URL2 = req.getRequestURL().toString();
            logger.info("GET: " + URL2);
            String refresh = req.getParameter("refresh");
            boolean forceRefresh = refresh != null && refresh.equalsIgnoreCase("true");
            Matcher matcher = this.singleEvent.matcher(URL2);
            WebAdmin.setJsonHeader(req, resp);
            PrintWriter writer = resp.getWriter();
            JSONWriter out = new JSONWriter((Appendable)writer);
            try {
                if (matcher.matches()) {
                    String dbid = matcher.group(1);
                    try {
                        StatefulEvent e = StatefulEventDB.getSingleton().getEvent(Integer.parseInt(dbid));
                        JsonApi.encodeJson(out, new EventJson(e, WebAdmin.getApiBaseUrl()));
                        break block17;
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException(e);
                    }
                    catch (NotFound e) {
                        throw new RuntimeException(e);
                    }
                }
                matcher = this.eventStations.matcher(URL2);
                if (matcher.matches()) {
                    int dbid = Integer.parseInt(matcher.group(1));
                    try {
                        StatefulEvent event = StatefulEventDB.getSingleton().getEvent(dbid);
                        List<AbstractEventChannelPair> ecpList = SodDB.getSingleton().getSuccessful(event);
                        ArrayList<EventStationPair> espList = new ArrayList<EventStationPair>();
                        for (AbstractEventChannelPair abstractEventChannelPair : ecpList) {
                            if (espList.contains(abstractEventChannelPair.getEsp())) continue;
                            espList.add(abstractEventChannelPair.getEsp());
                        }
                        logger.info("GET: " + URL2 + " found " + espList.size() + " successful quake-station-pairs");
                        ArrayList<JsonApiData> jsonData = new ArrayList<JsonApiData>(espList.size());
                        for (EventStationPair esp : espList) {
                            jsonData.add(new EventStationJson(esp, WebAdmin.getApiBaseUrl()));
                        }
                        JsonApi.encodeJson(out, jsonData);
                        break block17;
                    }
                    catch (NotFound e) {
                        throw new RuntimeException(e);
                    }
                }
                matcher = this.allEvents.matcher(URL2);
                if (matcher.matches()) {
                    logger.debug("doGet all");
                    try {
                        SuccessfulEventCache cache = WebAdmin.getSuccessfulEventCache();
                        if (forceRefresh) {
                            cache.updateSuccessfulEvents();
                        }
                        List<StatefulEvent> events = cache.getEventWithSuccessful();
                        logger.info("EventServlet: found " + events.size() + " events");
                        ArrayList<JsonApiData> eventJsonList = new ArrayList<JsonApiData>();
                        for (StatefulEvent statefulEvent : events) {
                            EventJson eventJson = new EventJson(statefulEvent, WebAdmin.getApiBaseUrl());
                            eventJson.setNumSuccessfulStations(cache.getNumSuccessful(statefulEvent));
                            eventJsonList.add(eventJson);
                        }
                        JsonApi.encodeJson(out, eventJsonList);
                        break block17;
                    }
                    catch (JSONException e) {
                        throw new ServletException((Throwable)e);
                    }
                }
                logger.warn("bad url for servlet: regex=" + String.valueOf(this.allEvents) + " or " + String.valueOf(this.singleEvent) + " or " + String.valueOf(this.eventStations) + " but was " + URL2);
                JsonApi.encodeError(out, "bad url for servlet: regex=" + String.valueOf(this.allEvents) + " or " + String.valueOf(this.singleEvent) + " or " + String.valueOf(this.eventStations));
                writer.close();
                resp.sendError(500);
            }
            finally {
                logger.info("Done.");
                writer.close();
                StatefulEventDB.getSingleton().rollback();
            }
        }
    }
}

