/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.hibernate.NetworkDB;
import edu.sc.seis.sod.hibernate.NotFound;
import edu.sc.seis.sod.web.WebAdmin;
import edu.sc.seis.sod.web.jsonapi.JsonApi;
import edu.sc.seis.sod.web.jsonapi.stationxml.ChannelJson;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelServlet
extends HttpServlet {
    Pattern channelDbidPattern = Pattern.compile(".*/channels/([0-9]+)");
    private static final Logger logger = LoggerFactory.getLogger(ChannelServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String URL2 = req.getRequestURL().toString();
        logger.info("GET: " + URL2);
        WebAdmin.setJsonHeader(req, resp);
        PrintWriter writer = resp.getWriter();
        JSONWriter out = new JSONWriter((Appendable)writer);
        NetworkDB netdb = NetworkDB.getSingleton();
        Matcher matcher = this.channelDbidPattern.matcher(URL2);
        if (matcher.matches()) {
            String dbid = matcher.group(1);
            Channel chan = null;
            try {
                chan = netdb.getChannel(Integer.parseInt(dbid));
                if (chan != null) {
                    JsonApi.encodeJson(out, new ChannelJson(chan, WebAdmin.getApiBaseUrl()));
                    resp.setStatus(200);
                } else {
                    JsonApi.encodeError(out, "Channel is null for dbid " + dbid);
                }
            }
            catch (NumberFormatException e) {
                JsonApi.encodeError(out, "NumberFormatException " + e.getMessage());
            }
            catch (NotFound e) {
                JsonApi.encodeError(out, "NotFound " + e.getMessage());
            }
            writer.close();
        } else {
            logger.warn("Bad URL for servlet: " + URL2);
            JsonApi.encodeError(out, "bad url for servlet: " + URL2);
            writer.close();
            resp.sendError(500);
        }
        NetworkDB.rollback();
    }
}

