/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.web;

import edu.sc.seis.sod.SodConfig;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.WaveformArm;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.model.event.StatefulEvent;
import edu.sc.seis.sod.status.eventArm.EventMonitor;
import edu.sc.seis.sod.status.waveformArm.WaveformMonitor;
import edu.sc.seis.sod.web.ThreadAwareWaveformMonitor;
import edu.sc.seis.sod.web.WebAdmin;
import edu.sc.seis.sod.web.jsonapi.ArmStatusJson;
import edu.sc.seis.sod.web.jsonapi.JsonApi;
import edu.sc.seis.sod.web.jsonapi.JsonApiData;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArmStatusServlet
extends HttpServlet {
    EventMonitor eventMon = new EventMonitor(){
        String status = "unknown";
        StatefulEvent lastEvent;

        @Override
        public void setArmStatus(String status) throws Exception {
            this.status = status;
        }

        @Override
        public void change(StatefulEvent event) {
            this.lastEvent = event;
        }
    };
    WaveformMonitor waveformMon = new ThreadAwareWaveformMonitor();
    Pattern armsPattern = Pattern.compile(".*/arms");
    Pattern recipePattern = Pattern.compile(".*/arms/([^/]+)/recipe");
    private static final Logger logger = LoggerFactory.getLogger(ArmStatusServlet.class);

    public ArmStatusServlet() {
        Start.getEventArm().add(this.eventMon);
        Start.getWaveformRecipe().addStatusMonitor(this.waveformMon);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String URL2 = req.getRequestURL().toString();
        logger.info("GET: " + URL2);
        WebAdmin.setJsonHeader(req, resp);
        PrintWriter writer = resp.getWriter();
        JSONWriter out = new JSONWriter((Appendable)writer);
        Matcher matcher = this.armsPattern.matcher(URL2);
        if (matcher.matches()) {
            ArrayList<JsonApiData> json = new ArrayList<JsonApiData>();
            json.add(new ArmStatusJson(Start.getNetworkArm(), WebAdmin.getApiBaseUrl()));
            json.add(new ArmStatusJson(Start.getEventArm(), WebAdmin.getApiBaseUrl()));
            WaveformArm[] waveformArms = Start.getWaveformArms();
            for (int i = 0; i < waveformArms.length; ++i) {
                json.add(new ArmStatusJson(waveformArms[i], WebAdmin.getApiBaseUrl()));
            }
            JsonApi.encodeJson(out, json);
        } else {
            matcher = this.recipePattern.matcher(URL2);
            if (matcher.matches()) {
                SodConfig config = SodDB.getSingleton().getCurrentConfig();
                String string = config.getConfig();
            } else {
                logger.warn("Bad URL for servlet: " + URL2);
                JsonApi.encodeError(out, "bad url for servlet: " + URL2);
                writer.close();
                resp.sendError(500);
            }
        }
        writer.close();
        resp.setStatus(200);
    }
}

