/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.velocity.seismogram;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.model.common.SamplingImpl;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.SeismogramAttrImpl;
import edu.sc.seis.sod.model.station.ChannelGroup;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.velocity.SimpleVelocitizer;
import edu.sc.seis.sod.velocity.network.VelocityChannel;
import edu.sc.seis.sod.velocity.network.VelocitySampling;
import edu.sc.seis.sod.velocity.seismogram.VelocityProperty;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class VelocitySeismogram
extends LocalSeismogramImpl {
    private VelocityChannel chan;

    public VelocitySeismogram(LocalSeismogramImpl localSeis, VelocityChannel chan) {
        super((SeismogramAttrImpl)localSeis, localSeis.getData());
        this.chan = chan;
        if (!ChannelIdUtil.areEqualExceptForBeginTime(localSeis.getChannelID(), chan.getId())) {
            throw new IllegalArgumentException("Channel ids do not match: " + ChannelIdUtil.toString(localSeis.getChannelID()) + "  " + ChannelIdUtil.toString(chan.getWrapped()));
        }
    }

    public Instant getBegin() {
        return this.getBeginTime();
    }

    public String getBegin(String dateFormat) {
        return SimpleVelocitizer.format(this.getBegin(), dateFormat);
    }

    public Instant getEnd() {
        return this.getEndTime();
    }

    public String getEnd(String dateFormat) {
        return SimpleVelocitizer.format(this.getEnd(), dateFormat);
    }

    public VelocityChannel getChannel() {
        return this.chan;
    }

    @Override
    public SamplingImpl getSampling() {
        return new VelocitySampling(super.getSampling());
    }

    public VelocityProperty[] getProps() {
        VelocityProperty[] vProps = new VelocityProperty[this.properties.length];
        for (int i = 0; i < vProps.length; ++i) {
            vProps[i] = new VelocityProperty(this.properties[i]);
        }
        return vProps;
    }

    public String getAllProps() {
        Object out = "Props: ";
        for (int i = 0; i < this.properties.length; ++i) {
            out = (String)out + "( " + this.properties[i].name + ", " + this.properties[i].value + " )";
        }
        return out;
    }

    public String toString() {
        return "Seismogram on " + String.valueOf(this.getChannel()) + " from " + String.valueOf(this.getBegin()) + " to " + String.valueOf(this.getEnd());
    }

    public static List<VelocitySeismogram> wrap(LocalSeismogramImpl[] seis, Channel chan) {
        ArrayList<VelocitySeismogram> results = new ArrayList<VelocitySeismogram>(seis.length);
        VelocityChannel vchan = VelocityChannel.wrap(chan);
        for (int i = 0; i < seis.length; ++i) {
            results.add(VelocitySeismogram.wrap(seis[i], vchan));
        }
        return results;
    }

    public static List<List<VelocitySeismogram>> wrap(LocalSeismogramImpl[][] seis, ChannelGroup channelGroup) {
        ArrayList<List<VelocitySeismogram>> results = new ArrayList<List<VelocitySeismogram>>(seis.length);
        block0: for (int i = 0; i < channelGroup.getChannels().length; ++i) {
            for (int j = 0; j < seis.length; ++j) {
                if (!ChannelIdUtil.areEqual(channelGroup.getChannels()[i], seis[j][0].channel_id)) continue;
                results.add(VelocitySeismogram.wrap(seis[j], channelGroup.getChannels()[i]));
                continue block0;
            }
        }
        return results;
    }

    public static VelocitySeismogram wrap(LocalSeismogramImpl seis, VelocityChannel chan) {
        if (seis instanceof VelocitySeismogram) {
            return (VelocitySeismogram)seis;
        }
        return new VelocitySeismogram(seis, chan);
    }
}

