/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.velocity.seismogram;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.model.station.ChannelGroup;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.velocity.SimpleVelocitizer;
import edu.sc.seis.sod.velocity.network.VelocityChannel;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class VelocityRequest {
    private VelocityChannel chan;
    private TimeRange range;

    public VelocityRequest(RequestFilter rf, Channel chan) {
        this(rf, new VelocityChannel(chan));
    }

    public VelocityRequest(RequestFilter rf, VelocityChannel chan) {
        this.range = new TimeRange(rf);
        this.chan = chan;
    }

    public Instant getBegin() {
        return this.range.getBeginTime();
    }

    public String getBegin(String dateFormat) {
        return SimpleVelocitizer.format(this.getBegin(), dateFormat);
    }

    public Instant getEnd() {
        return this.range.getEndTime();
    }

    public String getEnd(String dateFormat) {
        return SimpleVelocitizer.format(this.getEnd(), dateFormat);
    }

    public VelocityChannel getChannel() {
        return this.chan;
    }

    public String toString() {
        return "Request for " + String.valueOf(this.chan) + " from " + String.valueOf(this.getBegin()) + " to " + String.valueOf(this.getEnd());
    }

    public static List<VelocityRequest> wrap(RequestFilter[] original, Channel chan) {
        ArrayList<VelocityRequest> results = new ArrayList<VelocityRequest>(original.length);
        for (int i = 0; i < original.length; ++i) {
            results.add(new VelocityRequest(original[i], chan));
        }
        return results;
    }

    public static List<List<VelocityRequest>> wrap(RequestFilter[][] original, ChannelGroup channelGroup) {
        ArrayList<List<VelocityRequest>> results = new ArrayList<List<VelocityRequest>>(original.length);
        block0: for (int i = 0; i < channelGroup.getChannels().length; ++i) {
            for (int j = 0; j < original.length; ++j) {
                if (original[j].length == 0 || !ChannelIdUtil.areEqual(channelGroup.getChannels()[i], original[j][0].channelId)) continue;
                results.add(VelocityRequest.wrap(original[j], channelGroup.getChannels()[i]));
                continue block0;
            }
        }
        return results;
    }
}

