/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.velocity.network;

import edu.sc.seis.seisFile.fdsnws.stationxml.Comment;
import edu.sc.seis.seisFile.fdsnws.stationxml.Operator;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.model.common.DistAz;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.common.UnknownUnit;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.station.StationId;
import edu.sc.seis.sod.model.station.StationIdUtil;
import edu.sc.seis.sod.status.FissuresFormatter;
import edu.sc.seis.sod.util.convert.stationxml.StationXMLToFissures;
import edu.sc.seis.sod.util.display.ThreadSafeDecimalFormat;
import edu.sc.seis.sod.velocity.SimpleVelocitizer;
import edu.sc.seis.sod.velocity.event.VelocityEvent;
import edu.sc.seis.sod.velocity.network.VelocityNetwork;
import java.text.DecimalFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.VelocityContext;

public class VelocityStation {
    private boolean hashCalc = false;
    private int hash = 0;
    private VelocityNetwork velocityNet = null;
    private Station sta;
    private int[] position;
    static final ThreadSafeDecimalFormat df = new ThreadSafeDecimalFormat("0.00");

    public VelocityStation(Station sta) {
        if (sta == null) {
            throw new IllegalArgumentException("StationImpl cannot be null");
        }
        this.sta = sta;
    }

    public Integer getDbId() {
        return this.sta.getDbid();
    }

    public StationId get_id() {
        return StationId.of(this.sta);
    }

    public StationId getId() {
        return StationId.of(this.sta);
    }

    public String getCode() {
        return this.sta.getCode();
    }

    public String getCodes() {
        return this.getNetCode() + "." + this.getCode();
    }

    public String getNetCode() {
        return this.getNet().getCode();
    }

    public VelocityNetwork getNet() {
        if (this.velocityNet == null) {
            this.velocityNet = new VelocityNetwork(this.sta.getNetwork());
        }
        return this.velocityNet;
    }

    public Instant getStartDateTime() {
        return this.sta.getStartDateTime();
    }

    public Instant getEndDateTime() {
        return this.sta.getEndDateTime();
    }

    public String getStart() {
        return FissuresFormatter.formatDate(this.getStartDateTime());
    }

    public String getStart(String dateFormat) {
        if (dateFormat.equals("longfile")) {
            return FissuresFormatter.formatDateForFile(this.getStartDateTime());
        }
        return SimpleVelocitizer.format(this.getStartDateTime(), dateFormat);
    }

    public String getEnd() {
        return FissuresFormatter.formatDate(this.getEndDateTime());
    }

    public String getEnd(String dateFormat) {
        if (this.getEndDateTime() == null) {
            return "";
        }
        if (dateFormat.equals("longfile")) {
            return FissuresFormatter.formatDateForFile(this.getEndDateTime());
        }
        return SimpleVelocitizer.format(this.getEndDateTime(), dateFormat);
    }

    public String getName() {
        return FissuresFormatter.oneLineAndClean(this.sta.getDescription());
    }

    public String getCSVName() {
        return this.getName().replaceAll(",", "");
    }

    public String getDescription() {
        return this.sta.getDescription();
    }

    public String getOperator() {
        return (String)((Operator)this.sta.getOperatorList().get(0)).getAgencyList().get(0);
    }

    public String getComment() {
        return ((Comment)this.sta.getCommentList().get(0)).getValue();
    }

    public String getLatitude() {
        return df.format(this.sta.getLatitude().getValue());
    }

    public String getLatitude(String format) {
        return new DecimalFormat(format).format(this.sta.getLatitude().getValue());
    }

    public String getLongitude() {
        return df.format(this.sta.getLongitude().getValue());
    }

    public String getLongitude(String format) {
        return new DecimalFormat(format).format(this.sta.getLongitude().getValue());
    }

    public String getOrientedLatitude() {
        return VelocityStation.getOrientedLatitude(this.sta.getLatitude().getValue());
    }

    public static String getOrientedLatitude(float latitude) {
        if (latitude < 0.0f) {
            return df.format(-latitude) + " S";
        }
        return df.format(latitude) + " N";
    }

    public String getOrientedLongitude() {
        return VelocityStation.getOrientedLongitude(this.sta.getLongitude().getValue());
    }

    public static String getOrientedLongitude(float longitude) {
        if (longitude < 0.0f) {
            return df.format(-longitude) + " W";
        }
        return df.format(longitude) + " E";
    }

    public Float getFloatLatitude() {
        return new Float(this.sta.getLatitude().getValue());
    }

    public Float getFloatLongitude() {
        return new Float(this.sta.getLongitude().getValue());
    }

    public String getElevation() throws UnknownUnit {
        return FissuresFormatter.formatElevation(StationXMLToFissures.convertFloatType(this.sta.getElevation()));
    }

    public String getElevation(String format) throws UnknownUnit {
        double elevInMeters = StationXMLToFissures.convertFloatType(this.sta.getElevation()).convertTo(UnitImpl.METER).getValue();
        return new DecimalFormat(format).format(elevInMeters);
    }

    public String getDistance(VelocityEvent event) {
        double km = DistAz.degreesToKilometers(new DistAz(this.sta, (CacheEvent)event).getDelta());
        return FissuresFormatter.formatDistance(new QuantityImpl(km, UnitImpl.KILOMETER));
    }

    public String getDistanceDeg(VelocityEvent event) {
        return FissuresFormatter.formatDistance(this.getDist(event));
    }

    public String getAz(VelocityEvent event) {
        double az = new DistAz(this.sta, (CacheEvent)event).getAz();
        return FissuresFormatter.formatQuantity(new QuantityImpl(az, UnitImpl.DEGREE));
    }

    public QuantityImpl getDist(VelocityEvent event) {
        double deg = new DistAz(this.sta, (CacheEvent)event).getDelta();
        return new QuantityImpl(deg, UnitImpl.DEGREE);
    }

    public String getBaz(VelocityEvent event) {
        double baz = new DistAz(this.sta, (CacheEvent)event).getBaz();
        return FissuresFormatter.formatQuantity(new QuantityImpl(baz, UnitImpl.DEGREE));
    }

    public String getURL() {
        return "stations/" + this.getNetCode() + "/" + this.getCode();
    }

    public String toString() {
        return StationIdUtil.toStringNoDates(this.get_id());
    }

    public boolean equals(Object o) {
        VelocityStation oVel;
        if (o == this) {
            return true;
        }
        if (o instanceof VelocityStation && (oVel = (VelocityStation)o).getDbId() != -1 && this.getDbId() != -1 && oVel.getDbId() == this.getDbId()) {
            return true;
        }
        if (o instanceof Station) {
            Station oSta = (Station)o;
            return StationIdUtil.areEqual(oSta, this.sta);
        }
        return false;
    }

    public int hashCode() {
        if (!this.hashCalc) {
            this.hash = StationIdUtil.toString(this.get_id()).hashCode();
            this.hashCalc = true;
        }
        return this.hash;
    }

    public void setPosition(int[] position) {
        this.position = position;
    }

    public int[] getPosition() {
        return this.position;
    }

    public void insertIntoContext(VelocityContext ctx) {
        ctx.put("station", (Object)this);
        ctx.put("sta", (Object)this);
        this.getNet().insertIntoContext(ctx);
    }

    public Station getWrapped() {
        return this.sta;
    }

    public static VelocityStation[] wrap(Station[] stations) {
        VelocityStation[] out = new VelocityStation[stations.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = new VelocityStation(stations[i]);
        }
        return out;
    }

    public static List<VelocityStation> wrapList(List<? extends Station> stations) {
        ArrayList<VelocityStation> out = new ArrayList<VelocityStation>();
        for (Station station : stations) {
            out.add(new VelocityStation(station));
        }
        return out;
    }
}

