/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.velocity.network;

import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.sod.model.station.NetworkId;
import edu.sc.seis.sod.status.FissuresFormatter;
import edu.sc.seis.sod.velocity.SimpleVelocitizer;
import edu.sc.seis.sod.velocity.network.VelocityStation;
import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.velocity.VelocityContext;

public class VelocityNetwork {
    private List<VelocityStation> stations;
    private Network net;
    Comparator<VelocityStation> byCodeSorter = new Comparator<VelocityStation>(){

        @Override
        public int compare(VelocityStation sta0, VelocityStation sta1) {
            return sta0.getCode().compareTo(sta1.getCode());
        }
    };

    public VelocityNetwork(Network net) {
        this(net, null);
    }

    public VelocityNetwork(List<VelocityStation> stations) {
        this(VelocityNetwork.getFirstStation(stations).getWrapped().getNetwork(), stations);
    }

    private static final VelocityStation getFirstStation(List<VelocityStation> stations) {
        if (stations.size() == 0) {
            throw new IllegalArgumentException("station list cannot be of size 0");
        }
        return stations.get(0);
    }

    public VelocityNetwork(Network net, List<VelocityStation> stations) {
        this.net = net;
        this.stations = stations;
        if (stations != null) {
            Collections.sort(this.stations, this.byCodeSorter);
        }
    }

    public Network getWrapped() {
        return this.net;
    }

    public NetworkId getId() {
        return new NetworkId(this.net);
    }

    public String getCode() {
        return this.net.getCode();
    }

    public String getCodeWithYear() {
        return this.net.toString();
    }

    public String getName() {
        return this.getDescription();
    }

    public String getDescription() {
        return FissuresFormatter.oneLineAndClean(this.net.getDescription());
    }

    public String getRawDescription() {
        return this.net.getDescription();
    }

    public String getStart() {
        return this.net.getStartDate();
    }

    public String getStart(String format) {
        return SimpleVelocitizer.format(this.net.getStartDateTime(), format);
    }

    public Instant getStartDateTime() {
        return this.net.getStartDateTime();
    }

    public String getEnd() {
        return this.net.getEndDate();
    }

    public String getEnd(String format) {
        if (this.net.getEndDateTime() == null) {
            return "";
        }
        return SimpleVelocitizer.format(this.net.getEndDateTime(), format);
    }

    public Instant getEndDateTime() {
        return this.net.getEndDateTime();
    }

    public String getEntityRefName() {
        String s = this.getName();
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        s = s.replaceAll("'", "&apos;");
        s = s.replaceAll("\"", "&quote;");
        return s;
    }

    public List<VelocityStation> getStations() {
        if (this.stations == null) {
            throw new UnsupportedOperationException("Stations have not been added for this network!");
        }
        return this.stations;
    }

    public Integer getDbid() {
        return this.getWrapped().getDbid();
    }

    public int getDbId() {
        return this.getDbid();
    }

    public String toString() {
        return this.getCodeWithYear();
    }

    public void insertIntoContext(VelocityContext ctx) {
        ctx.put("network", (Object)this);
        ctx.put("net", (Object)this);
    }

    public static VelocityNetwork wrap(Network net) {
        return new VelocityNetwork(net);
    }
}

