/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.velocity.network;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.model.common.Location;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.station.ChannelGroup;
import edu.sc.seis.sod.model.station.ChannelId;
import edu.sc.seis.sod.util.display.EventUtil;
import edu.sc.seis.sod.velocity.network.VelocityChannel;
import edu.sc.seis.sod.velocity.network.VelocityNetwork;
import edu.sc.seis.sod.velocity.network.VelocityStation;
import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.VelocityContext;

public class VelocityChannelGroup {
    ChannelGroup wrapped;

    public VelocityChannelGroup(ChannelGroup wrapped) {
        this.wrapped = wrapped;
    }

    public List<VelocityChannel> getChannels() {
        ArrayList<VelocityChannel> out = new ArrayList<VelocityChannel>();
        for (int i = 0; i < this.wrapped.getChannels().length; ++i) {
            out.add(new VelocityChannel(this.wrapped.getChannels()[i]));
        }
        return out;
    }

    public boolean contains(Channel c) {
        return this.wrapped.contains(c);
    }

    public VelocityChannel getVertical() {
        if (this.wrapped.getVertical() != null) {
            return new VelocityChannel(this.wrapped.getVertical());
        }
        return null;
    }

    public List<VelocityChannel> getHorizontal() {
        ArrayList<VelocityChannel> out = new ArrayList<VelocityChannel>();
        for (int i = 0; i < this.wrapped.getHorizontal().length; ++i) {
            out.add(new VelocityChannel(this.wrapped.getHorizontal()[i]));
        }
        return out;
    }

    public List<VelocityChannel> getHorizontalXY() {
        ArrayList<VelocityChannel> out = new ArrayList<VelocityChannel>();
        for (int i = 0; i < this.wrapped.getHorizontalXY().length; ++i) {
            out.add(new VelocityChannel(this.wrapped.getHorizontalXY()[i]));
        }
        return out;
    }

    public VelocityChannel getChannel(ChannelId chanId, CacheEvent event) {
        if (this.wrapped.getVertical() != null) {
            return new VelocityChannel(this.wrapped.getChannel(chanId, event));
        }
        return null;
    }

    public VelocityChannel getRadial(CacheEvent event) {
        return this.getRadial(EventUtil.extractOrigin(event).getLocation());
    }

    public VelocityChannel getRadial(Location eventLoc) {
        return new VelocityChannel(this.wrapped.getRadial(eventLoc));
    }

    public VelocityChannel getTransverse(CacheEvent event) {
        return this.getTransverse(EventUtil.extractOrigin(event).getLocation());
    }

    public VelocityChannel getTransverse(Location eventLoc) {
        return new VelocityChannel(this.wrapped.getTransverse(eventLoc));
    }

    public VelocityChannel getChannel1() {
        return new VelocityChannel(this.wrapped.getChannel1());
    }

    public VelocityChannel getChannel2() {
        return new VelocityChannel(this.wrapped.getChannel2());
    }

    public VelocityChannel getChannel3() {
        return new VelocityChannel(this.wrapped.getChannel3());
    }

    public VelocityStation getStation() {
        return new VelocityStation(this.wrapped.getStation());
    }

    public VelocityNetwork getNetworkAttr() {
        return new VelocityNetwork(this.wrapped.getNetworkAttr());
    }

    public void insertIntoContext(VelocityContext ctx) {
        ctx.put("channelGroup", (Object)this);
        this.getChannel1().getStation().insertIntoContext(ctx);
    }

    public ChannelGroup getChannelGroup() {
        return this.wrapped;
    }
}

