/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.velocity.network;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.model.common.SamplingImpl;
import edu.sc.seis.sod.model.common.UnknownUnit;
import edu.sc.seis.sod.model.station.ChannelId;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.status.FissuresFormatter;
import edu.sc.seis.sod.util.convert.stationxml.StationXMLToFissures;
import edu.sc.seis.sod.velocity.SimpleVelocitizer;
import edu.sc.seis.sod.velocity.network.VelocityNetwork;
import edu.sc.seis.sod.velocity.network.VelocitySampling;
import edu.sc.seis.sod.velocity.network.VelocitySensitivity;
import edu.sc.seis.sod.velocity.network.VelocityStation;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.VelocityContext;

public class VelocityChannel {
    private Channel chan;
    private VelocityStation velStation;

    public VelocityChannel(Channel chan) {
        this.chan = chan;
    }

    public ChannelId getId() {
        return ChannelId.of(this.chan);
    }

    public float getAzimuth() {
        return this.chan.getAzimuth().getValue();
    }

    public float getDip() {
        return this.chan.getDip().getValue();
    }

    public String getCode() {
        return this.chan.getCode();
    }

    public String getLocCode() {
        return this.chan.getLocCode();
    }

    public String getBandCode() {
        return this.getCode().substring(0, 1);
    }

    public String getGainCode() {
        return this.getCode().substring(1, 2);
    }

    public String getOrientationCode() {
        return this.getCode().substring(2, 3);
    }

    public String getCodes() {
        return this.getNet().getCode() + "." + this.getStation().getCode() + "." + this.getLocCode() + "." + this.getCode();
    }

    public VelocityNetwork getNet() {
        return this.getStation().getNet();
    }

    public VelocityNetwork getNetwork() {
        return this.getNet();
    }

    public VelocityStation getStation() {
        if (this.velStation == null) {
            this.velStation = new VelocityStation(this.chan.getStation());
        }
        return this.velStation;
    }

    public String getLatitude() {
        return VelocityStation.df.format(this.chan.getLatitude().getValue());
    }

    public String getLongitude() {
        return VelocityStation.df.format(this.chan.getLongitude().getValue());
    }

    public String getOrientedLatitude() {
        String suffix = " N";
        float lat = this.chan.getLatitude().getValue();
        if (lat < 0.0f) {
            lat = -1.0f * lat;
            suffix = " S";
        }
        return VelocityStation.df.format(lat) + suffix;
    }

    public String getOrientedLongitude() {
        String suffix = " E";
        float lon = this.chan.getLongitude().getValue();
        if (lon < 0.0f) {
            lon = -1.0f * lon;
            suffix = " W";
        }
        return VelocityStation.df.format(lon) + suffix;
    }

    public String getDepth() throws UnknownUnit {
        return FissuresFormatter.formatElevation(StationXMLToFissures.convertFloatType(this.chan.getDepth()));
    }

    public String getElevation() throws UnknownUnit {
        return FissuresFormatter.formatElevation(StationXMLToFissures.convertFloatType(this.chan.getElevation()));
    }

    public Instant getStartDateTime() {
        return this.chan.getStartDateTime();
    }

    public String getStart() {
        return FissuresFormatter.formatDate(this.chan.getStartDateTime());
    }

    public String getStart(String format) {
        return SimpleVelocitizer.format(this.getStartDateTime(), format);
    }

    public Instant getEndDateTime() {
        return this.chan.getEndDateTime();
    }

    public String getEnd() {
        return FissuresFormatter.formatDate(this.chan.getEndDateTime());
    }

    public String getEnd(String format) {
        if (this.getEndDateTime() == null) {
            return "";
        }
        return SimpleVelocitizer.format(this.getEndDateTime(), format);
    }

    public VelocitySampling getSampling() {
        return new VelocitySampling(SamplingImpl.of(this.chan));
    }

    public VelocitySensitivity getSensitivity() {
        if (this.chan.getResponse() != null && this.chan.getResponse().getInstrumentSensitivity() != null) {
            return new VelocitySensitivity(this.chan.getResponse().getInstrumentSensitivity());
        }
        return null;
    }

    public String compactToString() {
        return ChannelIdUtil.toStringNoDates(this.chan);
    }

    public String toString() {
        return ChannelIdUtil.toStringNoDates(this.chan);
    }

    public boolean hasDbId() {
        return this.chan.getDbid() >= 0;
    }

    public int getDbId() {
        if (this.hasDbId()) {
            return this.chan.getDbid();
        }
        throw new UnsupportedOperationException("This channel had no dbid");
    }

    public Channel getWrapped() {
        return this.chan;
    }

    public static VelocityChannel[] wrap(Channel[] chans) {
        VelocityChannel[] velChans = new VelocityChannel[chans.length];
        for (int i = 0; i < velChans.length; ++i) {
            velChans[i] = VelocityChannel.wrap(chans[i]);
        }
        return velChans;
    }

    public static List<VelocityChannel> wrap(List<? extends Channel> chans) {
        ArrayList<VelocityChannel> velChans = new ArrayList<VelocityChannel>();
        for (Channel channel : chans) {
            velChans.add(VelocityChannel.wrap(channel));
        }
        return velChans;
    }

    public void insertIntoContext(VelocityContext ctx) {
        ctx.put("channel", (Object)this);
        ctx.put("chan", (Object)this);
        this.getStation().insertIntoContext(ctx);
    }

    public static VelocityChannel wrap(Channel chan) {
        return new VelocityChannel(chan);
    }
}

