/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.velocity.event;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.FlinnEngdahlRegion;
import edu.sc.seis.sod.model.event.FlinnEngdahlType;
import edu.sc.seis.sod.model.event.NoPreferredOrigin;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.status.FissuresFormatter;
import edu.sc.seis.sod.util.display.ParseRegions;
import edu.sc.seis.sod.util.display.ThreadSafeDecimalFormat;
import edu.sc.seis.sod.velocity.SimpleVelocitizer;
import edu.sc.seis.sod.velocity.network.VelocityStation;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class VelocityEvent
extends CacheEvent {
    private static DateTimeFormatter fullDateIdentifier = TimeUtils.createFormatter((String)"yyyy/MM/dd/HH/mm/ss");
    private OriginImpl origin;
    private int[] position;
    private static ParseRegions pr = ParseRegions.getInstance();
    private ThreadSafeDecimalFormat df = new ThreadSafeDecimalFormat("0.0");

    public VelocityEvent(CacheEvent event) {
        if (event == null) {
            throw new NullPointerException("event cannot be null");
        }
        this.event = event;
        this.origin = this.getOrigin();
    }

    public String getName() {
        if (this.get_attributes().name != null & this.get_attributes().name.length() > 0) {
            return this.get_attributes().name;
        }
        if (this.hasRegion()) {
            return this.getRegion();
        }
        return this.getTime();
    }

    public boolean hasRegion() {
        return this.get_attributes().region != null && this.get_attributes().region.number > 0;
    }

    public String getRegion() {
        return pr.getRegionName(this.get_attributes().region);
    }

    public String getRegionNumber() {
        FlinnEngdahlRegion region = this.get_attributes().region;
        String type = region.type == FlinnEngdahlType.GEOGRAPHIC_REGION ? "Geographic" : "Seismic";
        return type + " " + this.get_attributes().region.number;
    }

    public String getMagnitude() {
        if (this.origin.getMagnitudes().length == 0) {
            return "-";
        }
        return FissuresFormatter.formatMagnitude(this.origin.getMagnitudes()[0]);
    }

    public String getAllMagnitudes() {
        return this.getAllMagnitudes(", ");
    }

    public String getAllMagnitudes(String seperator) {
        Object s = "";
        for (int i = 0; i < this.origin.getMagnitudes().length; ++i) {
            s = (String)s + FissuresFormatter.formatMagnitude(this.origin.getMagnitudes()[i]);
            if (i == this.origin.getMagnitudes().length - 1) continue;
            s = (String)s + seperator;
        }
        return s;
    }

    public String getMagnitudeValue() {
        if (this.origin.getMagnitudes().length != 0) {
            return "" + this.origin.getMagnitudes()[0].value;
        }
        return "";
    }

    public String getMagnitudeType() {
        if (this.origin.getMagnitudes().length != 0) {
            return this.origin.getMagnitudes()[0].type;
        }
        return "";
    }

    public String getMagnitudeContributor() {
        if (this.origin.getMagnitudes().length != 0) {
            return this.origin.getMagnitudes()[0].contributor;
        }
        return "";
    }

    public String getLatitude() {
        return this.df.format(this.origin.getLocation().latitude);
    }

    public String getLongitude() {
        return this.df.format(this.origin.getLocation().longitude);
    }

    public String getLatitude(String format) {
        return new DecimalFormat(format).format(this.origin.getLocation().latitude);
    }

    public String getLongitude(String format) {
        return new DecimalFormat(format).format(this.origin.getLocation().longitude);
    }

    public Float getFloatLatitude() {
        return new Float(this.origin.getLocation().latitude);
    }

    public Float getFloatLongitude() {
        return new Float(this.origin.getLocation().longitude);
    }

    public String getOrientedLatitude() {
        if (this.origin.getLocation().latitude < 0.0f) {
            return this.df.format(-this.origin.getLocation().latitude) + " S";
        }
        return this.df.format(this.origin.getLocation().latitude) + " N";
    }

    public String getOrientedLongitude() {
        if (this.origin.getLocation().longitude < 0.0f) {
            return this.df.format(-this.origin.getLocation().longitude) + " W";
        }
        return this.df.format(this.origin.getLocation().longitude) + " E";
    }

    public String getDepth() {
        return FissuresFormatter.formatDepth(FissuresFormatter.getDepth(this.origin));
    }

    public String getDepthValue() {
        return this.getDepth("0.0");
    }

    public String getDepth(String format) {
        double depthInKM = QuantityImpl.createQuantityImpl(this.origin.getLocation().depth).convertTo(UnitImpl.KILOMETER).getValue();
        return new DecimalFormat(format).format(depthInKM);
    }

    public String getElevation() {
        return FissuresFormatter.formatDepth(QuantityImpl.createQuantityImpl(this.origin.getLocation().elevation));
    }

    public String getElevation(String format) {
        double elevInMeters = QuantityImpl.createQuantityImpl(this.origin.getLocation().elevation).convertTo(UnitImpl.METER).getValue();
        return new DecimalFormat(format).format(elevInMeters);
    }

    public String getTime() {
        return this.getTime("yyyy/MM/dd HH:mm:ss z");
    }

    public String getTimePrecise() {
        return this.getTime("yyyy/MM/dd HH:mm:ss.SSS Z");
    }

    public String getFilizedTime() {
        return this.getTime("yyyy_DDD_HH_mm_ss_ZZZ");
    }

    public String getTime(String format) {
        return SimpleVelocitizer.format(this.origin.getOriginTime(), format);
    }

    public String getCatalog() {
        return this.origin.getCatalog();
    }

    public String getContributor() {
        return this.origin.getContributor();
    }

    public int getId() {
        return this.getDbid();
    }

    public int getDbId() {
        return this.getDbid();
    }

    @Override
    public int getDbid() {
        return this.event.getDbid();
    }

    @Override
    public OriginImpl getPreferred() throws NoPreferredOrigin {
        return this.getCacheEvent().getPreferred();
    }

    @Override
    public OriginImpl[] getOrigins() {
        return this.getCacheEvent().getOrigins();
    }

    public String getParam(String name) {
        for (int i = 0; i < this.origin.getParmIds().length; ++i) {
            if (!this.origin.getParmIds()[i].a_id.equals(name)) continue;
            return this.origin.getParmIds()[i].creator;
        }
        return null;
    }

    public String getDistanceDeg(VelocityStation sta) {
        return sta.getDistanceDeg(this);
    }

    public String getDistance(VelocityStation sta) {
        return sta.getDistance(this);
    }

    public String getAz(VelocityStation sta) {
        return sta.getAz(this);
    }

    public String getBaz(VelocityStation sta) {
        return sta.getBaz(this);
    }

    public void setPosition(int[] position) {
        this.position = position;
    }

    public int[] getPosition() {
        return this.position;
    }

    public String getURL() {
        return "earthquakes/" + VelocityEvent.makeDateIdentifier(this);
    }

    public CacheEvent getCacheEvent() {
        if (this.event instanceof CacheEvent) {
            return this.event;
        }
        return new CacheEvent(this.event);
    }

    public static String makeDateIdentifier(VelocityEvent event) {
        return fullDateIdentifier.format(event.getOrigin().getOriginTime());
    }

    public static Instant parseDateIdentifier(String eqIdentifier) throws ParseException {
        return ZonedDateTime.parse(eqIdentifier, fullDateIdentifier).toInstant();
    }

    public static VelocityEvent[] wrap(List evs) {
        VelocityEvent[] velEvs = new VelocityEvent[evs.size()];
        for (int i = 0; i < velEvs.length; ++i) {
            velEvs[i] = VelocityEvent.wrap((CacheEvent)evs.get(i));
        }
        return velEvs;
    }

    public static VelocityEvent[] wrap(CacheEvent[] evs) {
        VelocityEvent[] velEvs = new VelocityEvent[evs.length];
        for (int i = 0; i < velEvs.length; ++i) {
            velEvs[i] = VelocityEvent.wrap(evs[i]);
        }
        return velEvs;
    }

    public static VelocityEvent wrap(CacheEvent event) {
        if (event instanceof VelocityEvent) {
            return (VelocityEvent)event;
        }
        return new VelocityEvent(event);
    }
}

