/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.velocity;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.util.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.velocity.ContextWrangler;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleVelocitizer {
    public static final String VELOCITY_LOGGER_NAME = "runtime.log.logsystem.log4j.logger";
    private static final Logger logger = LoggerFactory.getLogger(SimpleVelocitizer.class);
    public static final String ERR_PREFIX = "#ERROR#";

    public static String format(Instant date, String format) {
        if (date == null) {
            return "";
        }
        DateTimeFormatter formatter = TimeUtils.createFormatter((String)format).withZone(ZoneOffset.UTC);
        return ZonedDateTime.ofInstant(date, TimeUtils.TZ_UTC).format(formatter);
    }

    public String evaluate(String template, Channel chan) {
        return this.evaluate(template, ContextWrangler.createContext(chan));
    }

    public String evaluate(String template, CacheEvent event) {
        return this.evaluate(template, ContextWrangler.createContext(event));
    }

    public String evaluate(String template, CacheEvent event, Channel channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, MeasurementStorage cookieJar) {
        return this.evaluate(template, ContextWrangler.createContext(event, channel, original, available, seismograms, cookieJar));
    }

    public String evaluate(String template, VelocityContext ctx) {
        StringWriter writer = new StringWriter();
        try {
            try {
                Velocity.evaluate((Context)ctx, (Writer)writer, (String)"SimpleVelocitizer", (String)template);
            }
            catch (ParseErrorException parseError) {
                return "#ERROR#Invalid Velocity";
            }
            return writer.toString();
        }
        catch (Exception e) {
            GlobalExceptionHandler.handle(e);
            return "Unable to evaluate " + template;
        }
    }

    public String evaluate(InputStream template, VelocityContext ctx) {
        StringWriter writer = new StringWriter();
        try {
            try {
                this.evaluate(template, ctx, writer);
            }
            catch (ParseErrorException parseError) {
                return "#ERROR#Invalid Velocity";
            }
        }
        catch (Exception e) {
            GlobalExceptionHandler.handle(e);
            return "Unable to evaluate " + String.valueOf(template);
        }
        return writer.toString();
    }

    public void evaluate(InputStream template, VelocityContext ctx, Writer writer) throws ParseErrorException, Exception {
        Velocity.evaluate((Context)ctx, (Writer)writer, (String)"SimpleVelocitizer", (Reader)new InputStreamReader(template));
    }

    public static String cleanUpErrorStringForDisplay(String string) {
        if (string.startsWith(ERR_PREFIX)) {
            return string.substring(ERR_PREFIX.length());
        }
        return string;
    }

    public static void setupVelocityLogger(Properties velocityProps, Logger velocityLogger) {
        velocityProps.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.Log4JLogChute");
        velocityProps.setProperty(VELOCITY_LOGGER_NAME, logger.getName());
    }

    static {
        try {
            Properties props = new Properties();
            SimpleVelocitizer.setupVelocityLogger(props, logger);
            props.setProperty("velocimacro.library", "");
            Velocity.init((Properties)props);
        }
        catch (Exception e) {
            GlobalExceptionHandler.handle("Trouble initializing velocity", e);
        }
    }
}

