/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.velocity;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.model.station.ChannelGroup;
import edu.sc.seis.sod.status.FissuresFormatter;
import edu.sc.seis.sod.velocity.WaveformProcessContext;
import edu.sc.seis.sod.velocity.event.VelocityEvent;
import edu.sc.seis.sod.velocity.network.VelocityChannel;
import edu.sc.seis.sod.velocity.network.VelocityChannelGroup;
import edu.sc.seis.sod.velocity.network.VelocityNetwork;
import edu.sc.seis.sod.velocity.network.VelocityStation;
import edu.sc.seis.sod.velocity.seismogram.VelocitySeismogram;
import org.apache.velocity.VelocityContext;

public class ContextWrangler {
    public static VelocityContext createContext() {
        VelocityContext ctx = new VelocityContext();
        ctx.put("formatter", (Object)new FissuresFormatter());
        return ctx;
    }

    public static VelocityContext createContext(CacheEvent event) {
        VelocityContext ctx = ContextWrangler.createContext();
        ContextWrangler.insertIntoContext(event, ctx);
        return ctx;
    }

    public static VelocityContext createContext(Station sta) {
        VelocityContext ctx = ContextWrangler.createContext();
        VelocityStation velSta = new VelocityStation(sta);
        velSta.insertIntoContext(ctx);
        return ctx;
    }

    public static VelocityEvent insertIntoContext(CacheEvent event, VelocityContext ctx) {
        VelocityEvent ev = VelocityEvent.wrap(event);
        ctx.put("event", (Object)ev);
        return ev;
    }

    public static VelocityContext createContext(Network net) {
        VelocityContext ctx = ContextWrangler.createContext();
        ContextWrangler.insertIntoContext(net, ctx);
        return ctx;
    }

    public static VelocityNetwork insertIntoContext(Network net, VelocityContext ctx) {
        VelocityNetwork velNet = VelocityNetwork.wrap(net);
        velNet.insertIntoContext(ctx);
        return velNet;
    }

    public static VelocityContext createContext(Channel chan) {
        VelocityContext ctx = ContextWrangler.createContext();
        ContextWrangler.insertIntoContext(chan, ctx);
        return ctx;
    }

    public static VelocityChannel insertIntoContext(Channel chan, VelocityContext ctx) {
        VelocityChannel velChan = VelocityChannel.wrap(chan);
        velChan.insertIntoContext(ctx);
        return velChan;
    }

    public static VelocityChannelGroup insertIntoContext(ChannelGroup chan, VelocityContext ctx) {
        VelocityChannelGroup velChan = new VelocityChannelGroup(chan);
        velChan.insertIntoContext(ctx);
        return velChan;
    }

    public static VelocityContext createContext(CacheEvent event, Channel channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, MeasurementStorage cookieJar) {
        WaveformProcessContext ctx = new WaveformProcessContext(event, channel, original, available, seismograms, cookieJar);
        return ctx;
    }

    public static VelocitySeismogram insertIntoContext(LocalSeismogramImpl seis, Channel chan, VelocityContext ctx) {
        VelocitySeismogram velSeis = VelocitySeismogram.wrap(seis, ContextWrangler.insertIntoContext(chan, ctx));
        ctx.put("seismogram", (Object)velSeis);
        return velSeis;
    }
}

