/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.validator.tour;

import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.validator.documenter.SchemaDocumenter;
import edu.sc.seis.sod.validator.model.Attribute;
import edu.sc.seis.sod.validator.model.Choice;
import edu.sc.seis.sod.validator.model.Data;
import edu.sc.seis.sod.validator.model.Empty;
import edu.sc.seis.sod.validator.model.Form;
import edu.sc.seis.sod.validator.model.Group;
import edu.sc.seis.sod.validator.model.Interleave;
import edu.sc.seis.sod.validator.model.MultigenitorForm;
import edu.sc.seis.sod.validator.model.NamedElement;
import edu.sc.seis.sod.validator.model.NotAllowed;
import edu.sc.seis.sod.validator.model.Text;
import edu.sc.seis.sod.validator.model.Value;
import edu.sc.seis.sod.validator.tour.Tourist;

public class HTMLOutlineTourist
implements Tourist {
    private Form lastForm;
    private String appendIfChildren = "";
    private String appendIfNoChildren = "";
    private String curLoc;
    private StringBuffer result = new StringBuffer();

    public HTMLOutlineTourist(String curLoc) {
        this.curLoc = curLoc.replace('\\', '/');
    }

    @Override
    public void visit(Attribute attr) {
        this.genericVisit(attr);
        this.result.append("An attribute named " + attr.getName() + " with a value of ");
    }

    @Override
    public void leave(Attribute attr) {
        this.genericLeave(attr);
        this.result.append("\n");
    }

    @Override
    public void visit(Choice choice) {
        this.genericVisit(choice);
        this.result.append(this.getDefLink(choice) + " " + this.getCardinality(choice));
        this.appendIfChildren = " " + this.getChoiceLink() + "\n<div id=\"choice\">\n";
    }

    @Override
    public void leave(Choice choice) {
        this.appendIfChildren = "</div> \n<br />";
        this.appendIfNoChildren = "<br />\n";
        this.genericLeave(choice);
    }

    private String getChoiceLink() {
        return "<i><a class=\"choice\" href=\"" + this.getTagDocHelpHREF() + "#choice\">choice</a></i> ";
    }

    @Override
    public void visit(Data d) {
        this.genericVisit(d);
        this.result.append("<b>");
        if (d.isFromDef()) {
            this.result.append(this.getDefLink(d));
        } else {
            this.result.append("<a href=\"" + this.getDatatypeHREF(d) + "\">" + String.valueOf(d.getDatatype()) + "</a>");
        }
        this.result.append("</b>");
    }

    @Override
    public void visit(Value v) {
        this.genericVisit(v);
        String output = "<b>" + v.getValue() + "</b>";
        if (v.getParent() instanceof MultigenitorForm) {
            output = "<div>" + output + "</div>\n";
        }
        this.result.append(output);
    }

    @Override
    public void visit(Empty e) {
    }

    @Override
    public void visit(Group g) {
        this.genericVisit(g);
        String cardinality = this.getCardinality(g);
        if (!cardinality.equals("")) {
            this.result.append(this.getDefLink(g) + this.getGroupLink() + this.getCardinality(g) + "\n");
        }
        this.appendIfChildren = "<div id=\"group\">\n";
    }

    @Override
    public void leave(Group g) {
        this.appendIfNoChildren = this.getDefLink(g) + " " + this.getCardinality(g) + "<br />\n";
        this.appendIfChildren = "</div>\n";
        this.genericLeave(g);
    }

    private String getGroupLink() {
        return "<i><a href=\"" + this.getTagDocHelpHREF() + "#group\">group</a> </i>";
    }

    @Override
    public void visit(Interleave i) {
        this.genericVisit(i);
        this.result.append(this.getDefLink(i) + " " + this.getCardinality(i));
        this.appendIfChildren = this.getInterLink() + "\n<div id=\"inter\">\n";
    }

    @Override
    public void leave(Interleave i) {
        this.appendIfNoChildren = "<br />\n";
        this.appendIfChildren = "</div> \n";
        this.genericLeave(i);
    }

    private String getInterLink() {
        return "<i><a href=\"" + this.getTagDocHelpHREF() + "#interleave\">interleave</a></i>";
    }

    @Override
    public void visit(NamedElement ne) {
        this.genericVisit(ne);
        if (ne.getChild() instanceof Empty) {
            this.result.append("&lt;" + this.getName(ne) + "/&gt;\n");
        } else {
            this.result.append("&lt;" + this.getName(ne) + "&gt;");
            if (!this.isData(ne.getChild())) {
                this.appendIfChildren = " " + this.getCardinality(ne) + "<div>\n";
            }
        }
    }

    @Override
    public void leave(NamedElement ne) {
        this.appendIfNoChildren = " " + this.getCardinality(ne) + "<br />";
        if (!(ne.getChild() instanceof Empty)) {
            this.appendIfChildren = !this.isData(ne.getChild()) ? "</div>\n&lt;/" + this.getName(ne) + "&gt;<br />\n" : "&lt;/" + this.getName(ne) + "&gt; " + this.getCardinality(ne) + "<br />\n";
        }
        this.genericLeave(ne);
    }

    private String getName(NamedElement ne) {
        if (ne.getDef() != null) {
            return this.getDefLink(ne, ne.getName());
        }
        return ne.getName();
    }

    public boolean isData(Form f) {
        return f instanceof Data || f instanceof Value || f instanceof Text;
    }

    @Override
    public void visit(Text t) {
        this.genericVisit(t);
        this.result.append("<b><a href=\"" + this.getDatatypeHREF(t) + "\">Any Text</a></b>");
    }

    @Override
    public void visit(NotAllowed na) {
    }

    public String getResult() {
        return this.result.toString();
    }

    private String getTagDocHelpHREF() {
        return this.getBasePath() + "ingredients/abstractStructure.html";
    }

    private String getBasePath() {
        Object baseString = "../";
        for (int i = 0; i < this.curLoc.length(); ++i) {
            if (this.curLoc.charAt(i) != '/') continue;
            baseString = (String)baseString + "../";
        }
        return baseString;
    }

    private String getDatatypeHREF(Form d) {
        Class<?> c = d.getClass();
        if (d instanceof Data) {
            c = ((Data)d).getDatatype().getClass();
        }
        String classname = c.getName().substring(c.getPackage().getName().length() + 1);
        return this.getBasePath() + "ingredients/datatypes/" + classname + ".html";
    }

    private String getDefLink(Form f) {
        if (f.getDef() != null) {
            return this.getDefLink(f, f.getDef().getName());
        }
        return "";
    }

    private String getDefLink(Form f, String name) {
        String path = SchemaDocumenter.makePath(f.getDef()) + ".html";
        String href = SodUtil.getRelativePath(this.curLoc, path, "/");
        Object title = "";
        if (f.getAnnotation().hasSummary()) {
            title = "title=\"" + f.getAnnotation().getSummary() + "\"";
        }
        return "<a href=\"" + href + "\" " + (String)title + ">" + name + "</a>";
    }

    private String getCardinality(Form f) {
        String baseString = this.getTagDocHelpHREF();
        if (f.getMin() == 0) {
            if (f.getMax() == 1) {
                return "<i><a href=\"" + baseString + "#optional\">optional</a> </i>";
            }
            return "<i><a href=\"" + baseString + "#Any number of times\">Any number of times</a> </i>";
        }
        if (f.getMax() > 1) {
            return "<i><a href=\"" + baseString + "#At least once\">At least once</a> </i>";
        }
        return "";
    }

    private void genericVisit(Form f) {
        this.result.append(this.appendIfChildren);
        this.appendIfChildren = "";
        this.appendIfNoChildren = "";
        this.lastForm = f;
    }

    private void genericLeave(Form f) {
        if (f.equals(this.lastForm)) {
            this.result.append(this.appendIfNoChildren);
        } else {
            this.result.append(this.appendIfChildren);
        }
        this.appendIfNoChildren = "";
        this.appendIfChildren = "";
    }
}

