/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.validator.tour;

import edu.sc.seis.sod.validator.model.Attribute;
import edu.sc.seis.sod.validator.model.Choice;
import edu.sc.seis.sod.validator.model.Data;
import edu.sc.seis.sod.validator.model.Empty;
import edu.sc.seis.sod.validator.model.Form;
import edu.sc.seis.sod.validator.model.Group;
import edu.sc.seis.sod.validator.model.Interleave;
import edu.sc.seis.sod.validator.model.NamedElement;
import edu.sc.seis.sod.validator.model.NotAllowed;
import edu.sc.seis.sod.validator.model.Text;
import edu.sc.seis.sod.validator.model.Value;
import edu.sc.seis.sod.validator.tour.Tourist;

public class FormPrinter
implements Tourist {
    private int depth = 0;
    private String indent = "";

    public FormPrinter() {
        this(2);
    }

    public FormPrinter(int indentLevel) {
        for (int i = 0; i < indentLevel; ++i) {
            this.indent = this.indent + " ";
        }
    }

    @Override
    public void visit(Attribute attr) {
        String print = "@" + attr.getName() + " " + this.getCardinality(attr);
        this.printAndIncreaseDepth(print, attr);
    }

    @Override
    public void visit(Choice choice) {
        this.printAndIncreaseDepth("Choice " + this.getCardinality(choice), choice);
    }

    private String getCardinality(Form choice) {
        return "Min: " + choice.getMin() + " Max: " + choice.getMax();
    }

    @Override
    public void visit(Data d) {
        this.print("Data: " + String.valueOf(d.getDatatype()) + " " + this.getCardinality(d), d);
    }

    @Override
    public void visit(Empty e) {
        this.print("Empty", e);
    }

    @Override
    public void visit(Group g) {
        String print = "Group " + this.getCardinality(g);
        this.printAndIncreaseDepth(print, g);
    }

    @Override
    public void visit(Interleave i) {
        this.printAndIncreaseDepth("Interleave " + this.getCardinality(i), i);
    }

    @Override
    public void visit(NotAllowed na) {
        this.print("Not Allowed", na);
    }

    @Override
    public void visit(NamedElement ne) {
        String print = ne.getName() + " " + this.getCardinality(ne);
        this.printAndIncreaseDepth(print, ne);
    }

    @Override
    public void visit(Text t) {
        this.print("Text", t);
    }

    @Override
    public void leave(Attribute attr) {
        --this.depth;
    }

    @Override
    public void leave(Choice choice) {
        --this.depth;
    }

    @Override
    public void leave(Group g) {
        --this.depth;
    }

    @Override
    public void leave(Interleave i) {
        --this.depth;
    }

    @Override
    public void leave(NamedElement ne) {
        --this.depth;
    }

    @Override
    public void visit(Value v) {
        this.print("Value: " + v.getValue() + " " + String.valueOf(v.getDatatype()) + " " + this.getCardinality(v), v);
    }

    private void printAndIncreaseDepth(String s, Form f) {
        this.print(s, f);
        ++this.depth;
    }

    private void print(String s, Form f) {
        for (int i = 0; i < this.depth; ++i) {
            System.out.print(this.indent);
        }
        System.out.println(s + " " + f.getAnnotation().getSummary());
    }
}

