/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.validator.tour;

import edu.sc.seis.sod.validator.model.Attribute;
import edu.sc.seis.sod.validator.model.Choice;
import edu.sc.seis.sod.validator.model.Data;
import edu.sc.seis.sod.validator.model.Form;
import edu.sc.seis.sod.validator.model.Group;
import edu.sc.seis.sod.validator.model.Interleave;
import edu.sc.seis.sod.validator.model.MultigenitorForm;
import edu.sc.seis.sod.validator.model.NamedElement;
import edu.sc.seis.sod.validator.model.Text;
import edu.sc.seis.sod.validator.model.Value;
import edu.sc.seis.sod.validator.tour.TourGuide;
import edu.sc.seis.sod.validator.tour.Tourist;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DepthAwareGuide
implements TourGuide {
    int allowableDepth = 2;
    private Form root;

    public DepthAwareGuide(Form root) {
        this.root = root;
        if (root instanceof MultigenitorForm) {
            this.allowableDepth = 1;
        }
    }

    @Override
    public void lead(Tourist visitor) {
        this.internalLead(visitor, this.root);
    }

    public void internalLead(Tourist visitor, Form curForm) {
        if (this.calcDistance(curForm) > this.allowableDepth && curForm.getParent().isFromDef() && !(curForm instanceof Value)) {
            return;
        }
        if (curForm instanceof NamedElement) {
            NamedElement cur = (NamedElement)curForm;
            visitor.visit(cur);
            this.internalLead(visitor, cur.getChild());
            visitor.leave(cur);
        } else if (curForm instanceof Choice) {
            Choice c = (Choice)curForm;
            visitor.visit(c);
            this.handleKids(visitor, c, true);
            visitor.leave(c);
        } else if (curForm instanceof Group) {
            Group g = (Group)curForm;
            visitor.visit(g);
            this.handleKids(visitor, g, false);
            visitor.leave(g);
        } else if (curForm instanceof Interleave) {
            Interleave g = (Interleave)curForm;
            visitor.visit(g);
            this.handleKids(visitor, g, true);
            visitor.leave(g);
        } else if (curForm instanceof Value) {
            visitor.visit((Value)curForm);
        } else if (curForm instanceof Data) {
            visitor.visit((Data)curForm);
        } else if (curForm instanceof Text) {
            visitor.visit((Text)curForm);
        } else if (curForm instanceof Attribute) {
            Attribute attr = (Attribute)curForm;
            visitor.visit(attr);
            this.internalLead(visitor, attr.getChild());
            visitor.leave(attr);
        }
    }

    private void handleKids(Tourist visitor, MultigenitorForm f, boolean sort) {
        Form[] children = f.getChildren();
        List<Form> tosort = Arrays.asList(children);
        if (sort) {
            Collections.sort(tosort, new Comparator<Form>(){

                @Override
                public int compare(Form o1, Form o2) {
                    if (o1.isFromDef() && o2.isFromDef()) {
                        return o1.getDef().getName().toLowerCase().compareTo(o2.getDef().getName().toLowerCase());
                    }
                    return 0;
                }
            });
        }
        for (Form form : tosort) {
            this.internalLead(visitor, form);
        }
    }

    public int calcDistance(Form f) {
        if (f.equals(this.root)) {
            return 0;
        }
        return this.calcDistance(f.getParent()) + 1;
    }
}

