/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.validator.model;

import edu.sc.seis.sod.validator.model.FormProvider;
import edu.sc.seis.sod.validator.tour.MinimalVisitGuide;
import edu.sc.seis.sod.validator.tour.XMLWritingTourist;

public class Annotation {
    private boolean hasExampleFromAnnotation = false;
    private String summary;
    private String desc;
    private String example;
    private String vel = "#ingredientPage()";
    private String deprecation;
    private FormProvider formProvider;
    private boolean include = false;
    public static boolean DEFAULT_HTMLIZE = true;

    public void setDescription(String description) {
        this.desc = description;
    }

    public void setDeprecation(String deprecation) {
        this.deprecation = deprecation;
    }

    public void setSummary(String summary) {
        this.summary = summary.replaceAll("\n\\s*", " ");
    }

    public void setVelocity(String vel) {
        this.vel = vel;
    }

    public void setExample(String example) {
        this.example = example;
        this.hasExampleFromAnnotation = true;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getDeprecation() {
        return this.deprecation;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getVelocity() {
        return this.vel;
    }

    public boolean hasSummary() {
        return this.summary != null;
    }

    public boolean hasDescription() {
        return this.desc != null;
    }

    public String getExample() {
        return this.getExample(DEFAULT_HTMLIZE);
    }

    public void setFormProvider(FormProvider fp) {
        this.formProvider = fp;
    }

    public FormProvider getFormProvider() {
        return this.formProvider;
    }

    public String getExample(boolean htmlize) {
        if (this.example == null || this.example.equals("")) {
            XMLWritingTourist tourist = new XMLWritingTourist();
            MinimalVisitGuide guide = new MinimalVisitGuide(this.formProvider.getForm());
            guide.lead(tourist);
            this.example = tourist.getResult();
        }
        if (htmlize) {
            return Annotation.getHTMLizedString(this.example);
        }
        return this.example;
    }

    public boolean hasExampleFromAnnotation() {
        return this.hasExampleFromAnnotation;
    }

    public void setInclude(boolean include) {
        this.include = include;
    }

    public boolean getInclude() {
        return this.include;
    }

    public static String getHTMLizedString(String bracketedXML) {
        StringBuffer buf = new StringBuffer(bracketedXML);
        String newString = Annotation.replaceAllInstances(buf.toString(), "<", "&lt;");
        buf = new StringBuffer(newString);
        newString = Annotation.replaceAllInstances(buf.toString(), ">", "&gt;");
        return newString;
    }

    public static String replaceAllInstances(String string, String orig, String replacement) {
        StringBuffer buf = new StringBuffer(string);
        int repIndex = buf.indexOf(orig);
        while (repIndex != -1) {
            buf.replace(repIndex, repIndex + 1, replacement);
            repIndex = buf.indexOf(orig);
        }
        return buf.toString();
    }

    public Annotation makeCopyWithNewFormProvider(FormProvider fp) {
        Annotation copy = new Annotation();
        copy.summary = this.summary;
        copy.desc = this.desc;
        copy.deprecation = this.deprecation;
        copy.hasExampleFromAnnotation = this.hasExampleFromAnnotation;
        copy.example = this.example;
        copy.include = this.include;
        copy.vel = this.vel;
        copy.setFormProvider(fp);
        return copy;
    }
}

