/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.validator;

import edu.sc.seis.sod.validator.documenter.SchemaDocumenter;
import edu.sc.seis.sod.validator.model.Choice;
import edu.sc.seis.sod.validator.model.Definition;
import edu.sc.seis.sod.validator.model.Form;
import edu.sc.seis.sod.validator.model.GenitorForm;
import edu.sc.seis.sod.validator.model.Group;
import edu.sc.seis.sod.validator.model.Interleave;
import edu.sc.seis.sod.validator.model.MultigenitorForm;
import edu.sc.seis.sod.validator.model.NamedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ModelWalker {
    private Map<Definition, Set<Definition>> defsToContainment = new HashMap<Definition, Set<Definition>>();
    private Map<Definition, Form> defsToInstance = new HashMap<Definition, Form>();

    public ModelWalker(Form root) {
        this.populateMapCaches(root);
        this.defsToInstance.put(root.getDef(), root);
    }

    public Collection<Definition> getContainingDefs(Definition def) {
        if (!this.defsToContainment.containsKey(def)) {
            this.defsToContainment.put(def, new HashSet());
        }
        ArrayList<Definition> out = new ArrayList<Definition>();
        out.addAll((Collection)this.defsToContainment.get(def));
        Collections.sort(out, new Comparator<Definition>(){

            @Override
            public int compare(Definition o1, Definition o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return out;
    }

    public Form getInstance(Form root, Definition def) {
        return this.defsToInstance.get(def);
    }

    private void populateMapCaches(Form root) {
        if (root.isFromDef() && root.getParent() != null) {
            Definition def = root.getDef();
            if (!this.defsToContainment.containsKey(def)) {
                this.defsToContainment.put(def, new HashSet());
            }
            this.defsToInstance.put(root.getDef(), root);
            this.defsToContainment.get(def).add(SchemaDocumenter.getNearestDef(root.getParent()));
        }
        if (!ModelWalker.isSelfReferential(root) && ModelWalker.getLineage(root).length <= 9) {
            if (root instanceof GenitorForm) {
                this.populateMapCaches(((GenitorForm)root).getChild());
            } else if (root instanceof MultigenitorForm) {
                MultigenitorForm multiRoot = (MultigenitorForm)root;
                Form[] kids = multiRoot.getChildren();
                for (int i = 0; i < kids.length; ++i) {
                    this.populateMapCaches(kids[i]);
                }
            }
        }
    }

    public static boolean isSelfReferential(Form f) {
        return ModelWalker.isSelfReferential(f, null);
    }

    public static boolean isSelfReferential(Form f, Form root) {
        if (f.isFromDef() && !f.equals(root)) {
            return ModelWalker.lineageContainsRefTo(f, f.getDef(), root);
        }
        return false;
    }

    public static boolean requiresSelfReferentiality(Form f) {
        if (f.getMin() == 0) {
            return false;
        }
        if (ModelWalker.isSelfReferential(f)) {
            return true;
        }
        if (f instanceof NamedElement) {
            NamedElement el = (NamedElement)f;
            Form kid = el.getChild();
            return ModelWalker.requiresSelfReferentiality(kid);
        }
        if (f instanceof Choice) {
            Choice c = (Choice)f;
            Form[] kids = c.getChildren();
            for (int i = 0; i < kids.length; ++i) {
                if (ModelWalker.requiresSelfReferentiality(kids[i])) continue;
                return false;
            }
            return true;
        }
        if (f instanceof Interleave || f instanceof Group) {
            MultigenitorForm multi = (MultigenitorForm)f;
            Form[] kids = multi.getChildren();
            for (int i = 0; i < kids.length; ++i) {
                if (!ModelWalker.requiresSelfReferentiality(kids[i])) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean lineageContainsRefTo(Form f, Definition def) {
        return ModelWalker.lineageContainsRefTo(f, def, null);
    }

    public static boolean lineageContainsRefTo(Form f, Definition def, Form root) {
        Form parent = f.getParent();
        if (parent == null || def == null || f.equals(root)) {
            return false;
        }
        if (def.equals(parent.getDef())) {
            return true;
        }
        return ModelWalker.lineageContainsRefTo(parent, def, root);
    }

    public static NamedElement getDescendantTowards(NamedElement parent, NamedElement result) {
        Form child = parent.getChild();
        if (child instanceof NamedElement && ModelWalker.isTowards(child, result)) {
            return (NamedElement)child;
        }
        if (child instanceof MultigenitorForm) {
            return ModelWalker.getDescendantTowards((MultigenitorForm)child, result);
        }
        return null;
    }

    private static NamedElement getDescendantTowards(MultigenitorForm f, NamedElement result) {
        Form[] kids = f.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            NamedElement subresult;
            if (kids[i] instanceof NamedElement && ModelWalker.isTowards(kids[i], result)) {
                return (NamedElement)kids[i];
            }
            if (!(kids[i] instanceof MultigenitorForm) || (subresult = ModelWalker.getDescendantTowards((MultigenitorForm)kids[i], result)) == null) continue;
            return subresult;
        }
        return null;
    }

    public static boolean isTowards(Form parent, Form result) {
        boolean b = parent.isAncestorOf(result, parent) || parent.equals(result);
        return b;
    }

    public static int getDistance(Form base, Form result) {
        return ModelWalker.getDistance(base, base, result);
    }

    private static int getDistance(Form initialBase, Form base, Form result) {
        GenitorForm gf;
        int subDist;
        if (result == null) {
            return -1;
        }
        if (result.equals(base)) {
            return 0;
        }
        if (base.isFromDef() && base != initialBase) {
            Form[] lineageToInitial = ModelWalker.getLineage(base.getParent(), initialBase);
            for (int i = 0; i < lineageToInitial.length; ++i) {
                Form cur = lineageToInitial[i];
                if (!cur.isFromDef() || !cur.getDef().equals(base.getDef())) continue;
                return -1;
            }
        }
        if (base instanceof MultigenitorForm) {
            MultigenitorForm mgf = (MultigenitorForm)base;
            int minDist = Integer.MAX_VALUE;
            for (int i = 0; i < mgf.getChildren().length; ++i) {
                Form cur = mgf.getChildren()[i];
                int curDist = ModelWalker.getDistance(initialBase, cur, result);
                if (curDist >= minDist || curDist <= -1) continue;
                minDist = curDist;
            }
            if (minDist < Integer.MAX_VALUE) {
                return minDist;
            }
        } else if (base instanceof GenitorForm && (subDist = ModelWalker.getDistance(initialBase, (gf = (GenitorForm)base).getChild(), result)) > -1) {
            return subDist + 1;
        }
        return -1;
    }

    public static NamedElement[] getSiblings(NamedElement brother) {
        Form parent = brother.getParent();
        if (parent == null) {
            return new NamedElement[]{brother};
        }
        while (!(parent instanceof NamedElement)) {
            parent = parent.getParent();
        }
        return ((NamedElement)parent).getElementalChildren();
    }

    public static Form[] getLineage(Form f) {
        return ModelWalker.getLineage(f, null);
    }

    public static Form[] getLineage(Form child, Form parent) {
        ArrayList<Form> lineageList = new ArrayList<Form>();
        for (Form temp = child; temp != parent; temp = temp.getParent()) {
            lineageList.add(temp);
        }
        return lineageList.toArray(new Form[0]);
    }

    public static boolean isInLineage(Form parent, Form result) {
        Form[] lineage = ModelWalker.getLineage(result);
        for (int i = 0; i < lineage.length; ++i) {
            if (!lineage[i].equals(parent)) continue;
            return true;
        }
        return false;
    }

    public static String getNamespaceFromAncestors(Form f) {
        String ns = null;
        Form temp = f;
        do {
            ns = temp.getNamespace();
        } while ((temp = temp.getParent()) != null && ns == null);
        return ns;
    }
}

