/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.util.time;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.common.UnsupportedFormat;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.PlottableChunk;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.model.seismogram.RequestFilterUtil;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.util.time.SortTool;
import java.time.Duration;
import java.time.Instant;
import java.util.List;

public class RangeTool {
    public static final TimeRange ZERO_TIME = new TimeRange(Instant.ofEpochSecond(0L), Instant.ofEpochSecond(0L));
    public static final TimeRange ONE_TIME = new TimeRange(Instant.ofEpochMilli(0L), Instant.ofEpochMilli(1L));

    public static boolean areContiguous(PlottableChunk one, PlottableChunk two) {
        Duration sampleInterval = Duration.ofNanos(0L);
        return RangeTool.areContiguous(one.getTimeRange(), two.getTimeRange(), sampleInterval);
    }

    public static boolean areContiguous(LocalSeismogramImpl one, LocalSeismogramImpl two) {
        LocalSeismogramImpl second;
        LocalSeismogramImpl first;
        Object oneS = "one ";
        Object twoS = "two ";
        try {
            oneS = (String)oneS + TimeUtils.toISOString((Instant)one.begin_time);
            twoS = (String)twoS + TimeUtils.toISOString((Instant)two.begin_time);
            Instant oneB = one.getBeginTime();
            Instant instant = two.getBeginTime();
        }
        catch (UnsupportedFormat ee) {
            throw new RuntimeException((String)oneS + " " + (String)twoS, ee);
        }
        if (one.getBeginTime().isBefore(two.getBeginTime())) {
            first = one;
            second = two;
        } else {
            first = two;
            second = one;
        }
        TimeRange firstRange = new TimeRange(first);
        return RangeTool.areContiguous(new TimeRange(firstRange.getBeginTime(), firstRange.getEndTime().plus(one.getSampling().getPeriod().dividedBy(2L))), new TimeRange(second), first.getSampling().getPeriod());
    }

    public static boolean areContiguous(RequestFilter one, RequestFilter two) {
        return RangeTool.areContiguous(new TimeRange(one), new TimeRange(two));
    }

    public static boolean areContiguous(TimeRange one, TimeRange two, Duration interval) {
        if (!RangeTool.areOverlapping(one, two)) {
            Duration littleMoreThanInterval = interval.plus(Duration.ofNanos(1000L));
            if (one.getEndTime().isBefore(two.getBeginTime())) {
                return one.getEndTime().plus(littleMoreThanInterval).isAfter(two.getBeginTime());
            }
            return two.getEndTime().isBefore(one.getBeginTime()) && two.getEndTime().plus(littleMoreThanInterval).isAfter(one.getBeginTime());
        }
        return false;
    }

    public static boolean areContiguous(TimeRange one, TimeRange two) {
        return one.getEndTime().equals(two.getBeginTime()) || one.getBeginTime().equals(two.getEndTime());
    }

    public static boolean areOverlapping(PlottableChunk one, PlottableChunk two) {
        return RangeTool.areOverlapping(one.getTimeRange(), two.getTimeRange());
    }

    public static boolean areOverlapping(TimeRange one, TimeRange two) {
        return one.getBeginTime().isBefore(two.getEndTime()) && one.getEndTime().isAfter(two.getBeginTime());
    }

    public static boolean areOverlapping(LocalSeismogramImpl one, LocalSeismogramImpl two) {
        TimeRange oneTr = new TimeRange(one.getBeginTime(), one.getEndTime());
        TimeRange twoTr = new TimeRange(two.getBeginTime(), two.getEndTime());
        return RangeTool.areOverlapping(oneTr, twoTr);
    }

    public static boolean seisPartOfRequest(RequestFilter rf, LocalSeismogramImpl seis) {
        if (RequestFilterUtil.containsWildcard(rf)) {
            throw new IllegalArgumentException("RequestFilter must not contain wildcards: " + RequestFilterUtil.toString(rf));
        }
        return ChannelIdUtil.areEqualExceptForBeginTime(rf.getChannelId(), seis.getChannelID()) && RangeTool.areOverlapping(new TimeRange(rf), new TimeRange(seis));
    }

    public static TimeRange getFullTime(LocalSeismogramImpl[] seis) {
        if (seis.length == 0) {
            return ZERO_TIME;
        }
        Instant beginTime = SortTool.byBeginTimeAscending(seis)[0].getBeginTime();
        Instant endTime = TimeUtils.wayPast;
        for (int i = 0; i < seis.length; ++i) {
            if (!seis[i].getEndTime().isAfter(endTime)) continue;
            endTime = seis[i].getEndTime();
        }
        return new TimeRange(beginTime, endTime);
    }

    public static TimeRange getFullTime(RequestFilter[] seis) {
        Instant beginTime;
        if (seis.length == 0) {
            return ZERO_TIME;
        }
        Instant endTime = beginTime = SortTool.byBeginTimeAscending((RequestFilter[])seis)[0].startTime;
        for (int i = 0; i < seis.length; ++i) {
            if (!seis[i].endTime.isAfter(endTime)) continue;
            endTime = seis[i].endTime;
        }
        return new TimeRange(beginTime, endTime);
    }

    public static TimeRange getFullTime(List<PlottableChunk> pc) {
        Instant beginTime;
        if (pc.size() == 0) {
            return ZERO_TIME;
        }
        Instant endTime = beginTime = SortTool.byBeginTimeAscending(pc).get(0).getBeginTime();
        for (PlottableChunk plottableChunk : pc) {
            if (!plottableChunk.getEndTime().isAfter(endTime)) continue;
            endTime = plottableChunk.getEndTime();
        }
        return new TimeRange(beginTime, endTime);
    }
}

