/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.util.time;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.util.exceptionHandler.GlobalExceptionHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClockUtil {
    public static final long NANO = 1000000000L;
    private static boolean warnServerFail = false;
    private static boolean warnBadBadClock = false;
    private static Duration serverOffset = null;
    private static final Duration ZERO_OFFSET = Duration.ofNanos(0L);
    private static URL SEIS_SC_EDU_URL;
    private static Instant OLD_DATE;
    private static final Logger logger;

    public static Duration getTimeOffset() {
        if (serverOffset == null) {
            if (warnServerFail) {
                return ZERO_OFFSET;
            }
            try {
                serverOffset = ClockUtil.getServerTimeOffset();
            }
            catch (Throwable e) {
                ClockUtil.noGoClock(e);
                return ZERO_OFFSET;
            }
        }
        return serverOffset;
    }

    private static void noGoClock(Throwable e) {
        warnServerFail = true;
        logger.debug("Unable to make a connection to " + String.valueOf(SEIS_SC_EDU_URL) + " to verify system clock, assuming offset is zero.", e);
        logger.warn("Unable to make a connection to " + String.valueOf(SEIS_SC_EDU_URL) + " to verify system clock, assuming offset is zero.");
        Instant localNow = Instant.now();
        if (!warnBadBadClock && OLD_DATE.isAfter(localNow)) {
            warnBadBadClock = true;
            GlobalExceptionHandler.handle("Unable to check the time from the server and the computer's clock is obviously wrong. Please reset the clock on your computer to be closer to real time. \nComputer Time=" + String.valueOf(localNow) + "\nTime checking url=" + String.valueOf(SEIS_SC_EDU_URL), e);
        }
    }

    public static Instant now() {
        return Instant.now().plus(ClockUtil.getTimeOffset());
    }

    public static Instant tomorrow() {
        return ClockUtil.now().plus(TimeUtils.ONE_DAY);
    }

    public static Instant yesterday() {
        return ClockUtil.now().minus(TimeUtils.ONE_DAY);
    }

    public static Instant lastWeek() {
        return ClockUtil.now().minus(TimeUtils.ONE_WEEK);
    }

    public static Instant lastMonth() {
        return ClockUtil.now().minus(TimeUtils.ONE_MONTH);
    }

    @Deprecated
    public static Instant wayPast() {
        return TimeUtils.wayPast;
    }

    @Deprecated
    public static Instant wayFuture() {
        return TimeUtils.future;
    }

    public static Duration getServerTimeOffset() throws IOException {
        String str;
        HttpURLConnection conn = (HttpURLConnection)SEIS_SC_EDU_URL.openConnection();
        conn.setReadTimeout(10000);
        InputStream is = conn.getInputStream();
        InputStreamReader isReader = new InputStreamReader(is);
        BufferedReader bufferedReader = new BufferedReader(isReader);
        String timeStr = null;
        while ((str = bufferedReader.readLine()) != null) {
            timeStr = str;
        }
        Instant localTime = Instant.now();
        Instant serverTime = TimeUtils.parseISOString((String)timeStr);
        return Duration.between(localTime, serverTime);
    }

    public static boolean lessThan(Duration first, Duration second) {
        return first.compareTo(second) < 0;
    }

    public static Instant parseISOString(String time) {
        return TimeUtils.parseISOString((String)time);
    }

    public static String formatDuration(Instant before, Instant after) {
        return (float)Duration.between(before, after).toMillis() / 1000.0f + " sec";
    }

    public static Duration difference(Instant before, Instant after) {
        return Duration.between(before, after).abs();
    }

    public static String format(Duration d) {
        return d.toString();
    }

    public static float floatSeconds(Duration d) {
        return (float)ClockUtil.doubleSeconds(d);
    }

    public static double doubleSeconds(Duration d) {
        return (double)d.getSeconds() + (double)d.getNano() / 1.0E9;
    }

    public static Duration durationOfSeconds(double value) {
        long seconds = (long)Math.floor(value);
        long remainder = Math.round((value - (double)seconds) * 1.0E9);
        return Duration.ofSeconds(seconds, remainder);
    }

    public static Duration durationFrom(double value, UnitImpl unit) {
        QuantityImpl q = new QuantityImpl(value, unit);
        return Duration.ofNanos(Math.round(q.getValue(UnitImpl.NANOSECOND)));
    }

    public static Duration durationFrom(QuantityImpl q) {
        return Duration.ofNanos(Math.round(q.getValue(UnitImpl.NANOSECOND)));
    }

    static {
        try {
            SEIS_SC_EDU_URL = new URL("http://www.seis.sc.edu/cgi-bin/date_time.pl");
        }
        catch (MalformedURLException e) {
            GlobalExceptionHandler.handle("Caught MalformedURL with seis data_time.pl URL. This should never happen.", e);
        }
        OLD_DATE = TimeUtils.parseISOString((String)"2017-08-14T00:00:00.000Z");
        logger = LoggerFactory.getLogger(ClockUtil.class);
    }
}

