/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.util.streampump;

import edu.sc.seis.sod.util.exceptionHandler.GlobalExceptionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;

public class StreamPump
extends Thread {
    private Reader in;
    private Writer out;
    private boolean hasCompleted = false;
    private boolean closeOnExit;

    public StreamPump(InputStream in) {
        this(in, null);
    }

    public StreamPump(Reader in) {
        this(in, null, false);
    }

    public StreamPump(InputStream in, Writer out) {
        this(new InputStreamReader(in), out, false);
    }

    public StreamPump(Reader in, Writer out, boolean closeOnExit) {
        this.in = in;
        this.out = out;
        this.closeOnExit = closeOnExit;
    }

    @Override
    public synchronized void run() {
        try {
            char[] cbuf = new char[512];
            int numRead = 0;
            while ((numRead = this.in.read(cbuf)) != -1) {
                if (this.out == null) continue;
                this.out.write(cbuf, 0, numRead);
            }
            if (this.out != null) {
                this.out.flush();
            }
        }
        catch (Throwable e) {
            GlobalExceptionHandler.handle(e);
        }
        finally {
            if (this.out != null && this.closeOnExit) {
                try {
                    this.out.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        this.hasCompleted = true;
    }

    public boolean hasCompleted() {
        return this.hasCompleted;
    }
}

