/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.util.exceptionHandler;

import edu.sc.seis.sod.util.exceptionHandler.ExceptionReporter;
import edu.sc.seis.sod.util.exceptionHandler.ExceptionReporterUtils;
import edu.sc.seis.sod.util.exceptionHandler.FileWriterReporter;
import edu.sc.seis.sod.util.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.util.exceptionHandler.Section;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIReporter
implements ExceptionReporter {
    private boolean atMostOneAtATime = true;
    private JFrame displayFrame;
    private static Section greeting;
    private String message;
    private Throwable e;
    private List sections;
    private JPanel displayPanel;
    private static Logger logger;

    @Override
    public void report(String message, Throwable e, List sections) {
        if (this.displayFrame != null) {
            if (this.atMostOneAtATime) {
                return;
            }
            this.displayFrame = null;
            this.displayPanel = null;
        }
        this.message = message;
        this.e = e;
        this.sections = sections;
        this.createFrame();
        this.displayPanel.add((Component)this.createGUI(e, message, sections), "Center");
        this.displayPanel.revalidate();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUIReporter.this.displayFrame.pack();
                GUIReporter.this.displayFrame.show();
            }
        });
    }

    public void setAtMostOneAtATime(boolean b) {
        this.atMostOneAtATime = b;
    }

    private JTabbedPane createGUI(Throwable e, String message, List sections) {
        JTabbedPane tabbedPane = new JTabbedPane();
        if (greeting != null) {
            tabbedPane.addTab(greeting.getName(), GUIReporter.createTextArea(greeting.getContents()));
        }
        tabbedPane.addTab("Details", GUIReporter.createTextArea(message));
        tabbedPane.addTab("Stack Trace", GUIReporter.createTextArea(ExceptionReporterUtils.getTrace(e)));
        for (Section sec : sections) {
            tabbedPane.addTab(sec.getName(), GUIReporter.createTextArea(sec.getContents()));
        }
        Dimension dimension = new Dimension(800, 300);
        tabbedPane.setPreferredSize(dimension);
        tabbedPane.setMinimumSize(dimension);
        return tabbedPane;
    }

    private static JScrollPane createTextArea(String message) {
        JTextArea messageArea = new JTextArea();
        messageArea.setLineWrap(true);
        messageArea.setFont(new Font("Serif", 0, 14));
        messageArea.setWrapStyleWord(true);
        messageArea.setEditable(false);
        if (message != null) {
            messageArea.setText(message);
        }
        return new JScrollPane(messageArea);
    }

    private void createFrame() {
        this.displayFrame = new JFrame();
        this.displayFrame.setDefaultCloseOperation(2);
        this.displayFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GUIReporter.this.displayPanel = null;
                GUIReporter.this.displayFrame = null;
            }
        });
        this.displayPanel = new JPanel(new BorderLayout());
        this.displayPanel.add((Component)this.createButtonPanel(), "South");
        Dimension dimension = new Dimension(800, 400);
        this.displayPanel.setPreferredSize(dimension);
        this.displayFrame.setContentPane(this.displayPanel);
        this.displayFrame.setSize(dimension);
    }

    private JPanel createButtonPanel() {
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIReporter.this.displayFrame.dispose();
                GUIReporter.this.displayFrame = null;
                GUIReporter.this.displayPanel = null;
            }
        });
        JButton saveToFile = new JButton("Save");
        saveToFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                block2: {
                    try {
                        this.writeFile();
                    }
                    catch (IOException e) {
                        int result = JOptionPane.showConfirmDialog(GUIReporter.this.displayPanel, "We were unable to write to that file. Try again?", "Trouble writing exception file", 2, 2);
                        if (result != 0) break block2;
                        this.actionPerformed(null);
                    }
                }
            }

            public void writeFile() throws IOException {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setSelectedFile(new File(ExceptionReporterUtils.getClassName(GUIReporter.this.e) + ".txt"));
                int rtnVal = fileChooser.showSaveDialog(GUIReporter.this.displayPanel);
                if (rtnVal == 0) {
                    FileWriterReporter writer = new FileWriterReporter(fileChooser.getSelectedFile().getAbsoluteFile());
                    writer.report(GUIReporter.this.message, GUIReporter.this.e, GUIReporter.this.sections);
                }
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(closeButton);
        buttonPanel.add(saveToFile);
        return buttonPanel;
    }

    private static void setGreeting(String title, String contents) {
        greeting = new Section(title, contents);
    }

    public static void appendToGreeting(String title, String contents) {
        if (greeting == null) {
            GUIReporter.setGreeting(title, contents);
        } else {
            greeting.setContents(greeting.getContents() + contents);
        }
    }

    public static void swapGreetingAndHandle(Throwable t, String temporaryGreeting) {
        Section currentGreeting = greeting;
        GUIReporter.setGreeting("Information", temporaryGreeting);
        GlobalExceptionHandler.handle(t);
        greeting = currentGreeting;
    }

    static {
        logger = LoggerFactory.getLogger(GUIReporter.class);
    }
}

