/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.util.exceptionHandler;

import edu.sc.seis.sod.util.exceptionHandler.ExceptionReporter;
import edu.sc.seis.sod.util.exceptionHandler.ExceptionReporterUtils;
import edu.sc.seis.sod.util.exceptionHandler.Section;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class FileWriterReporter
implements ExceptionReporter {
    private File file;

    public FileWriterReporter(File file) {
        this.setFile(file);
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public void report(String message, Throwable e, List sections) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.file));
        String str = message + "\n\n";
        String stackTrace = "Stack Trace";
        str = str + stackTrace + this.makeDivider(stackTrace.length()) + ExceptionReporterUtils.getTrace(e);
        bw.write(this.constructString(str, sections));
        bw.close();
    }

    private String constructString(String initialBit, List sections) {
        Iterator it = sections.iterator();
        while (it.hasNext()) {
            initialBit = (String)initialBit + "\n" + this.constructString((Section)it.next());
        }
        return initialBit;
    }

    private String constructString(Section sec) {
        String result = sec.getName() + this.makeDivider(sec.getName().length());
        result = result + sec.getContents();
        return result;
    }

    private String makeDivider(int len) {
        StringBuffer div = new StringBuffer(len + 2);
        div.append('\n');
        for (int i = 0; i < len; ++i) {
            div.append('=');
        }
        div.append('\n');
        return div.toString();
    }
}

