/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.util.exceptionHandler;

import edu.sc.seis.sod.util.exceptionHandler.Extractor;
import edu.sc.seis.sod.util.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.util.time.ClockUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class ExceptionReporterUtils {
    private static final long MB = 0x100000L;

    public static String getTrace(Throwable exception) {
        Object traceString = "";
        List extractors = GlobalExceptionHandler.getExtractors();
        for (Extractor ext : extractors) {
            if (!ext.canExtract(exception)) continue;
            traceString = (String)traceString + ext.extract(exception) + "\n";
            Throwable t = ext.getSubThrowable(exception);
            if (t == null) continue;
            traceString = (String)traceString + ExceptionReporterUtils.getTrace(t) + "\n";
        }
        traceString = (String)traceString + ExceptionReporterUtils.extractTrace(exception);
        return traceString;
    }

    public static String getSysInfo() {
        Object sysInfo = "";
        sysInfo = (String)sysInfo + "Date : " + new Date().toString() + "\n";
        sysInfo = (String)sysInfo + "Date(GMT) : " + ClockUtil.now().toString() + "\n";
        try {
            sysInfo = (String)sysInfo + "Server offset : " + String.valueOf(ClockUtil.getServerTimeOffset()) + "\n";
        }
        catch (IOException e) {
            sysInfo = (String)sysInfo + "Server offset : " + e.toString() + "\n";
        }
        sysInfo = (String)sysInfo + "os.name : " + System.getProperty("os.name") + "\n";
        sysInfo = (String)sysInfo + "os.version : " + System.getProperty("os.version") + "\n";
        sysInfo = (String)sysInfo + "os.arch : " + System.getProperty("os.arch") + "\n";
        sysInfo = (String)sysInfo + "java.runtime.version : " + System.getProperty("java.runtime.version") + "\n";
        sysInfo = (String)sysInfo + "java.class.version : " + System.getProperty("java.class.version") + "\n";
        sysInfo = (String)sysInfo + "java.class.path : " + System.getProperty("java.class.path") + "\n";
        sysInfo = (String)sysInfo + "edu.sc.seis.gee.configuration : " + System.getProperty("edu.sc.seis.gee.configuration") + "\n";
        sysInfo = (String)sysInfo + "user.name : " + System.getProperty("user.name") + "\n";
        sysInfo = (String)sysInfo + "user.timeZone : " + System.getProperty("user.timeZone") + "\n";
        sysInfo = (String)sysInfo + "user.region : " + System.getProperty("user.region") + "\n";
        sysInfo = (String)sysInfo + "Memory : " + ExceptionReporterUtils.getMemoryUsage() + "\n";
        sysInfo = (String)sysInfo + "\n\n\n Other Properties:\n";
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Properties props = System.getProperties();
        props.list(printWriter);
        printWriter.close();
        sysInfo = (String)sysInfo + String.valueOf(stringWriter.getBuffer());
        return sysInfo;
    }

    private static String extractTrace(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public static String getClassName(Object o) {
        String defaultName = o.getClass().toString();
        int lastPeriod = defaultName.lastIndexOf(".");
        if (lastPeriod != -1) {
            defaultName = defaultName.substring(++lastPeriod);
        }
        return defaultName;
    }

    public static String getMemoryUsage() {
        return (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L + "/" + Runtime.getRuntime().totalMemory() / 0x100000L + "/" + Runtime.getRuntime().maxMemory() / 0x100000L + " Mb";
    }
}

