/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.util.exceptionHandler;

import edu.sc.seis.sod.util.exceptionHandler.ExceptionInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassExceptionInterceptor
implements ExceptionInterceptor {
    Class<? extends Throwable> exceptionClass;
    private static Logger logger = LoggerFactory.getLogger(ClassExceptionInterceptor.class);

    public ClassExceptionInterceptor(Class<? extends Throwable> exceptionClass) {
        logger.info("GlobalExceptionHandler ignoring " + exceptionClass.getName());
        this.exceptionClass = exceptionClass;
    }

    @Override
    public boolean handle(String message, Throwable t) {
        if (this.exceptionClass.isInstance(t) || this.exceptionClass.isInstance(t.getCause())) {
            logger.info(this.exceptionClass.getName() + ", ignoring.", t);
            return true;
        }
        return false;
    }
}

