/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.util.display;

import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.common.UnitRangeImpl;
import edu.sc.seis.sod.util.display.ThreadSafeDecimalFormat;
import java.text.NumberFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitDisplayUtil {
    public static final String mu = "\u03bc";
    static final ThreadSafeDecimalFormat quantityFormat = new ThreadSafeDecimalFormat("#,###,##0.0##; -#,###,##0.0##");
    static Logger logger = LoggerFactory.getLogger(UnitDisplayUtil.class);

    public static QuantityImpl getBestForDisplay(QuantityImpl quantity) {
        UnitRangeImpl inRange = new UnitRangeImpl(quantity.getValue(), quantity.getValue(), quantity.getUnit());
        inRange = UnitDisplayUtil.getBestForDisplay(inRange);
        return new QuantityImpl(inRange.getMinValue(), inRange.getUnit());
    }

    public static UnitRangeImpl getBestForDisplay(UnitRangeImpl inRange) {
        UnitRangeImpl outRange = inRange;
        if (inRange.getUnit().isConvertableTo(UnitImpl.METER_PER_SECOND)) {
            if (Math.abs((inRange = inRange.convertTo(UnitImpl.METER_PER_SECOND)).getMinValue()) < 1.0E-6 && Math.abs(inRange.getMaxValue()) < 1.0E-6) {
                outRange = inRange.convertTo(UnitImpl.NANOMETER_PER_SECOND);
            } else if (Math.abs(inRange.getMinValue()) < 0.001 && Math.abs(inRange.getMaxValue()) < 0.001) {
                outRange = inRange.convertTo(UnitImpl.MICRON_PER_SECOND);
            } else if (Math.abs(inRange.getMinValue()) < 1.0 && Math.abs(inRange.getMaxValue()) < 1.0) {
                outRange = inRange.convertTo(UnitImpl.MILLIMETER_PER_SECOND);
            }
        } else if (inRange.getUnit().isConvertableTo(UnitImpl.METER)) {
            if (Math.abs((inRange = inRange.convertTo(UnitImpl.METER)).getMinValue()) < 1.0E-6 && Math.abs(inRange.getMaxValue()) < 1.0E-6) {
                outRange = inRange.convertTo(UnitImpl.NANOMETER);
            } else if (Math.abs(inRange.getMinValue()) < 0.001 && Math.abs(inRange.getMaxValue()) < 0.001) {
                outRange = inRange.convertTo(UnitImpl.MICRON);
            } else if (Math.abs(inRange.getMinValue()) < 1.0 && Math.abs(inRange.getMaxValue()) < 1.0) {
                outRange = inRange.convertTo(UnitImpl.MILLIMETER);
            }
        } else if (inRange.getUnit().isConvertableTo(UnitImpl.METER_PER_SECOND_PER_SECOND)) {
            if (Math.abs((inRange = inRange.convertTo(UnitImpl.METER_PER_SECOND_PER_SECOND)).getMinValue()) < 1.0E-6 && Math.abs(inRange.getMaxValue()) < 1.0E-6) {
                outRange = inRange.convertTo(UnitImpl.NANOMETER_PER_SECOND_PER_SECOND);
            } else if (Math.abs(inRange.getMinValue()) < 0.001 && Math.abs(inRange.getMaxValue()) < 0.001) {
                outRange = inRange.convertTo(UnitImpl.MICROMETER_PER_SECOND_PER_SECOND);
            } else if (Math.abs(inRange.getMinValue()) < 1.0 && Math.abs(inRange.getMaxValue()) < 1.0) {
                outRange = inRange.convertTo(UnitImpl.MILLIMETER_PER_SECOND_PER_SECOND);
            }
        } else if (inRange.getUnit().isConvertableTo(UnitImpl.COUNT)) {
            outRange = Math.abs((inRange = inRange.convertTo(UnitImpl.COUNT)).getMinValue()) < 0.001 && Math.abs(inRange.getMaxValue()) < 0.001 ? inRange.convertTo(UnitImpl.MICROCOUNT) : (Math.abs(inRange.getMinValue()) < 1.0 && Math.abs(inRange.getMaxValue()) < 1.0 ? inRange.convertTo(UnitImpl.MILLICOUNT) : (Math.abs(inRange.getMinValue()) < 1000.0 && Math.abs(inRange.getMaxValue()) < 1000.0 ? inRange.convertTo(UnitImpl.COUNT) : (Math.abs(inRange.getMinValue()) < 1000000.0 && Math.abs(inRange.getMaxValue()) < 1000000.0 ? inRange.convertTo(UnitImpl.KILOCOUNT) : inRange.convertTo(UnitImpl.MEGACOUNT))));
        }
        return outRange;
    }

    public static String getNameForUnit(UnitImpl unit) {
        if (unit.equals(UnitImpl.METER_PER_SECOND)) {
            return "m/s";
        }
        if (unit.equals(UnitImpl.MICRON_PER_SECOND)) {
            return "microns/sec";
        }
        if (unit.equals(UnitImpl.MILLIMETER_PER_SECOND)) {
            return "mm/s";
        }
        if (unit.equals(UnitImpl.NANOMETER_PER_SECOND)) {
            return "nm/s";
        }
        if (unit.equals(UnitImpl.KILOMETER_PER_SECOND)) {
            return "km/s";
        }
        if (unit.equals(UnitImpl.KILOMETER)) {
            return "km";
        }
        if (unit.equals(UnitImpl.METER)) {
            return "m";
        }
        if (unit.equals(UnitImpl.MILLIMETER)) {
            return "mm";
        }
        if (unit.equals(UnitImpl.MICROMETER)) {
            return "micrometers";
        }
        if (unit.equals(UnitImpl.NANOMETER)) {
            return "nanometers";
        }
        if (unit.equals(UnitImpl.METER_PER_SECOND_PER_SECOND)) {
            return "m/s/s";
        }
        if (unit.equals(UnitImpl.MILLIMETER_PER_SECOND_PER_SECOND)) {
            return "mm/s/s";
        }
        if (unit.equals(UnitImpl.MICROMETER_PER_SECOND_PER_SECOND)) {
            return "microns/s/s";
        }
        if (unit.equals(UnitImpl.NANOMETER_PER_SECOND_PER_SECOND)) {
            return "nm/s/s";
        }
        if (unit.equals(UnitImpl.SECOND)) {
            return "s";
        }
        if (unit.equals(UnitImpl.DEGREE)) {
            return "deg";
        }
        if (unit.equals(UnitImpl.COUNT)) {
            return "COUNTS";
        }
        if (unit.equals(UnitImpl.MILLICOUNT)) {
            return "COUNTS x 10^-3";
        }
        if (unit.equals(UnitImpl.MICROCOUNT)) {
            return "COUNTS x 10^-6";
        }
        if (unit.equals(UnitImpl.KILOCOUNT)) {
            return "COUNTS x 10^3";
        }
        if (unit.equals(UnitImpl.MEGACOUNT)) {
            return "COUNTS x 10^6";
        }
        if (unit.equals(UnitImpl.DIMENSONLESS)) {
            return "";
        }
        return unit.toString();
    }

    public static String formatQuantityImpl(QuantityImpl quantity) {
        return UnitDisplayUtil.formatQuantityImpl(quantity, quantityFormat);
    }

    public static String formatQuantityImpl(QuantityImpl quantity, NumberFormat format, UnitImpl preferredUnit) {
        if (quantity.getUnit().isConvertableTo(preferredUnit)) {
            quantity = quantity.convertTo(preferredUnit);
        }
        return UnitDisplayUtil.formatQuantityImpl(quantity, format);
    }

    public static String formatQuantityImpl(QuantityImpl quantity, NumberFormat format) {
        if (quantity != null) {
            return format.format(quantity.getValue()) + " " + UnitDisplayUtil.getNameForUnit(quantity.getUnit()).toLowerCase();
        }
        return "...";
    }
}

